/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.component;

import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.test.component.MockBeanConfigurator;
import io.quarkus.test.component.MockBeanConfiguratorImpl;
import io.quarkus.test.component.QuarkusComponentTestConfiguration;
import io.quarkus.test.component.QuarkusComponentTestExtension;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.spi.Converter;

public class QuarkusComponentTestExtensionBuilder {
    public static final int DEFAULT_CONFIG_SOURCE_ORDINAL = 500;
    private final Map<String, String> configProperties = new HashMap<String, String>();
    private final Set<Class<?>> componentClasses = new HashSet();
    private final List<MockBeanConfiguratorImpl<?>> mockConfigurators = new ArrayList();
    private final List<AnnotationsTransformer> annotationsTransformers = new ArrayList<AnnotationsTransformer>();
    private final List<Converter<?>> configConverters = new ArrayList();
    private boolean useDefaultConfigProperties = false;
    private boolean useSystemConfigSources = false;
    private boolean addNestedClassesAsComponents = true;
    private int configSourceOrdinal = 500;
    private Consumer<SmallRyeConfigBuilder> configBuilderCustomizer;
    private boolean buildShouldFail;

    public QuarkusComponentTestExtensionBuilder addComponentClasses(Class<?> ... componentClasses) {
        Collections.addAll(this.componentClasses, componentClasses);
        return this;
    }

    public QuarkusComponentTestExtensionBuilder configProperty(String key, String value) {
        this.configProperties.put(key, value);
        return this;
    }

    public QuarkusComponentTestExtensionBuilder useDefaultConfigProperties() {
        this.useDefaultConfigProperties = true;
        return this;
    }

    public QuarkusComponentTestExtensionBuilder ignoreNestedClasses() {
        this.addNestedClassesAsComponents = false;
        return this;
    }

    public QuarkusComponentTestExtensionBuilder setConfigSourceOrdinal(int val) {
        this.configSourceOrdinal = val;
        return this;
    }

    public QuarkusComponentTestExtensionBuilder addAnnotationsTransformer(AnnotationsTransformer transformer) {
        this.annotationsTransformers.add(transformer);
        return this;
    }

    public QuarkusComponentTestExtensionBuilder addConverter(Converter<?> converter) {
        this.configConverters.add(converter);
        return this;
    }

    public QuarkusComponentTestExtensionBuilder setConfigBuilderCustomizer(Consumer<SmallRyeConfigBuilder> customizer) {
        this.configBuilderCustomizer = customizer;
        return this;
    }

    public QuarkusComponentTestExtensionBuilder useSystemConfigSources(boolean value) {
        this.useSystemConfigSources = value;
        return this;
    }

    public <T> MockBeanConfigurator<T> mock(Class<T> beanClass) {
        return new MockBeanConfiguratorImpl(this, beanClass);
    }

    QuarkusComponentTestExtensionBuilder buildShouldFail() {
        this.buildShouldFail = true;
        return this;
    }

    public QuarkusComponentTestExtension build() {
        List<Converter<?>> converters;
        if (this.configConverters.isEmpty()) {
            converters = QuarkusComponentTestConfiguration.DEFAULT_CONVERTERS;
        } else {
            converters = new ArrayList(QuarkusComponentTestConfiguration.DEFAULT_CONVERTERS);
            converters.addAll(this.configConverters);
            converters = List.copyOf(converters);
        }
        return new QuarkusComponentTestExtension(new QuarkusComponentTestConfiguration(Map.copyOf(this.configProperties), Set.copyOf(this.componentClasses), List.copyOf(this.mockConfigurators), this.useDefaultConfigProperties, this.addNestedClassesAsComponents, this.configSourceOrdinal, List.copyOf(this.annotationsTransformers), converters, this.configBuilderCustomizer, this.useSystemConfigSources), this.buildShouldFail);
    }

    void registerMockBean(MockBeanConfiguratorImpl<?> mock) {
        this.mockConfigurators.add(mock);
    }
}

