/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jacoco.runtime;

import io.quarkus.jacoco.runtime.DataFileWatch;
import io.quarkus.jacoco.runtime.JacocoConfig;
import io.quarkus.jacoco.runtime.ReportInfo;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.tools.ExecFileLoader;
import org.jacoco.report.DirectorySourceFileLocator;
import org.jacoco.report.FileMultiReportOutput;
import org.jacoco.report.IMultiReportOutput;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.MultiReportVisitor;
import org.jacoco.report.MultiSourceFileLocator;
import org.jacoco.report.csv.CSVFormatter;
import org.jacoco.report.html.HTMLFormatter;
import org.jacoco.report.xml.XMLFormatter;

public class ReportCreator
implements Runnable {
    private final ReportInfo reportInfo;
    private final JacocoConfig config;
    private final DataFileWatch dataFileWatch;

    public ReportCreator(ReportInfo reportInfo, JacocoConfig config) {
        this.reportInfo = reportInfo;
        this.config = config;
        this.dataFileWatch = new DataFileWatch(reportInfo.dataFile, () -> !ReportCreator.jacocoRunning(), reportInfo::emitError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Class<ExecFileLoader> clazz = ExecFileLoader.class;
        synchronized (ExecFileLoader.class) {
            this.doRun();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void doRun() {
        Path targetDir = Paths.get(this.reportInfo.reportDir, new String[0]);
        try {
            Files.createDirectories(targetDir, new FileAttribute[0]);
            if (!this.dataFileWatch.waitForDataFile()) {
                this.reportInfo.emitError("Jacoco data file " + String.valueOf(this.reportInfo.dataFile) + " may not have been updated, because either the file has never been written or the file has not been updated or the jacoco shutdown hook did not finish after 10 seconds.\nIf you experience EOFExceptions and/or delays after the last test run, the recommended work around is to disable report generation by setting `quarkus.jacoco.report=false` and add report generation tasks to your Maven/Gradle builds.");
            }
            ExecFileLoader loader = new ExecFileLoader();
            for (String i : this.reportInfo.savedData) {
                File file = new File(i);
                if (!file.exists()) continue;
                loader.load(file);
            }
            CoverageBuilder builder = new CoverageBuilder();
            Analyzer analyzer = new Analyzer(loader.getExecutionDataStore(), (ICoverageVisitor)builder);
            for (String i : this.reportInfo.classFiles) {
                File file = new File(i);
                if (!file.exists()) continue;
                analyzer.analyzeAll(file);
            }
            ArrayList<IReportVisitor> formatters = new ArrayList<IReportVisitor>();
            this.addXmlFormatter(targetDir.resolve("jacoco.xml"), this.config.outputEncoding(), formatters);
            this.addCsvFormatter(targetDir.resolve("jacoco.csv"), this.config.outputEncoding(), formatters);
            this.addHtmlFormatter(targetDir, this.config.outputEncoding(), this.config.footer().orElse(""), Locale.getDefault(), formatters);
            MultiReportVisitor visitor = new MultiReportVisitor(formatters);
            visitor.visitInfo(loader.getSessionInfoStore().getInfos(), loader.getExecutionDataStore().getContents());
            MultiSourceFileLocator sourceFileLocator = new MultiSourceFileLocator(4);
            for (String i : this.reportInfo.sourceDirectories) {
                sourceFileLocator.add((ISourceFileLocator)new DirectorySourceFileLocator(new File(i), this.config.sourceEncoding(), 4));
            }
            IBundleCoverage bundle = builder.getBundle(this.config.title().orElse(this.reportInfo.artifactId));
            visitor.visitBundle(bundle, (ISourceFileLocator)sourceFileLocator);
            visitor.visitEnd();
            System.out.println("Generated Jacoco reports in " + String.valueOf(targetDir));
            System.out.flush();
        }
        catch (Exception e) {
            this.reportInfo.emitError("Failed to generate Jacoco reports", e);
        }
    }

    private static boolean jacocoRunning() {
        try {
            ManagementFactory.getPlatformMBeanServer().getObjectInstance(new ObjectName("org.jacoco:type=Runtime"));
            return true;
        }
        catch (InstanceNotFoundException e) {
            return false;
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public void addXmlFormatter(Path targetFile, String encoding, List<IReportVisitor> formatters) throws IOException {
        XMLFormatter xml = new XMLFormatter();
        xml.setOutputEncoding(encoding);
        formatters.add(xml.createVisitor(Files.newOutputStream(targetFile, new OpenOption[0])));
    }

    public void addCsvFormatter(Path targetFile, String encoding, List<IReportVisitor> formatters) throws IOException {
        CSVFormatter csv = new CSVFormatter();
        csv.setOutputEncoding(encoding);
        formatters.add(csv.createVisitor(Files.newOutputStream(targetFile, new OpenOption[0])));
    }

    public void addHtmlFormatter(Path targetDir, String encoding, String footer, Locale locale, List<IReportVisitor> formatters) throws IOException {
        HTMLFormatter htmlFormatter = new HTMLFormatter();
        htmlFormatter.setOutputEncoding(encoding);
        htmlFormatter.setLocale(locale);
        if (footer != null) {
            htmlFormatter.setFooterText(footer);
        }
        formatters.add(htmlFormatter.createVisitor((IMultiReportOutput)new FileMultiReportOutput(targetDir.toFile())));
    }
}

