/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.dev;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.hibernate.LockOptions;
import org.hibernate.boot.query.NamedHqlQueryDefinition;
import org.hibernate.boot.query.NamedNativeQueryDefinition;
import org.hibernate.boot.query.NamedQueryDefinition;
import org.hibernate.boot.spi.AbstractNamedQueryDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;

public class HibernateOrmDevInfo {
    private final Map<String, PersistenceUnit> persistenceUnits = Collections.synchronizedMap(new TreeMap(new PersistenceUnitUtil.PersistenceUnitNameComparator()));

    public Collection<PersistenceUnit> getPersistenceUnits() {
        return this.persistenceUnits.values();
    }

    void add(PersistenceUnit persistenceUnitInfo) {
        this.persistenceUnits.put(persistenceUnitInfo.getName(), persistenceUnitInfo);
    }

    public int getNumberOfNamedQueries() {
        return this.persistenceUnits.values().stream().map(PersistenceUnit::getAllNamedQueries).mapToInt(List::size).reduce(Integer::sum).orElse(0);
    }

    public int getNumberOfEntities() {
        return this.persistenceUnits.values().stream().map(PersistenceUnit::getManagedEntities).mapToInt(List::size).reduce(Integer::sum).orElse(0);
    }

    public static class PersistenceUnit {
        @JsonIgnore
        private final transient SessionFactoryImplementor sessionFactory;
        private final String name;
        private final List<Entity> managedEntities;
        private final List<Query> namedQueries;
        private final List<Query> namedNativeQueries;
        private String createDDL;
        private String dropDDL;
        private String updateDDL;
        private final Supplier<String> createDDLSupplier;
        private final Supplier<String> dropDDLSupplier;
        private final Supplier<String> updateDDLSupplier;
        private final boolean reactive;

        public PersistenceUnit(SessionFactoryImplementor sessionFactory, String name, List<Entity> managedEntities, List<Query> namedQueries, List<Query> namedNativeQueries, Supplier<String> createDDL, Supplier<String> dropDDL, Supplier<String> updateDDLSupplier, boolean reactive) {
            this.sessionFactory = sessionFactory;
            this.name = name;
            this.managedEntities = managedEntities;
            this.namedQueries = namedQueries;
            this.namedNativeQueries = namedNativeQueries;
            this.createDDLSupplier = createDDL;
            this.dropDDLSupplier = dropDDL;
            this.updateDDLSupplier = updateDDLSupplier;
            this.reactive = reactive;
        }

        public SessionFactoryImplementor sessionFactory() {
            return this.sessionFactory;
        }

        public String getName() {
            return this.name;
        }

        public List<Entity> getManagedEntities() {
            return this.managedEntities;
        }

        public List<Query> getNamedQueries() {
            return this.namedQueries;
        }

        public List<Query> getNamedNativeQueries() {
            return this.namedNativeQueries;
        }

        public List<Query> getAllNamedQueries() {
            ArrayList<Query> allQueries = new ArrayList<Query>();
            allQueries.addAll(this.namedQueries);
            allQueries.addAll(this.namedNativeQueries);
            return allQueries;
        }

        public synchronized String getCreateDDL() {
            if (this.createDDL == null) {
                this.createDDL = this.createDDLSupplier.get();
            }
            return this.createDDL;
        }

        public synchronized String getDropDDL() {
            if (this.dropDDL == null) {
                this.dropDDL = this.dropDDLSupplier.get();
            }
            return this.dropDDL;
        }

        public synchronized String getUpdateDDL() {
            if (this.updateDDL == null) {
                this.updateDDL = this.updateDDLSupplier.get();
            }
            return this.updateDDL;
        }

        public boolean isReactive() {
            return this.reactive;
        }
    }

    public static class Query {
        private final String name;
        private final String query;
        private final boolean cacheable;
        private final String lockMode;
        private final String type;

        public Query(NamedHqlQueryDefinition queryDefinition) {
            this.name = queryDefinition.getRegistrationName();
            this.query = queryDefinition.getHqlString();
            this.cacheable = Query.extractIsCacheable((NamedQueryDefinition)queryDefinition);
            this.lockMode = Query.extractLockOptions((NamedQueryDefinition)queryDefinition);
            this.type = "JPQL";
        }

        public Query(NamedNativeQueryDefinition nativeQueryDefinition) {
            this.name = nativeQueryDefinition.getRegistrationName();
            this.query = nativeQueryDefinition.getSqlQueryString();
            this.cacheable = Query.extractIsCacheable((NamedQueryDefinition)nativeQueryDefinition);
            this.lockMode = Query.extractLockOptions((NamedQueryDefinition)nativeQueryDefinition);
            this.type = "native";
        }

        public String getName() {
            return this.name;
        }

        public String getQuery() {
            return this.query;
        }

        public boolean isCacheable() {
            return this.cacheable;
        }

        public String getLockMode() {
            return this.lockMode;
        }

        public String getType() {
            return this.type;
        }

        private static boolean extractIsCacheable(NamedQueryDefinition definition) {
            AbstractNamedQueryDefinition def;
            return definition instanceof AbstractNamedQueryDefinition && (def = (AbstractNamedQueryDefinition)definition).getCacheable() == Boolean.TRUE;
        }

        private static String extractLockOptions(NamedQueryDefinition definition) {
            AbstractNamedQueryDefinition def;
            LockOptions lockOptions;
            if (definition instanceof AbstractNamedQueryDefinition && (lockOptions = (def = (AbstractNamedQueryDefinition)definition).getLockOptions()) != null && lockOptions.getLockMode() != null) {
                return lockOptions.getLockMode().name();
            }
            return "";
        }
    }

    public static class Entity {
        private final String name;
        private final String className;
        private final String tableName;

        public Entity(String name, String className, String tableName) {
            this.name = name;
            this.className = className;
            this.tableName = tableName;
        }

        public String getName() {
            return this.name;
        }

        public String getClassName() {
            return this.className;
        }

        public String getTableName() {
            return this.tableName;
        }
    }
}

