/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import io.quarkus.runtime.annotations.ConfigDocDefault;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.configuration.TrimmedStringConverter;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import io.smallrye.config.WithParentName;
import java.util.Map;
import java.util.Optional;
import org.hibernate.FlushMode;

@ConfigGroup
public interface HibernateOrmRuntimeConfigPersistenceUnit {
    @ConfigDocDefault(value="'true' if Hibernate ORM is enabled; 'false' otherwise")
    public Optional<Boolean> active();

    @ConfigDocSection
    public HibernateOrmConfigPersistenceUnitSchemaManagement schemaManagement();

    @ConfigDocSection
    public HibernateOrmConfigPersistenceUnitDatabase database();

    @ConfigDocSection
    public HibernateOrmConfigPersistenceUnitScripts scripts();

    @ConfigDocSection
    public HibernateOrmConfigPersistenceUnitLog log();

    @ConfigDocSection
    public HibernateOrmConfigPersistenceUnitFlush flush();

    @ConfigDocMapKey(value="full-property-key")
    public Map<String, String> unsupportedProperties();

    @ConfigGroup
    public static interface HibernateOrmConfigPersistenceUnitFlush {
        @WithDefault(value="auto")
        public FlushMode mode();
    }

    @ConfigGroup
    public static interface HibernateOrmConfigPersistenceUnitLog {
        @WithDefault(value="false")
        public boolean sql();

        @WithDefault(value="true")
        public boolean formatSql();

        @WithDefault(value="true")
        public boolean highlightSql();

        @ConfigDocDefault(value="depends on dialect")
        public Optional<Boolean> jdbcWarnings();

        public Optional<Long> queriesSlowerThanMs();
    }

    @ConfigGroup
    public static interface HibernateOrmConfigPersistenceUnitScriptGeneration {
        @WithParentName
        @WithDefault(value="none")
        @WithConverter(value=TrimmedStringConverter.class)
        public String generation();

        public Optional<@WithConverter(value=TrimmedStringConverter.class) String> createTarget();

        public Optional<@WithConverter(value=TrimmedStringConverter.class) String> dropTarget();
    }

    @ConfigGroup
    @Deprecated(forRemoval=true, since="3.22")
    public static interface HibernateOrmConfigPersistenceUnitDatabaseGeneration {
        @WithParentName
        @Deprecated(forRemoval=true, since="3.22")
        public Optional<@WithConverter(value=TrimmedStringConverter.class) String> generation();

        @Deprecated(forRemoval=true, since="3.22")
        public Optional<Boolean> createSchemas();

        @Deprecated(forRemoval=true, since="3.22")
        public Optional<Boolean> haltOnError();
    }

    @ConfigGroup
    public static interface HibernateOrmConfigPersistenceUnitSchemaManagement {
        @WithConverter(value=TrimmedStringConverter.class)
        @WithDefault(value="none")
        public String strategy();

        @WithDefault(value="false")
        public boolean createSchemas();

        @WithDefault(value="false")
        public boolean haltOnError();
    }

    @ConfigGroup
    public static interface HibernateOrmConfigPersistenceUnitScripts {
        public HibernateOrmConfigPersistenceUnitScriptGeneration generation();
    }

    @ConfigGroup
    public static interface HibernateOrmConfigPersistenceUnitDatabase {
        @Deprecated(forRemoval=true, since="3.22")
        public HibernateOrmConfigPersistenceUnitDatabaseGeneration generation();

        public Optional<@WithConverter(value=TrimmedStringConverter.class) String> defaultCatalog();

        public Optional<@WithConverter(value=TrimmedStringConverter.class) String> defaultSchema();

        @WithName(value="version-check.enabled")
        @ConfigDocDefault(value="`true`")
        public Optional<Boolean> versionCheckEnabled();
    }
}

