/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import io.quarkus.hibernate.orm.runtime.boot.FastBootMetadataBuilder;
import io.quarkus.hibernate.orm.runtime.boot.QuarkusPersistenceUnitDefinition;
import io.quarkus.hibernate.orm.runtime.boot.QuarkusPersistenceUnitDescriptor;
import io.quarkus.hibernate.orm.runtime.proxies.PreGeneratedProxies;
import io.quarkus.hibernate.orm.runtime.recording.RecordedState;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.boot.archive.scan.spi.Scanner;
import org.hibernate.integrator.spi.Integrator;

public final class PersistenceUnitsHolder {
    private static final String NO_NAME_TOKEN = "__no_name";
    private static volatile PersistenceUnits persistenceUnits;

    static void initializeJpa(List<QuarkusPersistenceUnitDefinition> puDefinitions, Scanner scanner, Collection<Class<? extends Integrator>> additionalIntegrators, PreGeneratedProxies preGeneratedProxies) {
        List<QuarkusPersistenceUnitDescriptor> units = PersistenceUnitsHolder.convertPersistenceUnits(puDefinitions);
        Map<String, RecordedState> metadata = PersistenceUnitsHolder.constructMetadataAdvance(puDefinitions, scanner, additionalIntegrators, preGeneratedProxies);
        persistenceUnits = new PersistenceUnits(units, metadata);
    }

    public static List<QuarkusPersistenceUnitDescriptor> getPersistenceUnitDescriptors() {
        PersistenceUnitsHolder.checkJPAInitialization();
        return PersistenceUnitsHolder.persistenceUnits.units;
    }

    public static RecordedState popRecordedState(String persistenceUnitName) {
        PersistenceUnitsHolder.checkJPAInitialization();
        String key = persistenceUnitName;
        if (persistenceUnitName == null) {
            key = NO_NAME_TOKEN;
        }
        return PersistenceUnitsHolder.persistenceUnits.recordedStates.remove(key);
    }

    private static List<QuarkusPersistenceUnitDescriptor> convertPersistenceUnits(List<QuarkusPersistenceUnitDefinition> parsedPersistenceXmlDescriptors) {
        return parsedPersistenceXmlDescriptors.stream().map(QuarkusPersistenceUnitDefinition::getPersistenceUnitDescriptor).collect(Collectors.toList());
    }

    private static Map<String, RecordedState> constructMetadataAdvance(List<QuarkusPersistenceUnitDefinition> parsedPersistenceXmlDescriptors, Scanner scanner, Collection<Class<? extends Integrator>> additionalIntegrators, PreGeneratedProxies proxyClassDefinitions) {
        HashMap<String, RecordedState> recordedStates = new HashMap<String, RecordedState>();
        for (QuarkusPersistenceUnitDefinition unit : parsedPersistenceXmlDescriptors) {
            RecordedState m = PersistenceUnitsHolder.createMetadata(unit, scanner, additionalIntegrators, proxyClassDefinitions);
            RecordedState previous = recordedStates.put(PersistenceUnitsHolder.unitName(unit), m);
            if (previous == null) continue;
            throw new IllegalStateException("Duplicate persistence unit name: " + unit.getName());
        }
        return recordedStates;
    }

    private static void checkJPAInitialization() {
        if (persistenceUnits == null) {
            throw new RuntimeException("JPA not initialized yet by Quarkus: this is likely a bug.");
        }
    }

    private static String unitName(QuarkusPersistenceUnitDefinition unit) {
        String name = unit.getName();
        if (name == null) {
            return NO_NAME_TOKEN;
        }
        return name;
    }

    public static RecordedState createMetadata(QuarkusPersistenceUnitDefinition unit, Scanner scanner, Collection<Class<? extends Integrator>> additionalIntegrators, PreGeneratedProxies proxyDefinitions) {
        FastBootMetadataBuilder fastBootMetadataBuilder = new FastBootMetadataBuilder(unit, scanner, additionalIntegrators, proxyDefinitions);
        return fastBootMetadataBuilder.build();
    }

    private static class PersistenceUnits {
        private final List<QuarkusPersistenceUnitDescriptor> units;
        private final Map<String, RecordedState> recordedStates;

        public PersistenceUnits(List<QuarkusPersistenceUnitDescriptor> units, Map<String, RecordedState> recordedStates) {
            this.units = units;
            this.recordedStates = recordedStates;
        }
    }
}

