/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.arc.runtime.BeanContainerListener;
import io.quarkus.hibernate.orm.PersistenceUnit;
import io.quarkus.hibernate.orm.runtime.Hibernate;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfig;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfigPersistenceUnit;
import io.quarkus.hibernate.orm.runtime.JPAConfig;
import io.quarkus.hibernate.orm.runtime.PersistenceProviderSetup;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitsHolder;
import io.quarkus.hibernate.orm.runtime.ProviderUtil;
import io.quarkus.hibernate.orm.runtime.StatelessSessionLazyDelegator;
import io.quarkus.hibernate.orm.runtime.TransactionSessions;
import io.quarkus.hibernate.orm.runtime.boot.QuarkusPersistenceUnitDefinition;
import io.quarkus.hibernate.orm.runtime.dev.HibernateOrmDevIntegrator;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationRuntimeDescriptor;
import io.quarkus.hibernate.orm.runtime.migration.MultiTenancyStrategy;
import io.quarkus.hibernate.orm.runtime.proxies.PreGeneratedProxies;
import io.quarkus.hibernate.orm.runtime.schema.SchemaManagementIntegrator;
import io.quarkus.hibernate.orm.runtime.tenant.DataSourceTenantConnectionResolver;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.persistence.Cache;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.spi.LoadState;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.boot.archive.scan.spi.Scanner;
import org.hibernate.engine.spi.SessionLazyDelegator;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.relational.SchemaManager;
import org.jboss.logging.Logger;

@Recorder
public class HibernateOrmRecorder {
    private final RuntimeValue<HibernateOrmRuntimeConfig> runtimeConfig;
    private final PreGeneratedProxies proxyDefinitions;
    private final List<String> entities = new ArrayList<String>();

    public HibernateOrmRecorder(RuntimeValue<HibernateOrmRuntimeConfig> runtimeConfig, PreGeneratedProxies proxyDefinitions) {
        this.runtimeConfig = runtimeConfig;
        this.proxyDefinitions = proxyDefinitions;
    }

    public void enlistPersistenceUnit(Set<String> entityClassNames) {
        this.entities.addAll(entityClassNames);
        Logger.getLogger((String)"io.quarkus.hibernate.orm").debugf("List of entities found by Quarkus deployment:%n%s", this.entities);
    }

    public void callHibernateFeatureInit(boolean enabled) {
        Hibernate.featureInit(enabled);
    }

    public void setupPersistenceProvider(Map<String, List<HibernateOrmIntegrationRuntimeDescriptor>> integrationRuntimeDescriptors) {
        PersistenceProviderSetup.registerRuntimePersistenceProvider((HibernateOrmRuntimeConfig)this.runtimeConfig.getValue(), integrationRuntimeDescriptors);
    }

    public BeanContainerListener initMetadata(final List<QuarkusPersistenceUnitDefinition> parsedPersistenceXmlDescriptors, final Scanner scanner, final Collection<Class<? extends Integrator>> additionalIntegrators) {
        SchemaManagementIntegrator.clearDsMap();
        HibernateOrmDevIntegrator.clearPuMap();
        for (QuarkusPersistenceUnitDefinition i : parsedPersistenceXmlDescriptors) {
            if (i.getConfig().getDataSource().isPresent()) {
                SchemaManagementIntegrator.mapDatasource(i.getConfig().getDataSource().get(), i.getName());
            }
            HibernateOrmDevIntegrator.mapPersistenceUnit(i.getName(), i.getPersistenceUnitDescriptor());
        }
        return new BeanContainerListener(){

            public void created(BeanContainer beanContainer) {
                PersistenceUnitsHolder.initializeJpa(parsedPersistenceXmlDescriptors, scanner, additionalIntegrators, HibernateOrmRecorder.this.proxyDefinitions);
            }
        };
    }

    public Supplier<DataSourceTenantConnectionResolver> dataSourceTenantConnectionResolver(final String persistenceUnitName, final Optional<String> dataSourceName, final MultiTenancyStrategy multiTenancyStrategy) {
        return new Supplier<DataSourceTenantConnectionResolver>(){

            @Override
            public DataSourceTenantConnectionResolver get() {
                return new DataSourceTenantConnectionResolver(persistenceUnitName, dataSourceName, multiTenancyStrategy);
            }
        };
    }

    public Supplier<JPAConfig> jpaConfigSupplier() {
        return () -> new JPAConfig((HibernateOrmRuntimeConfig)this.runtimeConfig.getValue());
    }

    public void startAllPersistenceUnits(BeanContainer beanContainer, ShutdownContext shutdownContext) {
        JPAConfig jpaConfig = (JPAConfig)beanContainer.beanInstance(JPAConfig.class, new Annotation[0]);
        shutdownContext.addShutdownTask(jpaConfig::shutdown);
        jpaConfig.startAll();
    }

    public Function<SyntheticCreationalContext<SessionFactory>, SessionFactory> sessionFactorySupplier(final String persistenceUnitName) {
        return new Function<SyntheticCreationalContext<SessionFactory>, SessionFactory>(){

            @Override
            public SessionFactory apply(SyntheticCreationalContext<SessionFactory> context) {
                SessionFactory sessionFactory = (SessionFactory)((JPAConfig)context.getInjectedReference(JPAConfig.class, new Annotation[0])).getEntityManagerFactory(persistenceUnitName).unwrap(SessionFactory.class);
                return sessionFactory;
            }
        };
    }

    public Function<SyntheticCreationalContext<Session>, Session> sessionSupplier(final String persistenceUnitName) {
        return new Function<SyntheticCreationalContext<Session>, Session>(){

            @Override
            public Session apply(SyntheticCreationalContext<Session> context) {
                final TransactionSessions transactionSessions = (TransactionSessions)context.getInjectedReference(TransactionSessions.class, new Annotation[0]);
                return new SessionLazyDelegator((Supplier)new Supplier<Session>(){

                    @Override
                    public Session get() {
                        return transactionSessions.getSession(persistenceUnitName);
                    }
                });
            }
        };
    }

    public Function<SyntheticCreationalContext<StatelessSession>, StatelessSession> statelessSessionSupplier(final String persistenceUnitName) {
        return new Function<SyntheticCreationalContext<StatelessSession>, StatelessSession>(){

            @Override
            public StatelessSession apply(SyntheticCreationalContext<StatelessSession> context) {
                final TransactionSessions transactionSessions = (TransactionSessions)context.getInjectedReference(TransactionSessions.class, new Annotation[0]);
                return new StatelessSessionLazyDelegator(new Supplier<StatelessSession>(){

                    @Override
                    public StatelessSession get() {
                        return transactionSessions.getStatelessSession(persistenceUnitName);
                    }
                });
            }
        };
    }

    public Function<SyntheticCreationalContext<CriteriaBuilder>, CriteriaBuilder> criteriaBuilderSupplier(String persistenceUnitName) {
        return this.sessionFactoryFunctionSupplier(persistenceUnitName, new Function<SessionFactory, CriteriaBuilder>(){

            @Override
            public CriteriaBuilder apply(SessionFactory sessionFactory) {
                return sessionFactory.getCriteriaBuilder();
            }
        });
    }

    public Function<SyntheticCreationalContext<Metamodel>, Metamodel> metamodelSupplier(String persistenceUnitName) {
        return this.sessionFactoryFunctionSupplier(persistenceUnitName, new Function<SessionFactory, Metamodel>(){

            @Override
            public Metamodel apply(SessionFactory sessionFactory) {
                return sessionFactory.getMetamodel();
            }
        });
    }

    public Function<SyntheticCreationalContext<Cache>, Cache> cacheSupplier(String persistenceUnitName) {
        return this.sessionFactoryFunctionSupplier(persistenceUnitName, new Function<SessionFactory, Cache>(){

            @Override
            public Cache apply(SessionFactory sessionFactory) {
                return sessionFactory.getCache();
            }
        });
    }

    public Function<SyntheticCreationalContext<jakarta.persistence.PersistenceUnitUtil>, jakarta.persistence.PersistenceUnitUtil> persistenceUnitUtilSupplier(String persistenceUnitName) {
        return this.sessionFactoryFunctionSupplier(persistenceUnitName, new Function<SessionFactory, jakarta.persistence.PersistenceUnitUtil>(){

            @Override
            public jakarta.persistence.PersistenceUnitUtil apply(SessionFactory sessionFactory) {
                return sessionFactory.getPersistenceUnitUtil();
            }
        });
    }

    public Function<SyntheticCreationalContext<SchemaManager>, SchemaManager> schemaManagerSupplier(String persistenceUnitName) {
        return this.sessionFactoryFunctionSupplier(persistenceUnitName, new Function<SessionFactory, SchemaManager>(){

            @Override
            public SchemaManager apply(SessionFactory sessionFactory) {
                return sessionFactory.getSchemaManager();
            }
        });
    }

    private <T> Function<SyntheticCreationalContext<T>, T> sessionFactoryFunctionSupplier(final String persistenceUnitName, final Function<SessionFactory, T> sessionFactoryMapper) {
        return new Function<SyntheticCreationalContext<T>, T>(){

            @Override
            public T apply(SyntheticCreationalContext<T> context) {
                SessionFactory sessionFactory = HibernateOrmRecorder.this.getSessionFactoryFromContext(context, persistenceUnitName);
                return sessionFactoryMapper.apply(sessionFactory);
            }
        };
    }

    private SessionFactory getSessionFactoryFromContext(SyntheticCreationalContext<?> context, String persistenceUnitName) {
        Class<SessionFactory> sfBeanType = SessionFactory.class;
        if (PersistenceUnitUtil.isDefaultPersistenceUnit(persistenceUnitName)) {
            return (SessionFactory)context.getInjectedReference(sfBeanType, new Annotation[0]);
        }
        PersistenceUnit.PersistenceUnitLiteral qualifier = new PersistenceUnit.PersistenceUnitLiteral(persistenceUnitName);
        return (SessionFactory)context.getInjectedReference(sfBeanType, new Annotation[]{qualifier});
    }

    public void doValidation(final String puName) {
        HibernateOrmRuntimeConfigPersistenceUnit hibernateOrmRuntimeConfigPersistenceUnit = ((HibernateOrmRuntimeConfig)this.runtimeConfig.getValue()).persistenceUnits().get(puName);
        String schemaManagementStrategy = hibernateOrmRuntimeConfigPersistenceUnit.database().generation().generation().orElse(hibernateOrmRuntimeConfigPersistenceUnit.schemaManagement().strategy());
        if (!"none".equals(schemaManagementStrategy)) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                SchemaManagementIntegrator.runPostBootValidation(puName);
            }
        }, "Hibernate post-boot validation thread for " + puName).start();
    }

    public BiPredicate<Object, String> attributeLoadedPredicate() {
        return new IsAttributeLoadedPredicate();
    }

    private static class IsAttributeLoadedPredicate
    implements BiPredicate<Object, String> {
        private final ProviderUtil providerUtil = new ProviderUtil();

        private IsAttributeLoadedPredicate() {
        }

        @Override
        public boolean test(Object entity, String attributeName) {
            LoadState loadstate = this.providerUtil.isLoadedWithoutReference(entity, attributeName);
            if (loadstate == LoadState.LOADED) {
                return true;
            }
            if (loadstate == LoadState.NOT_LOADED) {
                return false;
            }
            loadstate = this.providerUtil.isLoadedWithReference(entity, attributeName);
            if (loadstate == LoadState.LOADED) {
                return true;
            }
            return loadstate != LoadState.NOT_LOADED;
        }
    }
}

