/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.dev;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import io.quarkus.devui.runtime.comms.JsonRpcMessage;
import io.quarkus.devui.runtime.comms.JsonRpcRouter;
import io.quarkus.devui.runtime.comms.MessageType;
import io.quarkus.hibernate.orm.runtime.customized.QuarkusConnectionProvider;
import io.quarkus.hibernate.orm.runtime.dev.HibernateOrmDevController;
import io.quarkus.hibernate.orm.runtime.dev.HibernateOrmDevInfo;
import io.quarkus.logging.Log;
import io.quarkus.runtime.LaunchMode;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.microprofile.config.ConfigProvider;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Transaction;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.Query;
import org.hibernate.query.spi.SqmQuery;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.tree.SqmStatement;

public class HibernateOrmDevJsonRpcService {
    private boolean isDev = LaunchMode.current() == LaunchMode.DEVELOPMENT && !LaunchMode.isRemoteDev();
    private String allowedHost = ConfigProvider.getConfig().getOptionalValue("quarkus.datasource.dev-ui.allowed-db-host", String.class).orElse(null);

    public HibernateOrmDevInfo getInfo() {
        return HibernateOrmDevController.get().getInfo();
    }

    public int getNumberOfPersistenceUnits() {
        return this.getInfo().getPersistenceUnits().size();
    }

    public int getNumberOfEntityTypes() {
        return this.getInfo().getNumberOfEntities();
    }

    public int getNumberOfNamedQueries() {
        return this.getInfo().getNumberOfNamedQueries();
    }

    private Optional<HibernateOrmDevInfo.PersistenceUnit> findPersistenceUnit(String persistenceUnitName) {
        return this.getInfo().getPersistenceUnits().stream().filter(pu -> pu.getName().equals(persistenceUnitName)).findFirst();
    }

    public JsonRpcMessage<Object> executeHQL(String persistenceUnit, String hql, Integer pageNumber, Integer pageSize) {
        if (!this.isDev) {
            return HibernateOrmDevJsonRpcService.errorDataSet("This method is only allowed in dev mode");
        }
        if (!this.hqlIsValid(hql)) {
            return HibernateOrmDevJsonRpcService.errorDataSet("The provided HQL was not valid");
        }
        Optional<HibernateOrmDevInfo.PersistenceUnit> pu = this.findPersistenceUnit(persistenceUnit);
        if (pu.isEmpty()) {
            return HibernateOrmDevJsonRpcService.errorDataSet("No such persistence unit: " + persistenceUnit);
        }
        SessionFactoryImplementor sf = pu.get().sessionFactory();
        ConnectionProvider connectionProvider = (ConnectionProvider)sf.getServiceRegistry().requireService(ConnectionProvider.class);
        if (connectionProvider instanceof QuarkusConnectionProvider) {
            QuarkusConnectionProvider quarkusConnectionProvider = (QuarkusConnectionProvider)connectionProvider;
            if (!this.isAllowedDatabase(quarkusConnectionProvider.getDataSource())) {
                return HibernateOrmDevJsonRpcService.errorDataSet("The persistence unit's datasource points to a non-allowed datasource. By default only local databases are enabled; you can use the 'quarkus.datasource.dev-ui.allowed-db-host' configuration property to configure allowed hosts ('*' to allow all).");
            }
        } else {
            return HibernateOrmDevJsonRpcService.errorDataSet("Unsupported Connection Provider type for specified persistence unit.");
        }
        return (JsonRpcMessage)sf.fromSession(session -> {
            JsonRpcMessage jsonRpcMessage;
            block10: {
                Transaction transaction = session.beginTransaction();
                Query query = session.createQuery(hql, null);
                if (SqmUtil.isMutation((SqmStatement)((SqmQuery)query).getSqmStatement())) {
                    int updateCount = query.executeUpdate();
                    transaction.commit();
                    return new JsonRpcMessage((Object)new DataSet(null, -1L, "Query executed correctly. Rows affected: " + updateCount, null), MessageType.Response);
                }
                long resultCount = query.getResultCount();
                ScrollableResults scroll = query.scroll(ScrollMode.SCROLL_INSENSITIVE);
                try {
                    boolean hasNext = scroll.scroll((pageNumber - 1) * pageSize + 1);
                    ArrayList<Object> results = new ArrayList<Object>();
                    int i = 0;
                    while (hasNext && i++ < pageSize) {
                        results.add(scroll.get());
                        hasNext = scroll.next();
                    }
                    String result = HibernateOrmDevJsonRpcService.writeValueAsString(new DataSet(results, resultCount, null, null));
                    JsonRpcMessage message = new JsonRpcMessage((Object)result, MessageType.Response);
                    message.setAlreadySerialized(true);
                    transaction.commit();
                    jsonRpcMessage = message;
                    if (scroll == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (scroll != null) {
                            try {
                                scroll.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        transaction.rollback();
                        return new JsonRpcMessage((Object)new DataSet(null, -1L, null, ex.getMessage()), MessageType.Response);
                    }
                }
                scroll.close();
            }
            return jsonRpcMessage;
        });
    }

    private static JsonRpcMessage<Object> errorDataSet(String errorMessage) {
        return new JsonRpcMessage((Object)new DataSet(null, -1L, null, errorMessage), MessageType.Response);
    }

    private static String writeValueAsString(DataSet value) {
        try {
            JsonRpcRouter jsonRpcRouter = (JsonRpcRouter)CDI.current().select(JsonRpcRouter.class, new Annotation[0]).get();
            return jsonRpcRouter.getJsonMapper().toString((Object)value, true);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to encode results as JSON. Note circular associations are not supported at the moment, use `@JsonIgnore` to break circles.", ex);
        }
    }

    private boolean hqlIsValid(String hql) {
        return hql != null && !hql.trim().isEmpty();
    }

    private boolean isAllowedDatabase(AgroalDataSource ads) {
        String allowedHost;
        String string = allowedHost = this.allowedHost == null ? null : this.allowedHost.trim();
        if (allowedHost != null && allowedHost.equals("*")) {
            return true;
        }
        AgroalDataSourceConfiguration configuration = ads.getConfiguration();
        String jdbcUrl = configuration.connectionPoolConfiguration().connectionFactoryConfiguration().jdbcUrl();
        try {
            if (jdbcUrl.startsWith("jdbc:h2:mem:") || jdbcUrl.startsWith("jdbc:h2:file:") || jdbcUrl.startsWith("jdbc:h2:tcp://localhost") || allowedHost != null && !allowedHost.isBlank() && jdbcUrl.startsWith("jdbc:h2:tcp://" + allowedHost) || jdbcUrl.startsWith("jdbc:derby:memory:")) {
                return true;
            }
            String cleanUrl = jdbcUrl.replace("jdbc:", "");
            URI uri = new URI(cleanUrl);
            String host = uri.getHost();
            return host != null && (host.equals("localhost") || host.equals("127.0.0.1") || host.equals("::1") || allowedHost != null && !allowedHost.isBlank() && host.equalsIgnoreCase(allowedHost));
        }
        catch (URISyntaxException e) {
            Log.warn((Object)e.getMessage());
            return false;
        }
    }

    private record DataSet(List<Object> data, long totalNumberOfElements, String message, String error) {
    }
}

