/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.rest.data.panache.runtime;

import io.quarkus.rest.data.panache.RestDataPanacheException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import org.hibernate.exception.ConstraintViolationException;
import org.jboss.logging.Logger;

public class RestDataPanacheExceptionMapper
implements ExceptionMapper<RestDataPanacheException> {
    private static final Logger LOGGER = Logger.getLogger(RestDataPanacheExceptionMapper.class);

    public Response toResponse(RestDataPanacheException exception) {
        LOGGER.warnf((Throwable)exception, "Mapping an unhandled %s", (Object)RestDataPanacheException.class.getSimpleName());
        return this.throwableToResponse((Throwable)exception, exception.getMessage());
    }

    private Response throwableToResponse(Throwable throwable, String message) {
        if (throwable instanceof ConstraintViolationException) {
            return Response.status((int)Response.Status.CONFLICT.getStatusCode(), (String)message).build();
        }
        if (throwable instanceof jakarta.validation.ConstraintViolationException) {
            return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)message).build();
        }
        if (throwable.getCause() != null) {
            return this.throwableToResponse(throwable.getCause(), message);
        }
        return Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (String)message).build();
    }
}

