/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.common.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.hibernate.orm.deployment.HibernateOrmEnabled;
import io.quarkus.hibernate.orm.deployment.JpaModelBuildItem;
import io.quarkus.hibernate.orm.panache.common.deployment.PanacheNamedQueryEntityClassBuildStep;
import io.quarkus.hibernate.orm.panache.common.runtime.PanacheHibernateRecorder;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

@BuildSteps(onlyIf={HibernateOrmEnabled.class})
public final class PanacheJpaCommonResourceProcessor {
    private static final DotName DOTNAME_NAMED_QUERY = DotName.createSimple((String)NamedQuery.class.getName());
    private static final DotName DOTNAME_NAMED_QUERIES = DotName.createSimple((String)NamedQueries.class.getName());

    @BuildStep
    void lookupNamedQueries(CombinedIndexBuildItem index, BuildProducer<PanacheNamedQueryEntityClassBuildStep> namedQueries, JpaModelBuildItem jpaModel) {
        for (String modelClass : jpaModel.getAllModelClassNames()) {
            HashMap<String, String> typeNamedQueries = new HashMap<String, String>();
            this.lookupNamedQueries(index, DotName.createSimple((String)modelClass), typeNamedQueries);
            namedQueries.produce((BuildItem)new PanacheNamedQueryEntityClassBuildStep(modelClass, typeNamedQueries));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void buildNamedQueryMap(List<PanacheNamedQueryEntityClassBuildStep> namedQueryEntityClasses, PanacheHibernateRecorder panacheHibernateRecorder) {
        HashMap<String, Map<String, String>> namedQueryMap = new HashMap<String, Map<String, String>>();
        for (PanacheNamedQueryEntityClassBuildStep entityNamedQueries : namedQueryEntityClasses) {
            namedQueryMap.put(entityNamedQueries.getClassName(), entityNamedQueries.getNamedQueries());
        }
        panacheHibernateRecorder.setNamedQueryMap(namedQueryMap);
    }

    private void lookupNamedQueries(CombinedIndexBuildItem index, DotName name, Map<String, String> namedQueries) {
        List namedQueriesInstances;
        ClassInfo classInfo = index.getComputingIndex().getClassByName(name);
        if (classInfo == null) {
            return;
        }
        List namedQueryInstances = (List)classInfo.annotationsMap().get(DOTNAME_NAMED_QUERY);
        if (namedQueryInstances != null) {
            for (Object namedQueryInstance : namedQueryInstances) {
                namedQueries.put(namedQueryInstance.value("name").asString(), namedQueryInstance.value("query").asString());
            }
        }
        if ((namedQueriesInstances = (List)classInfo.annotationsMap().get(DOTNAME_NAMED_QUERIES)) != null) {
            for (AnnotationInstance namedQueriesInstance : namedQueriesInstances) {
                AnnotationInstance[] nestedInstances;
                AnnotationValue value = namedQueriesInstance.value();
                for (AnnotationInstance nested : nestedInstances = value.asNestedArray()) {
                    namedQueries.put(nested.value("name").asString(), nested.value("query").asString());
                }
            }
        }
        if (!classInfo.superClassType().name().equals((Object)JandexUtil.DOTNAME_OBJECT)) {
            Type superType = classInfo.superClassType();
            ClassInfo superClass = index.getComputingIndex().getClassByName(superType.name());
            if (superClass != null) {
                this.lookupNamedQueries(index, superClass.name(), namedQueries);
            }
        }
    }
}

