/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class HibernateDataSourceUtil {
    public static <T> Optional<T> findDataSourceWithNameDefault(String persistenceUnitName, List<T> datasSources, Function<T, String> nameExtractor, Function<T, Boolean> defaultExtractor, Optional<String> datasource) {
        if (datasource.isPresent()) {
            String dataSourceName = datasource.get();
            return datasSources.stream().filter(i -> dataSourceName.equals(nameExtractor.apply(i))).findFirst();
        }
        if (PersistenceUnitUtil.isDefaultPersistenceUnit((String)persistenceUnitName)) {
            return datasSources.stream().filter(i -> (Boolean)defaultExtractor.apply(i)).findFirst();
        }
        return Optional.empty();
    }
}

