/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.client;

import io.grpc.ClientCall;
import io.grpc.Compressor;
import io.grpc.Decompressor;
import io.grpc.DecompressorRegistry;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.vertx.core.Future;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.net.SocketAddress;
import io.vertx.grpc.client.GrpcClient;
import io.vertx.grpc.client.GrpcClientRequest;
import io.vertx.grpc.client.GrpcClientResponse;
import io.vertx.grpc.common.GrpcError;
import io.vertx.grpc.common.impl.BridgeMessageDecoder;
import io.vertx.grpc.common.impl.BridgeMessageEncoder;
import io.vertx.grpc.common.impl.ReadStreamAdapter;
import io.vertx.grpc.common.impl.Utils;
import io.vertx.grpc.common.impl.WriteStreamAdapter;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

class VertxClientCall<RequestT, ResponseT>
extends ClientCall<RequestT, ResponseT> {
    private final GrpcClient client;
    private final SocketAddress server;
    private final Executor exec;
    private final MethodDescriptor<RequestT, ResponseT> methodDescriptor;
    private final String encoding;
    private final Compressor compressor;
    private Future<GrpcClientRequest<RequestT, ResponseT>> fut;
    private ClientCall.Listener<ResponseT> listener;
    private WriteStreamAdapter<RequestT> writeAdapter;
    private ReadStreamAdapter<ResponseT> readAdapter;
    private GrpcClientRequest<RequestT, ResponseT> request;
    private GrpcClientResponse<RequestT, ResponseT> grpcResponse;

    VertxClientCall(GrpcClient client, SocketAddress server, final Executor exec, MethodDescriptor<RequestT, ResponseT> methodDescriptor, String encoding, Compressor compressor) {
        this.client = client;
        this.server = server;
        this.exec = exec;
        this.methodDescriptor = methodDescriptor;
        this.encoding = encoding;
        this.compressor = compressor;
        this.writeAdapter = new WriteStreamAdapter<RequestT>(){

            @Override
            protected void handleReady() {
                VertxClientCall.this.listener.onReady();
            }
        };
        this.readAdapter = new ReadStreamAdapter<ResponseT>(){

            @Override
            protected void handleMessage(ResponseT msg) {
                if (exec == null) {
                    VertxClientCall.this.listener.onMessage(msg);
                } else {
                    exec.execute(() -> VertxClientCall.this.listener.onMessage(msg));
                }
            }
        };
    }

    @Override
    public boolean isReady() {
        return this.writeAdapter.isReady();
    }

    @Override
    public void start(ClientCall.Listener<ResponseT> responseListener, Metadata headers) {
        this.listener = responseListener;
        this.fut = this.client.request(this.server, this.methodDescriptor);
        this.fut.onComplete(ar1 -> {
            if (ar1.succeeded()) {
                this.request = (GrpcClientRequest)ar1.result();
                Utils.writeMetadata(headers, this.request.headers());
                if (this.encoding != null) {
                    this.request.encoding(this.encoding);
                }
                Future<GrpcClientResponse<RequestT, ResponseT>> responseFuture = this.request.response();
                responseFuture.onComplete(ar2 -> {
                    if (ar2.succeeded()) {
                        this.grpcResponse = (GrpcClientResponse)ar2.result();
                        boolean trailersOnly = this.grpcResponse.status() != null;
                        String respEncoding = this.grpcResponse.encoding();
                        Decompressor decompressor = DecompressorRegistry.getDefaultInstance().lookupDecompressor(respEncoding);
                        BridgeMessageDecoder<ResponseT> decoder = new BridgeMessageDecoder<ResponseT>(this.methodDescriptor.getResponseMarshaller(), decompressor);
                        Metadata responseHeaders = Utils.readMetadata(this.grpcResponse.headers());
                        if (this.exec == null) {
                            responseListener.onHeaders(responseHeaders);
                        } else {
                            this.exec.execute(() -> responseListener.onHeaders(responseHeaders));
                        }
                        this.readAdapter.init(this.grpcResponse, decoder);
                        this.grpcResponse.end().onComplete(ar -> {
                            Metadata trailers;
                            Status status;
                            if (this.grpcResponse.status() != null) {
                                status = Status.fromCodeValue(this.grpcResponse.status().code);
                                if (this.grpcResponse.statusMessage() != null) {
                                    status = status.withDescription(this.grpcResponse.statusMessage());
                                }
                                trailers = Utils.readMetadata(trailersOnly ? this.grpcResponse.headers() : this.grpcResponse.trailers());
                            } else {
                                status = Status.fromThrowable(ar.cause());
                                trailers = new Metadata();
                            }
                            this.doClose(status, trailers);
                        });
                    } else {
                        Throwable err = ar2.cause();
                        if (err instanceof StreamResetException) {
                            StreamResetException reset = (StreamResetException)err;
                            GrpcError grpcError = GrpcError.mapHttp2ErrorCode(reset.getCode());
                            if (grpcError != null) {
                                this.doClose(Status.fromCodeValue(grpcError.status.code), new Metadata());
                            } else {
                                this.doClose(Status.UNKNOWN, new Metadata());
                            }
                        } else {
                            this.doClose(Status.fromThrowable(err), new Metadata());
                        }
                    }
                });
                this.writeAdapter.init(this.request, new BridgeMessageEncoder<RequestT>(this.methodDescriptor.getRequestMarshaller(), this.compressor));
            } else {
                this.doClose(Status.UNAVAILABLE, new Metadata());
            }
        });
    }

    private void doClose(Status status, Metadata trailers) {
        Runnable cmd = () -> this.listener.onClose(status, trailers);
        if (this.exec == null) {
            cmd.run();
        } else {
            this.exec.execute(cmd);
        }
    }

    @Override
    public void request(int numMessages) {
        this.readAdapter.request(numMessages);
    }

    @Override
    public void cancel(@Nullable String message, @Nullable Throwable cause) {
        this.fut.onSuccess(req -> req.cancel());
    }

    @Override
    public void halfClose() {
        this.fut.onSuccess(req -> req.end());
    }

    @Override
    public void sendMessage(RequestT message) {
        this.fut.onSuccess(v -> this.writeAdapter.write(message));
    }
}

