/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc;

import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.ArcInitConfig;
import io.quarkus.arc.impl.ArcContainerImpl;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public final class Arc {
    private static final AtomicReference<ArcContainerImpl> INSTANCE = new AtomicReference();
    private static final String LOG_NO_CONTAINER = "quarkus.arc.log-no-container";
    private static final Logger LOG = Logger.getLogger(Arc.class);

    public static ArcContainer initialize() {
        return Arc.initialize(ArcInitConfig.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArcContainer initialize(ArcInitConfig config) {
        ArcContainerImpl container = INSTANCE.get();
        if (container == null) {
            AtomicReference<ArcContainerImpl> atomicReference = INSTANCE;
            synchronized (atomicReference) {
                container = INSTANCE.get();
                if (container == null) {
                    container = new ArcContainerImpl(config.getCurrentContextFactory(), config.isStrictCompatibility(), config.isTestMode());
                    INSTANCE.set(container);
                    container.init();
                }
            }
        }
        return container;
    }

    public static void setExecutor(ExecutorService executor) {
        ArcContainerImpl container = INSTANCE.get();
        if (container == null) {
            throw Arc.containerNotInitialized();
        }
        container.setExecutor(executor);
    }

    public static ArcContainer container() {
        ArcContainer container = INSTANCE.get();
        if (container == null && System.getProperty(LOG_NO_CONTAINER) != null) {
            LOG.warn(Arc.gatherDiagnosticInfo());
        }
        return container;
    }

    public static ArcContainer requireContainer() {
        ArcContainer container = INSTANCE.get();
        if (container == null) {
            throw Arc.containerNotInitialized();
        }
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        ArcContainerImpl container = INSTANCE.get();
        if (container != null) {
            AtomicReference<ArcContainerImpl> atomicReference = INSTANCE;
            synchronized (atomicReference) {
                container = INSTANCE.get();
                if (container != null) {
                    container.shutdown();
                    INSTANCE.set(null);
                }
            }
        }
    }

    private static IllegalStateException containerNotInitialized() {
        String msg = "ArC container not initialized: the container is not started, already shut down, or a wrong class loader was used to load the io.quarkus.arc.Arc class\n\t- CL:  %s\n\t- TCCL: %s";
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        ClassLoader cl = Arc.class.getClassLoader();
        return new IllegalStateException(msg.formatted(cl, tccl));
    }

    private static String gatherDiagnosticInfo() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        ClassLoader cl = Arc.class.getClassLoader();
        String msg = "\n==============================\nArC: container not initialized\n------------------------------\nThe container is not started, already shut down, or a wrong class loader was used to load the io.quarkus.arc.Arc class.\n\nCL:   %1$s\nTCCL: %2$s\nStack:\n\t%3$s\n===================================\n";
        StackWalker walker = StackWalker.getInstance();
        return msg.formatted(cl, tccl, walker.walk(Arc::collectStack));
    }

    private static String collectStack(Stream<StackWalker.StackFrame> stream) {
        return stream.skip(1L).map(Object::toString).collect(Collectors.joining("\n\t"));
    }
}

