/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc;

import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.ArcInitConfig;
import io.quarkus.arc.impl.ArcContainerImpl;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;

public final class Arc {
    private static final AtomicReference<ArcContainerImpl> INSTANCE = new AtomicReference();

    public static ArcContainer initialize() {
        return Arc.initialize(ArcInitConfig.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArcContainer initialize(ArcInitConfig config) {
        ArcContainerImpl container = INSTANCE.get();
        if (container == null) {
            AtomicReference<ArcContainerImpl> atomicReference = INSTANCE;
            synchronized (atomicReference) {
                container = INSTANCE.get();
                if (container == null) {
                    container = new ArcContainerImpl(config.getCurrentContextFactory(), config.isStrictCompatibility(), config.isTestMode());
                    INSTANCE.set(container);
                    container.init();
                }
            }
        }
        return container;
    }

    public static void setExecutor(ExecutorService executor) {
        INSTANCE.get().setExecutor(executor);
    }

    public static ArcContainer container() {
        return INSTANCE.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        ArcContainerImpl container = INSTANCE.get();
        if (container != null) {
            AtomicReference<ArcContainerImpl> atomicReference = INSTANCE;
            synchronized (atomicReference) {
                container = INSTANCE.get();
                if (container != null) {
                    container.shutdown();
                    INSTANCE.set(null);
                }
            }
        }
    }
}

