/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.impl.ArcContainerImpl;
import io.quarkus.arc.impl.BeanTypeAssignabilityRules;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.impl.EventImpl;
import io.quarkus.arc.impl.EventTypeAssignabilityRules;
import io.quarkus.arc.impl.HierarchyDiscovery;
import io.quarkus.arc.impl.InjectionPointProvider;
import io.quarkus.arc.impl.LazyValue;
import io.quarkus.arc.impl.Qualifiers;
import io.quarkus.arc.impl.Types;
import jakarta.el.ELResolver;
import jakarta.el.ExpressionFactory;
import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Stereotype;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMember;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Decorator;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InjectionTargetFactory;
import jakarta.enterprise.inject.spi.InterceptionFactory;
import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.enterprise.inject.spi.Interceptor;
import jakarta.enterprise.inject.spi.ObserverMethod;
import jakarta.enterprise.inject.spi.ProducerFactory;
import jakarta.inject.Named;
import jakarta.inject.Qualifier;
import jakarta.interceptor.InterceptorBinding;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class BeanManagerImpl
implements BeanManager {
    static final LazyValue<BeanManagerImpl> INSTANCE = new LazyValue<BeanManagerImpl>(BeanManagerImpl::new);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getReference(Bean<?> bean, Type beanType, CreationalContext<?> ctx) {
        Objects.requireNonNull(bean, "Bean is null");
        Objects.requireNonNull(beanType, "Bean type is null");
        Objects.requireNonNull(ctx, "CreationalContext is null");
        if (!BeanTypeAssignabilityRules.instance().matches(beanType, bean.getTypes())) {
            throw new IllegalArgumentException("Type " + String.valueOf(beanType) + " is not a bean type of " + String.valueOf(bean) + "; its bean types are: " + String.valueOf(bean.getTypes()));
        }
        if (bean instanceof InjectableBean && ctx instanceof CreationalContextImpl) {
            InjectionPoint prev = InjectionPointProvider.setCurrent(ctx, null);
            try {
                Object t = ArcContainerImpl.beanInstanceHandle((InjectableBean)bean, (CreationalContextImpl)ctx, null, null, true).get();
                return t;
            }
            finally {
                InjectionPointProvider.setCurrent(ctx, prev);
            }
        }
        throw new IllegalArgumentException("Arguments must be instances of " + String.valueOf(InjectableBean.class) + " and " + String.valueOf(CreationalContextImpl.class) + ": \nbean: " + String.valueOf(bean) + "\nctx: " + String.valueOf(ctx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getInjectableReference(InjectionPoint ij, CreationalContext<?> ctx) {
        Objects.requireNonNull(ij, "InjectionPoint is null");
        Objects.requireNonNull(ctx, "CreationalContext is null");
        if (ctx instanceof CreationalContextImpl) {
            Set beans = this.getBeans(ij.getType(), ij.getQualifiers().toArray(new Annotation[0]));
            if (beans.isEmpty()) {
                throw new UnsatisfiedResolutionException();
            }
            InjectableBean bean = (InjectableBean)this.resolve(beans);
            InjectionPoint prev = InjectionPointProvider.setCurrent(ctx, ij);
            try {
                Object t = ArcContainerImpl.beanInstanceHandle(bean, (CreationalContextImpl)ctx, null, null, true).get();
                return t;
            }
            finally {
                InjectionPointProvider.setCurrent(ctx, prev);
            }
        }
        throw new IllegalArgumentException("CreationalContext must be an instances of " + String.valueOf(CreationalContextImpl.class));
    }

    @Override
    public <T> CreationalContext<T> createCreationalContext(Contextual<T> contextual) {
        return new CreationalContextImpl<T>(contextual);
    }

    @Override
    public Set<Bean<?>> getBeans(Type beanType, Annotation ... qualifiers) {
        return ArcContainerImpl.instance().getBeans(Objects.requireNonNull(beanType), qualifiers);
    }

    @Override
    public Set<Bean<?>> getBeans(String name) {
        return ArcContainerImpl.instance().getBeans(Objects.requireNonNull(name));
    }

    @Override
    public Bean<?> getPassivationCapableBean(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <X> Bean<? extends X> resolve(Set<Bean<? extends X>> beans) {
        return ArcContainerImpl.resolve(beans);
    }

    @Override
    public void validate(InjectionPoint injectionPoint) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(T event, Annotation ... qualifiers) {
        Type eventType = Types.getCanonicalType(event.getClass());
        if (Types.containsTypeVariable(eventType)) {
            throw new IllegalArgumentException("The runtime type of the event object contains a type variable: " + String.valueOf(eventType));
        }
        HashSet<Annotation> eventQualifiers = new HashSet<Annotation>(Arrays.asList(qualifiers));
        return new LinkedHashSet<ObserverMethod<? super T>>(ArcContainerImpl.instance().resolveObserverMethods(eventType, eventQualifiers));
    }

    @Override
    public List<Decorator<?>> resolveDecorators(Set<Type> types, Annotation ... qualifiers) {
        return ArcContainerImpl.instance().resolveDecorators(types, qualifiers);
    }

    @Override
    public List<Interceptor<?>> resolveInterceptors(InterceptionType type, Annotation ... interceptorBindings) {
        return ArcContainerImpl.instance().resolveInterceptors(Objects.requireNonNull(type), interceptorBindings);
    }

    @Override
    public boolean isScope(Class<? extends Annotation> annotationType) {
        return ArcContainerImpl.instance().isScope(annotationType);
    }

    @Override
    public boolean isNormalScope(Class<? extends Annotation> annotationType) {
        return ArcContainerImpl.instance().isNormalScope(annotationType);
    }

    @Override
    public boolean isPassivatingScope(Class<? extends Annotation> annotationType) {
        return false;
    }

    @Override
    public boolean isQualifier(Class<? extends Annotation> annotationType) {
        return annotationType.isAnnotationPresent(Qualifier.class) || ArcContainerImpl.instance().registeredQualifiers.isRegistered(annotationType);
    }

    @Override
    public boolean isInterceptorBinding(Class<? extends Annotation> annotationType) {
        return annotationType.isAnnotationPresent(InterceptorBinding.class) || ArcContainerImpl.instance().registeredInterceptorBindings.isRegistered(annotationType);
    }

    @Override
    public boolean isStereotype(Class<? extends Annotation> annotationType) {
        return annotationType.isAnnotationPresent(Stereotype.class);
    }

    @Override
    public Set<Annotation> getInterceptorBindingDefinition(Class<? extends Annotation> bindingType) {
        return new HashSet<Annotation>(Arrays.asList(bindingType.getAnnotations()));
    }

    @Override
    public Set<Annotation> getStereotypeDefinition(Class<? extends Annotation> stereotype) {
        return new HashSet<Annotation>(Arrays.asList(stereotype.getAnnotations()));
    }

    @Override
    public boolean areQualifiersEquivalent(Annotation qualifier1, Annotation qualifier2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean areInterceptorBindingsEquivalent(Annotation interceptorBinding1, Annotation interceptorBinding2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getQualifierHashCode(Annotation qualifier) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInterceptorBindingHashCode(Annotation interceptorBinding) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Context getContext(Class<? extends Annotation> scopeType) {
        InjectableContext context = Arc.container().getActiveContext(scopeType);
        if (context == null) {
            throw new ContextNotActiveException("No active context found for: " + String.valueOf(scopeType));
        }
        return context;
    }

    @Override
    public Collection<Context> getContexts(Class<? extends Annotation> scopeType) {
        return Arc.container().getContexts(scopeType);
    }

    @Override
    public ELResolver getELResolver() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExpressionFactory wrapExpressionFactory(ExpressionFactory expressionFactory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> AnnotatedType<T> createAnnotatedType(Class<T> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> InjectionTargetFactory<T> getInjectionTargetFactory(AnnotatedType<T> annotatedType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <X> ProducerFactory<X> getProducerFactory(AnnotatedField<? super X> field, Bean<X> declaringBean) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <X> ProducerFactory<X> getProducerFactory(AnnotatedMethod<? super X> method, Bean<X> declaringBean) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> BeanAttributes<T> createBeanAttributes(AnnotatedType<T> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BeanAttributes<?> createBeanAttributes(AnnotatedMember<?> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> Bean<T> createBean(BeanAttributes<T> attributes, Class<T> beanClass, InjectionTargetFactory<T> injectionTargetFactory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T, X> Bean<T> createBean(BeanAttributes<T> attributes, Class<X> beanClass, ProducerFactory<X> producerFactory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InjectionPoint createInjectionPoint(AnnotatedField<?> field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InjectionPoint createInjectionPoint(AnnotatedParameter<?> parameter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends Extension> T getExtension(Class<T> extensionClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> InterceptionFactory<T> createInterceptionFactory(CreationalContext<T> ctx, Class<T> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Event<Object> getEvent() {
        return new EventImpl<Object>((Type)((Object)Object.class), (Set<Annotation>)new HashSet<Annotation>(), null);
    }

    @Override
    public Instance<Object> createInstance() {
        return ArcContainerImpl.instance().instance;
    }

    @Override
    public boolean isMatchingBean(Set<Type> beanTypes, Set<Annotation> beanQualifiers, Type requiredType, Set<Annotation> requiredQualifiers) {
        BeanManagerImpl.illegalNull(beanTypes, "beanTypes");
        BeanManagerImpl.illegalNull(beanQualifiers, "beanQualifiers");
        BeanManagerImpl.illegalNull(requiredType, "requiredType");
        BeanManagerImpl.illegalNull(requiredQualifiers, "requiredQualifiers");
        HashSet<Object> legalBeanTypes = new HashSet<Object>();
        legalBeanTypes.add(Object.class);
        for (Type beanType : beanTypes) {
            if (Types.isIllegalBeanType(beanType)) continue;
            legalBeanTypes.add(beanType);
        }
        ArcContainerImpl.instance().registeredQualifiers.verify(beanQualifiers);
        ArcContainerImpl.instance().registeredQualifiers.verify(requiredQualifiers);
        beanQualifiers = new HashSet<Annotation>(beanQualifiers);
        beanQualifiers.add(Any.Literal.INSTANCE);
        if (beanQualifiers.stream().allMatch(it -> it.annotationType() == Any.class || it.annotationType() == Named.class)) {
            beanQualifiers.add(Default.Literal.INSTANCE);
        }
        if (requiredQualifiers.isEmpty()) {
            requiredQualifiers = Qualifiers.IP_DEFAULT_QUALIFIERS;
        }
        if (!BeanTypeAssignabilityRules.instance().matches(requiredType, legalBeanTypes)) {
            return false;
        }
        return ArcContainerImpl.instance().registeredQualifiers.hasQualifiers(beanQualifiers, requiredQualifiers.toArray(new Annotation[0]));
    }

    @Override
    public boolean isMatchingEvent(Type specifiedType, Set<Annotation> specifiedQualifiers, Type observedEventType, Set<Annotation> observedEventQualifiers) {
        BeanManagerImpl.illegalNull(specifiedType, "specifiedType");
        BeanManagerImpl.illegalNull(specifiedQualifiers, "specifiedQualifiers");
        BeanManagerImpl.illegalNull(observedEventType, "observedEventType");
        BeanManagerImpl.illegalNull(observedEventQualifiers, "observedEventQualifiers");
        if (Types.containsTypeVariable(specifiedType)) {
            throw new IllegalArgumentException("Event type contains a type variable: " + String.valueOf(specifiedType));
        }
        ArcContainerImpl.instance().registeredQualifiers.verify(specifiedQualifiers);
        ArcContainerImpl.instance().registeredQualifiers.verify(observedEventQualifiers);
        HashSet<Annotation> eventQualifiers = new HashSet<Annotation>(specifiedQualifiers);
        if (eventQualifiers.isEmpty()) {
            eventQualifiers.add(Default.Literal.INSTANCE);
        }
        eventQualifiers.add(Any.Literal.INSTANCE);
        Set<Type> eventTypes = new HierarchyDiscovery(specifiedType).getTypeClosure();
        if (!EventTypeAssignabilityRules.instance().matches(observedEventType, eventTypes)) {
            return false;
        }
        return ArcContainerImpl.instance().registeredQualifiers.isSubset(observedEventQualifiers, eventQualifiers);
    }

    private static void illegalNull(Object obj, String name) {
        if (obj == null) {
            throw new IllegalArgumentException(name + " must be set");
        }
    }
}

