/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.impl.CollectionHelpers;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedCallable;
import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class InjectionPointImpl
implements InjectionPoint {
    private final Type requiredType;
    private final Set<Annotation> qualifiers;
    private final InjectableBean<?> bean;
    private final Annotated annotated;
    private final Member member;
    private final boolean isTransient;

    public InjectionPointImpl(Type injectionPointType, Type requiredType, Set<Annotation> qualifiers, InjectableBean<?> bean, Set<Annotation> annotations, Member javaMember, int position, boolean isTransient) {
        this.requiredType = requiredType;
        this.qualifiers = CollectionHelpers.toImmutableSmallSet(qualifiers);
        this.bean = bean;
        this.annotated = javaMember instanceof Executable ? new AnnotatedParameterImpl(injectionPointType, annotations, position, (Executable)javaMember) : (javaMember instanceof Field ? new AnnotatedFieldImpl(injectionPointType, annotations, (Field)javaMember) : null);
        this.member = javaMember;
        this.isTransient = isTransient;
    }

    @Override
    public Type getType() {
        return this.requiredType;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    @Override
    public Bean<?> getBean() {
        return this.bean;
    }

    @Override
    public Member getMember() {
        return this.member;
    }

    @Override
    public Annotated getAnnotated() {
        return this.annotated;
    }

    @Override
    public boolean isDelegate() {
        return false;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    static class AnnotatedParameterImpl<X>
    extends AnnotatedBase
    implements AnnotatedParameter<X> {
        private final int position;
        private final Executable executable;

        AnnotatedParameterImpl(Type baseType, Set<Annotation> annotations, int position, Executable executable) {
            super(baseType, annotations);
            this.position = position;
            this.executable = executable;
        }

        @Override
        public int getPosition() {
            return this.position;
        }

        @Override
        public AnnotatedCallable<X> getDeclaringCallable() {
            if (this.executable instanceof Method) {
                return new AnnotatedMethodImpl((Method)this.executable);
            }
            return new AnnotatedConstructorImpl((Constructor)this.executable);
        }
    }

    static class AnnotatedFieldImpl<X>
    extends AnnotatedBase
    implements AnnotatedField<X> {
        private final Field field;

        AnnotatedFieldImpl(Type baseType, Set<Annotation> annotations, Field field) {
            super(baseType, annotations);
            this.field = field;
        }

        @Override
        public boolean isStatic() {
            return Modifier.isStatic(this.field.getModifiers());
        }

        @Override
        public AnnotatedType<X> getDeclaringType() {
            return new AnnotatedTypeImpl(this.field.getDeclaringClass());
        }

        @Override
        public Field getJavaMember() {
            return this.field;
        }
    }

    static class AnnotatedConstructorImpl<X>
    extends AnnotatedBase
    implements AnnotatedConstructor<X> {
        private final Constructor<X> constructor;

        public AnnotatedConstructorImpl(Constructor<X> constructor) {
            super(constructor.getDeclaringClass(), null);
            this.constructor = constructor;
        }

        @Override
        public List<AnnotatedParameter<X>> getParameters() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public AnnotatedType<X> getDeclaringType() {
            return new AnnotatedTypeImpl<X>(this.constructor.getDeclaringClass());
        }

        @Override
        public Constructor<X> getJavaMember() {
            return this.constructor;
        }
    }

    static class AnnotatedMethodImpl<X>
    extends AnnotatedBase
    implements AnnotatedMethod<X> {
        private final Method method;

        AnnotatedMethodImpl(Method method) {
            super(method.getGenericReturnType(), null);
            this.method = method;
        }

        @Override
        public List<AnnotatedParameter<X>> getParameters() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isStatic() {
            return Modifier.isStatic(this.method.getModifiers());
        }

        @Override
        public AnnotatedType<X> getDeclaringType() {
            return new AnnotatedTypeImpl(this.method.getDeclaringClass());
        }

        @Override
        public Method getJavaMember() {
            return this.method;
        }
    }

    static class AnnotatedTypeImpl<X>
    extends AnnotatedBase
    implements AnnotatedType<X> {
        private final Class<X> clazz;

        AnnotatedTypeImpl(Class<X> clazz) {
            super(clazz, null);
            this.clazz = clazz;
        }

        @Override
        public Class<X> getJavaClass() {
            return this.clazz;
        }

        @Override
        public Set<AnnotatedConstructor<X>> getConstructors() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<AnnotatedMethod<? super X>> getMethods() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<AnnotatedField<? super X>> getFields() {
            throw new UnsupportedOperationException();
        }
    }

    static abstract class AnnotatedBase
    implements Annotated {
        private final Type baseType;
        private final Set<Annotation> annotations;

        AnnotatedBase(Type baseType, Set<Annotation> annotations) {
            this.baseType = baseType;
            this.annotations = CollectionHelpers.toImmutableSmallSet(annotations);
        }

        @Override
        public Type getBaseType() {
            return this.baseType;
        }

        @Override
        public Set<Type> getTypeClosure() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            if (this.annotations == null) {
                throw new UnsupportedOperationException();
            }
            for (Annotation annotation : this.annotations) {
                if (!annotation.annotationType().equals(annotationType)) continue;
                return (T)annotation;
            }
            return null;
        }

        @Override
        public <T extends Annotation> Set<T> getAnnotations(Class<T> annotationType) {
            if (this.annotations == null) {
                throw new UnsupportedOperationException();
            }
            HashSet<Annotation> found = new HashSet<Annotation>();
            for (Annotation annotation : this.annotations) {
                if (!annotation.annotationType().equals(annotationType)) continue;
                found.add(annotation);
            }
            return found;
        }

        @Override
        public Set<Annotation> getAnnotations() {
            if (this.annotations == null) {
                throw new UnsupportedOperationException();
            }
            return this.annotations;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.getAnnotation(annotationType) != null;
        }
    }
}

