/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.MultiMap;
import io.vertx.core.http.impl.headers.HeadersMultiMap;

@VertxGen
public interface HttpHeaders {
    @Deprecated
    public static final String DISABLE_HTTP_HEADERS_VALIDATION_PROP_NAME = "vertx.disableHttpHeadersValidation";
    public static final boolean DISABLE_HTTP_HEADERS_VALIDATION = Boolean.getBoolean("vertx.disableHttpHeadersValidation");
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence ACCEPT = HttpHeaderNames.ACCEPT;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence ACCEPT_CHARSET = HttpHeaderNames.ACCEPT_CHARSET;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence ACCEPT_ENCODING = HttpHeaderNames.ACCEPT_ENCODING;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence ACCEPT_LANGUAGE = HttpHeaderNames.ACCEPT_LANGUAGE;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence ACCEPT_RANGES = HttpHeaderNames.ACCEPT_RANGES;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence ACCEPT_PATCH = HttpHeaderNames.ACCEPT_PATCH;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence ACCESS_CONTROL_ALLOW_CREDENTIALS = HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence ACCESS_CONTROL_ALLOW_HEADERS = HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence ACCESS_CONTROL_ALLOW_METHODS = HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence ACCESS_CONTROL_ALLOW_ORIGIN = HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence ACCESS_CONTROL_ALLOW_PRIVATE_NETWORK = HttpHeaderNames.ACCESS_CONTROL_ALLOW_PRIVATE_NETWORK;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence ACCESS_CONTROL_EXPOSE_HEADERS = HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence ACCESS_CONTROL_MAX_AGE = HttpHeaderNames.ACCESS_CONTROL_MAX_AGE;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence ACCESS_CONTROL_REQUEST_HEADERS = HttpHeaderNames.ACCESS_CONTROL_REQUEST_HEADERS;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence ACCESS_CONTROL_REQUEST_METHOD = HttpHeaderNames.ACCESS_CONTROL_REQUEST_METHOD;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence ACCESS_CONTROL_REQUEST_PRIVATE_NETWORK = HttpHeaderNames.ACCESS_CONTROL_REQUEST_PRIVATE_NETWORK;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence AGE = HttpHeaderNames.AGE;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence ALLOW = HttpHeaderNames.ALLOW;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence AUTHORIZATION = HttpHeaderNames.AUTHORIZATION;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence CACHE_CONTROL = HttpHeaderNames.CACHE_CONTROL;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence CONNECTION = HttpHeaderNames.CONNECTION;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence CONTENT_BASE = HttpHeaderNames.CONTENT_BASE;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence CONTENT_DISPOSITION = HttpHeaderNames.CONTENT_DISPOSITION;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence CONTENT_ENCODING = HttpHeaderNames.CONTENT_ENCODING;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence CONTENT_LANGUAGE = HttpHeaderNames.CONTENT_LANGUAGE;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence CONTENT_LENGTH = HttpHeaderNames.CONTENT_LENGTH;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence CONTENT_LOCATION = HttpHeaderNames.CONTENT_LOCATION;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence CONTENT_TRANSFER_ENCODING = HttpHeaderNames.CONTENT_TRANSFER_ENCODING;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence CONTENT_MD5 = HttpHeaderNames.CONTENT_MD5;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence CONTENT_RANGE = HttpHeaderNames.CONTENT_RANGE;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence CONTENT_TYPE = HttpHeaderNames.CONTENT_TYPE;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence COOKIE = HttpHeaderNames.COOKIE;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence DATE = HttpHeaderNames.DATE;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence ETAG = HttpHeaderNames.ETAG;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence EXPECT = HttpHeaderNames.EXPECT;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence EXPIRES = HttpHeaderNames.EXPIRES;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence FROM = HttpHeaderNames.FROM;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence HOST = HttpHeaderNames.HOST;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence IF_MATCH = HttpHeaderNames.IF_MATCH;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence IF_MODIFIED_SINCE = HttpHeaderNames.IF_MODIFIED_SINCE;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence IF_NONE_MATCH = HttpHeaderNames.IF_NONE_MATCH;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence LAST_MODIFIED = HttpHeaderNames.LAST_MODIFIED;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence LOCATION = HttpHeaderNames.LOCATION;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence ORIGIN = HttpHeaderNames.ORIGIN;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence PROXY_AUTHENTICATE = HttpHeaderNames.PROXY_AUTHENTICATE;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence PROXY_AUTHORIZATION = HttpHeaderNames.PROXY_AUTHORIZATION;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence REFERER = HttpHeaderNames.REFERER;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence RETRY_AFTER = HttpHeaderNames.RETRY_AFTER;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence SERVER = HttpHeaderNames.SERVER;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence TRANSFER_ENCODING = HttpHeaderNames.TRANSFER_ENCODING;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence USER_AGENT = HttpHeaderNames.USER_AGENT;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence SET_COOKIE = HttpHeaderNames.SET_COOKIE;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence APPLICATION_X_WWW_FORM_URLENCODED = HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence CHUNKED = HttpHeaderValues.CHUNKED;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence CLOSE = HttpHeaderValues.CLOSE;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence CONTINUE = HttpHeaderValues.CONTINUE;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence IDENTITY = HttpHeaderValues.IDENTITY;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence KEEP_ALIVE = HttpHeaderValues.KEEP_ALIVE;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence UPGRADE = HttpHeaderValues.UPGRADE;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence WEBSOCKET = HttpHeaderValues.WEBSOCKET;
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence DEFLATE_GZIP = HttpHeaders.createOptimized("deflate, gzip");
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence DEFLATE_GZIP_BR = HttpHeaders.createOptimized("deflate, gzip, br");
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence TEXT_HTML = HttpHeaders.createOptimized("text/html");
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence GET = HttpHeaders.createOptimized("GET");
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence VARY = HttpHeaders.createOptimized("vary");
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence PSEUDO_PATH = Http2Headers.PseudoHeaderName.PATH.value();
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence PSEUDO_AUTHORITY = Http2Headers.PseudoHeaderName.AUTHORITY.value();
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence PSEUDO_SCHEME = Http2Headers.PseudoHeaderName.SCHEME.value();
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence PSEUDO_STATUS = Http2Headers.PseudoHeaderName.STATUS.value();
    @GenIgnore(value={"permitted-type"})
    public static final CharSequence PSEUDO_METHOD = Http2Headers.PseudoHeaderName.METHOD.value();

    @GenIgnore(value={"permitted-type"})
    public static CharSequence createOptimized(String value) {
        return new AsciiString(value);
    }

    public static MultiMap headers() {
        return HeadersMultiMap.httpHeaders();
    }

    public static MultiMap set(String name, String value) {
        return HeadersMultiMap.httpHeaders().set(name, value);
    }

    @GenIgnore(value={"permitted-type"})
    public static MultiMap set(CharSequence name, CharSequence value) {
        return HeadersMultiMap.httpHeaders().set(name, value);
    }
}

