/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.CurrentContext;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.impl.ContextInstances;
import io.quarkus.arc.impl.CurrentManagedContext;
import io.quarkus.arc.impl.EventImpl;
import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.RequestScoped;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

class RequestContext
extends CurrentManagedContext {
    private static final Logger LOG = Logger.getLogger("io.quarkus.arc.requestContext");

    public RequestContext(CurrentContext<CurrentManagedContext.CurrentContextState> currentContext, EventImpl.Notifier<Object> initializedNotifier, EventImpl.Notifier<Object> beforeDestroyedNotifier, EventImpl.Notifier<Object> destroyedNotifier, Supplier<ContextInstances> contextInstances) {
        super(currentContext, contextInstances, initializedNotifier != null ? initializedNotifier::notify : null, beforeDestroyedNotifier != null ? beforeDestroyedNotifier::notify : null, destroyedNotifier != null ? destroyedNotifier::notify : null);
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return RequestScoped.class;
    }

    @Override
    protected Logger traceLog() {
        return LOG;
    }

    @Override
    protected void traceActivate(InjectableContext.ContextState initialState) {
        String stack = Arrays.stream(Thread.currentThread().getStackTrace()).skip(2L).limit(7L).map(se -> "\n\t" + se.toString()).collect(Collectors.joining());
        LOG.tracef("Activate %s %s\n\t...", (Object)(initialState != null ? Integer.toHexString(initialState.hashCode()) : "new"), (Object)stack);
    }

    @Override
    protected void traceDeactivate() {
        String stack = Arrays.stream(Thread.currentThread().getStackTrace()).skip(2L).limit(7L).map(se -> "\n\t" + se.toString()).collect(Collectors.joining());
        LOG.tracef("Deactivate%s\n\t...", (Object)stack);
    }

    @Override
    protected void traceDestroy(InjectableContext.ContextState state) {
        String stack = Arrays.stream(Thread.currentThread().getStackTrace()).skip(2L).limit(7L).map(se -> "\n\t" + se.toString()).collect(Collectors.joining());
        LOG.tracef("Destroy %s%s\n\t...", (Object)(state != null ? Integer.toHexString(state.hashCode()) : ""), (Object)stack);
    }

    @Override
    protected ContextNotActiveException notActive() {
        String msg = "Request context is not active - you can activate the request context for a specific method using the @ActivateRequestContext interceptor binding";
        return new ContextNotActiveException(msg);
    }
}

