/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.WebSocketBase;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.http.WebSocketFrameType;
import io.vertx.core.http.impl.Http1xConnectionBase;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.WebSocketInternal;
import io.vertx.core.http.impl.ws.WebSocketFrameImpl;
import io.vertx.core.http.impl.ws.WebSocketFrameInternal;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.streams.impl.InboundBuffer;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.util.List;
import java.util.UUID;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

public abstract class WebSocketImplBase<S extends WebSocketBase>
implements WebSocketInternal {
    private final boolean supportsContinuation;
    private final String textHandlerID;
    private final String binaryHandlerID;
    private final int maxWebSocketFrameSize;
    private final int maxWebSocketMessageSize;
    private final InboundBuffer<WebSocketFrameInternal> pending;
    private ChannelHandlerContext chctx;
    protected final ContextInternal context;
    private MessageConsumer binaryHandlerRegistration;
    private MessageConsumer textHandlerRegistration;
    private String subProtocol;
    private Object metric;
    private Handler<Buffer> handler;
    private Handler<WebSocketFrameInternal> frameHandler;
    private FrameAggregator frameAggregator;
    private Handler<Buffer> pongHandler;
    private Handler<Void> drainHandler;
    private Handler<Void> closeHandler;
    private Handler<Void> endHandler;
    protected final Http1xConnectionBase conn;
    private boolean writable;
    private boolean closed;
    private Short closeStatusCode;
    private String closeReason;
    private long closeTimeoutID = -1L;
    private MultiMap headers;

    WebSocketImplBase(ContextInternal context, Http1xConnectionBase conn, boolean supportsContinuation, int maxWebSocketFrameSize, int maxWebSocketMessageSize, boolean registerWebSocketWriteHandlers) {
        this.supportsContinuation = supportsContinuation;
        if (registerWebSocketWriteHandlers) {
            this.textHandlerID = "__vertx.ws." + UUID.randomUUID();
            this.binaryHandlerID = "__vertx.ws." + UUID.randomUUID();
        } else {
            this.binaryHandlerID = null;
            this.textHandlerID = null;
        }
        this.conn = conn;
        this.context = context;
        this.maxWebSocketFrameSize = maxWebSocketFrameSize;
        this.maxWebSocketMessageSize = maxWebSocketMessageSize;
        this.pending = new InboundBuffer(context);
        this.writable = !conn.isNotWritable();
        this.chctx = conn.channelHandlerContext();
        this.pending.handler(this::receiveFrame);
        this.pending.drainHandler((Void v) -> conn.doResume());
    }

    void registerHandler(EventBus eventBus) {
        if (this.binaryHandlerID != null) {
            Handler<Message> binaryHandler = msg -> this.writeBinaryFrameInternal((Buffer)msg.body());
            Handler<Message> textHandler = msg -> this.writeTextFrameInternal((String)msg.body());
            this.binaryHandlerRegistration = eventBus.localConsumer(this.binaryHandlerID).handler(binaryHandler);
            this.textHandlerRegistration = eventBus.localConsumer(this.textHandlerID).handler(textHandler);
        }
    }

    @Override
    public ChannelHandlerContext channelHandlerContext() {
        return this.chctx;
    }

    @Override
    public HttpConnection connection() {
        return this.conn;
    }

    @Override
    public String binaryHandlerID() {
        return this.binaryHandlerID;
    }

    @Override
    public String textHandlerID() {
        return this.textHandlerID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeQueueFull() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            return this.conn.isNotWritable();
        }
    }

    @Override
    public Future<Void> close() {
        return this.close((short)1000, (String)null);
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        Future<Void> future = this.close();
        if (handler != null) {
            future.onComplete(handler);
        }
    }

    @Override
    public Future<Void> close(short statusCode) {
        return this.close(statusCode, (String)null);
    }

    @Override
    public void close(short statusCode, Handler<AsyncResult<Void>> handler) {
        Future<Void> future = this.close(statusCode, (String)null);
        if (handler != null) {
            future.onComplete(handler);
        }
    }

    @Override
    public void close(short statusCode, @Nullable String reason, Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.close(statusCode, reason);
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> close(short statusCode, String reason) {
        boolean sendCloseFrame;
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            sendCloseFrame = this.closeStatusCode == null;
            if (sendCloseFrame) {
                this.closeStatusCode = statusCode;
                this.closeReason = reason;
            }
        }
        if (sendCloseFrame) {
            ByteBuf byteBuf = HttpUtils.generateWSCloseFrameByteBuf(statusCode, reason);
            CloseWebSocketFrame frame = new CloseWebSocketFrame(true, 0, byteBuf);
            PromiseInternal<Void> promise = this.context.promise();
            this.conn.writeToChannel((Object)frame, promise);
            return promise;
        }
        return this.context.succeededFuture();
    }

    @Override
    public boolean isSsl() {
        return this.conn.isSsl();
    }

    @Override
    public SSLSession sslSession() {
        return this.conn.sslSession();
    }

    @Override
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.conn.peerCertificateChain();
    }

    @Override
    public List<Certificate> peerCertificates() throws SSLPeerUnverifiedException {
        return this.conn.peerCertificates();
    }

    @Override
    public SocketAddress localAddress() {
        return this.conn.localAddress();
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.conn.remoteAddress();
    }

    @Override
    public Future<Void> writeFinalTextFrame(String text) {
        PromiseInternal<Void> promise = this.context.promise();
        this.writeFinalTextFrame(text, promise);
        return promise.future();
    }

    public S writeFinalTextFrame(String text, Handler<AsyncResult<Void>> handler) {
        return this.writeFrame(WebSocketFrame.textFrame(text, true), handler);
    }

    @Override
    public Future<Void> writeFinalBinaryFrame(Buffer data) {
        PromiseInternal<Void> promise = this.context.promise();
        this.writeFinalBinaryFrame(data, promise);
        return promise.future();
    }

    public S writeFinalBinaryFrame(Buffer data, Handler<AsyncResult<Void>> handler) {
        return this.writeFrame(WebSocketFrame.binaryFrame(data, true), handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String subProtocol() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            return this.subProtocol;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void subProtocol(String subProtocol) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.subProtocol = subProtocol;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Short closeStatusCode() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            return this.closeStatusCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String closeReason() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            return this.closeReason;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiMap headers() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            return this.headers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void headers(MultiMap responseHeaders) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.headers = responseHeaders;
        }
    }

    @Override
    public Future<Void> writeBinaryMessage(Buffer data) {
        return this.writePartialMessage(WebSocketFrameType.BINARY, data, 0);
    }

    public final S writeBinaryMessage(Buffer data, Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.writeBinaryMessage(data);
        if (handler != null) {
            fut.onComplete(handler);
        }
        return (S)this;
    }

    @Override
    public Future<Void> writeTextMessage(String text) {
        boolean isFinal;
        byte[] utf8Bytes = text.getBytes(StandardCharsets.UTF_8);
        boolean bl = isFinal = utf8Bytes.length <= this.maxWebSocketFrameSize;
        if (isFinal) {
            return this.writeFrame(new WebSocketFrameImpl(WebSocketFrameType.TEXT, utf8Bytes, true));
        }
        return this.writePartialMessage(WebSocketFrameType.TEXT, Buffer.buffer(utf8Bytes), 0);
    }

    public final S writeTextMessage(String text, Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.writeTextMessage(text);
        if (handler != null) {
            fut.onComplete(handler);
        }
        return (S)this;
    }

    @Override
    public Future<Void> write(Buffer data) {
        return this.writeFrame(WebSocketFrame.binaryFrame(data, true));
    }

    @Override
    public final void write(Buffer data, Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.write(data);
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    @Override
    public Future<Void> writePing(Buffer data) {
        if (data.length() > this.maxWebSocketFrameSize || data.length() > 125) {
            return this.context.failedFuture("Ping cannot exceed maxWebSocketFrameSize or 125 bytes");
        }
        return this.writeFrame(WebSocketFrame.pingFrame(data));
    }

    public final S writePing(Buffer data, Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.writePing(data);
        if (handler != null) {
            fut.onComplete(handler);
        }
        return (S)this;
    }

    @Override
    public Future<Void> writePong(Buffer data) {
        if (data.length() > this.maxWebSocketFrameSize || data.length() > 125) {
            return this.context.failedFuture("Pong cannot exceed maxWebSocketFrameSize or 125 bytes");
        }
        return this.writeFrame(WebSocketFrame.pongFrame(data));
    }

    public final S writePong(Buffer data, Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.writePong(data);
        if (handler != null) {
            fut.onComplete(handler);
        }
        return (S)this;
    }

    private Future<Void> writePartialMessage(WebSocketFrameType frameType, Buffer data, int offset) {
        boolean isFinal;
        int end = offset + this.maxWebSocketFrameSize;
        if (end >= data.length()) {
            end = data.length();
            isFinal = true;
        } else {
            isFinal = false;
        }
        Buffer slice = data.slice(offset, end);
        WebSocketFrame frame = offset == 0 || !this.supportsContinuation ? new WebSocketFrameImpl(frameType, slice.getByteBuf(), isFinal) : WebSocketFrame.continuationFrame(slice, isFinal);
        int newOffset = offset + this.maxWebSocketFrameSize;
        if (isFinal) {
            return this.writeFrame(frame);
        }
        this.writeFrame(frame);
        return this.writePartialMessage(frameType, data, newOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> writeFrame(WebSocketFrame frame) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            return this.unsafeWriteFrame((WebSocketFrameImpl)frame);
        }
    }

    protected final Future<Void> unsafeWriteFrame(WebSocketFrameImpl frame) {
        assert (Thread.holdsLock(this.conn));
        if (this.unsafeIsClosed()) {
            return this.context.failedFuture("WebSocket is closed");
        }
        PromiseInternal<Void> promise = this.context.promise();
        this.conn.writeToChannel((Object)WebSocketImplBase.encodeFrame(frame), promise);
        return promise.future();
    }

    public final S writeFrame(WebSocketFrame frame, Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.writeFrame(frame);
        if (handler != null) {
            fut.onComplete(handler);
        }
        return (S)this;
    }

    private void writeBinaryFrameInternal(Buffer data) {
        this.writeFrame(new WebSocketFrameImpl(WebSocketFrameType.BINARY, data.getByteBuf()));
    }

    private void writeTextFrameInternal(String str) {
        this.writeFrame(new WebSocketFrameImpl(str));
    }

    private static io.netty.handler.codec.http.websocketx.WebSocketFrame encodeFrame(WebSocketFrameImpl frame) {
        ByteBuf buf = VertxHandler.safeBuffer(frame.getBinaryData());
        switch (frame.type()) {
            case BINARY: {
                return new BinaryWebSocketFrame(frame.isFinal(), 0, buf);
            }
            case TEXT: {
                return new TextWebSocketFrame(frame.isFinal(), 0, buf);
            }
            case CLOSE: {
                return new CloseWebSocketFrame(true, 0, buf);
            }
            case CONTINUATION: {
                return new ContinuationWebSocketFrame(frame.isFinal(), 0, buf);
            }
            case PONG: {
                return new PongWebSocketFrame(buf);
            }
            case PING: {
                return new PingWebSocketFrame(buf);
            }
        }
        throw new IllegalStateException("Unsupported WebSocket msg " + frame);
    }

    void checkClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("WebSocket is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            return this.unsafeIsClosed();
        }
    }

    private boolean unsafeIsClosed() {
        assert (Thread.holdsLock(this.conn));
        return this.closed || this.closeStatusCode != null;
    }

    void handleFrame(WebSocketFrameInternal frame) {
        switch (frame.type()) {
            case PING: {
                this.conn.writeToChannel(new PongWebSocketFrame(frame.getBinaryData().copy()));
                break;
            }
            case PONG: {
                Handler<Buffer> pongHandler = this.pongHandler();
                if (pongHandler == null) break;
                this.context.dispatch(frame.binaryData(), pongHandler);
                break;
            }
            case CLOSE: {
                this.handleCloseFrame(frame);
            }
        }
        if (!this.pending.write(frame)) {
            this.conn.doPause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCloseFrame(WebSocketFrameInternal closeFrame) {
        boolean echo;
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            echo = this.closeStatusCode == null;
            this.closed = true;
            this.closeStatusCode = closeFrame.closeStatusCode();
            this.closeReason = closeFrame.closeReason();
        }
        this.handleClose(true);
        if (echo) {
            ChannelPromise fut = this.conn.channelFuture();
            this.conn.writeToChannel((Object)new CloseWebSocketFrame(this.closeStatusCode.shortValue(), this.closeReason), fut);
            fut.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)v -> this.handleCloseConnection()));
        } else {
            this.handleCloseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleClose(boolean graceful) {
        MessageConsumer textConsumer;
        MessageConsumer binaryConsumer;
        Handler<Throwable> exceptionHandler;
        Handler<Void> closeHandler;
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            closeHandler = this.closeHandler;
            exceptionHandler = this.conn::handleException;
            binaryConsumer = this.binaryHandlerRegistration;
            textConsumer = this.textHandlerRegistration;
            this.binaryHandlerRegistration = null;
            this.textHandlerRegistration = null;
            this.closeHandler = null;
        }
        if (binaryConsumer != null) {
            binaryConsumer.unregister();
        }
        if (textConsumer != null) {
            textConsumer.unregister();
        }
        if (exceptionHandler != null && !graceful) {
            this.context.dispatch(HttpUtils.CONNECTION_CLOSED_EXCEPTION, exceptionHandler);
        }
        if (closeHandler != null) {
            this.context.dispatch(null, closeHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveFrame(WebSocketFrameInternal frame) {
        FrameAggregator frameAggregator;
        Handler<WebSocketFrameInternal> frameHandler;
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            frameHandler = this.frameHandler;
            frameAggregator = this.frameAggregator;
        }
        if (frameAggregator != null) {
            this.context.dispatch(frame, frameAggregator);
        }
        if (frameHandler != null) {
            this.context.dispatch(frame, frameHandler);
        }
        switch (frame.type()) {
            case CLOSE: {
                Handler<Void> endHandler = this.endHandler();
                if (endHandler == null) break;
                this.context.dispatch(endHandler);
                break;
            }
            case BINARY: 
            case TEXT: 
            case CONTINUATION: {
                Handler<Buffer> handler = this.handler();
                if (handler == null) break;
                this.context.dispatch(frame.binaryData(), handler);
                break;
            }
            case PONG: 
            case PING: {
                this.fetch(1L);
            }
        }
    }

    protected abstract void handleCloseConnection();

    void closeConnection() {
        this.conn.channelHandlerContext().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initiateConnectionCloseTimeout(long timeoutMillis) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.closeTimeoutID = this.context.setTimer(timeoutMillis, id -> {
                Http1xConnectionBase http1xConnectionBase = this.conn;
                synchronized (http1xConnectionBase) {
                    this.closeTimeoutID = -1L;
                }
                this.closeConnection();
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S frameHandler(Handler<WebSocketFrame> handler) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            this.frameHandler = handler;
            return (S)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebSocketBase textMessageHandler(Handler<String> handler) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            if (handler != null) {
                if (this.frameAggregator == null) {
                    this.frameAggregator = new FrameAggregator();
                }
                this.frameAggregator.textMessageHandler = handler;
            } else if (this.frameAggregator != null) {
                if (this.frameAggregator.binaryMessageHandler == null) {
                    this.frameAggregator = null;
                } else {
                    this.frameAggregator.textMessageHandler = null;
                    this.frameAggregator.textMessageBuffer = null;
                }
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S binaryMessageHandler(Handler<Buffer> handler) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            if (handler != null) {
                if (this.frameAggregator == null) {
                    this.frameAggregator = new FrameAggregator();
                }
                this.frameAggregator.binaryMessageHandler = handler;
            } else if (this.frameAggregator != null) {
                if (this.frameAggregator.textMessageHandler == null) {
                    this.frameAggregator = null;
                } else {
                    this.frameAggregator.binaryMessageHandler = null;
                    this.frameAggregator.binaryMessageBuffer = null;
                }
            }
            return (S)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebSocketBase pongHandler(Handler<Buffer> handler) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            this.pongHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Handler<Buffer> pongHandler() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            return this.pongHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleWritabilityChanged(boolean writable) {
        Handler<Void> handler;
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            boolean skip = this.writable && !writable;
            this.writable = writable;
            handler = this.drainHandler;
            if (handler == null || skip) {
                return;
            }
        }
        this.context.dispatch(null, handler);
    }

    void handleException(Throwable t) {
        this.conn.handleException(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleConnectionClosed() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            if (this.closeTimeoutID != -1L) {
                this.context.owner().cancelTimer(this.closeTimeoutID);
            }
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.handleClose(false);
    }

    synchronized void setMetric(Object metric) {
        this.metric = metric;
    }

    synchronized Object getMetric() {
        return this.metric;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S handler(Handler<Buffer> handler) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            if (handler != null) {
                this.checkClosed();
            }
            this.handler = handler;
            return (S)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Handler<Buffer> handler() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            return this.handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S endHandler(Handler<Void> handler) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            if (handler != null) {
                this.checkClosed();
            }
            this.endHandler = handler;
            return (S)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Handler<Void> endHandler() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            return this.endHandler;
        }
    }

    public S exceptionHandler(Handler<Throwable> handler) {
        this.conn.exceptionHandler((Handler)handler);
        return (S)this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S closeHandler(Handler<Void> handler) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            this.closeHandler = handler;
            return (S)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S drainHandler(Handler<Void> handler) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            this.drainHandler = handler;
            return (S)this;
        }
    }

    public S pause() {
        this.pending.pause();
        return (S)this;
    }

    public S resume() {
        this.pending.resume();
        return (S)this;
    }

    public S fetch(long amount) {
        this.pending.fetch(amount);
        return (S)this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S setWriteQueueMaxSize(int maxSize) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            this.conn.doSetWriteQueueMaxSize(maxSize);
            return (S)this;
        }
    }

    @Override
    public Future<Void> end() {
        return this.close();
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.close(handler);
    }

    private class FrameAggregator
    implements Handler<WebSocketFrameInternal> {
        private Handler<String> textMessageHandler;
        private Handler<Buffer> binaryMessageHandler;
        private Buffer textMessageBuffer;
        private Buffer binaryMessageBuffer;

        private FrameAggregator() {
        }

        @Override
        public void handle(WebSocketFrameInternal frame) {
            switch (frame.type()) {
                case TEXT: {
                    this.handleTextFrame(frame);
                    break;
                }
                case BINARY: {
                    this.handleBinaryFrame(frame);
                    break;
                }
                case CONTINUATION: {
                    if (this.textMessageBuffer != null && this.textMessageBuffer.length() > 0) {
                        this.handleTextFrame(frame);
                        break;
                    }
                    if (this.binaryMessageBuffer == null || this.binaryMessageBuffer.length() <= 0) break;
                    this.handleBinaryFrame(frame);
                }
            }
        }

        private void handleTextFrame(WebSocketFrameInternal frame) {
            Buffer frameBuffer = Buffer.buffer(frame.getBinaryData());
            if (this.textMessageBuffer == null) {
                this.textMessageBuffer = frameBuffer;
            } else {
                this.textMessageBuffer.appendBuffer(frameBuffer);
            }
            if (this.textMessageBuffer.length() > WebSocketImplBase.this.maxWebSocketMessageSize) {
                int len = this.textMessageBuffer.length() - frameBuffer.length();
                this.textMessageBuffer = null;
                String msg = "Cannot process text frame of size " + frameBuffer.length() + ", it would cause message buffer (size " + len + ") to overflow max message size of " + WebSocketImplBase.this.maxWebSocketMessageSize;
                WebSocketImplBase.this.handleException(new IllegalStateException(msg));
                return;
            }
            if (frame.isFinal()) {
                String fullMessage = this.textMessageBuffer.toString();
                this.textMessageBuffer = null;
                if (this.textMessageHandler != null) {
                    this.textMessageHandler.handle(fullMessage);
                }
            }
        }

        private void handleBinaryFrame(WebSocketFrameInternal frame) {
            Buffer frameBuffer = Buffer.buffer(frame.getBinaryData());
            if (this.binaryMessageBuffer == null) {
                this.binaryMessageBuffer = frameBuffer;
            } else {
                this.binaryMessageBuffer.appendBuffer(frameBuffer);
            }
            if (this.binaryMessageBuffer.length() > WebSocketImplBase.this.maxWebSocketMessageSize) {
                int len = this.binaryMessageBuffer.length() - frameBuffer.length();
                this.binaryMessageBuffer = null;
                String msg = "Cannot process binary frame of size " + frameBuffer.length() + ", it would cause message buffer (size " + len + ") to overflow max message size of " + WebSocketImplBase.this.maxWebSocketMessageSize;
                WebSocketImplBase.this.handleException(new IllegalStateException(msg));
                return;
            }
            if (frame.isFinal()) {
                Buffer fullMessage = this.binaryMessageBuffer.copy();
                this.binaryMessageBuffer = null;
                if (this.binaryMessageHandler != null) {
                    this.binaryMessageHandler.handle(fullMessage);
                }
            }
        }
    }
}

