/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.gradle.QuarkusPluginExtension;
import io.quarkus.gradle.tasks.QuarkusTask;
import java.util.List;
import java.util.Map;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.testing.Test;

public class QuarkusTestConfig
extends QuarkusTask {
    public QuarkusTestConfig() {
        super("Sets the necessary system properties for the Quarkus tests to run.");
    }

    @TaskAction
    public void setupTest() {
        QuarkusPluginExtension quarkusExt = this.extension();
        try {
            List deploymentDeps = quarkusExt.resolveAppModel().resolveModel(quarkusExt.getAppArtifact()).getDeploymentDependencies();
            StringBuilder buf = new StringBuilder();
            for (AppDependency dep : deploymentDeps) {
                buf.append(dep.getArtifact().getPath().toUri().toURL().toExternalForm());
                buf.append(' ');
            }
            String deploymentCp = buf.toString();
            String nativeRunner = this.getProject().getBuildDir().toPath().resolve(quarkusExt.finalName() + "-runner").toAbsolutePath().toString();
            for (Test test : this.getProject().getTasks().withType(Test.class)) {
                Map props = test.getSystemProperties();
                props.put("quarkus-deployment-cp", deploymentCp);
                props.put("native.image.path", nativeRunner);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to resolve deployment classpath", e);
        }
    }
}

