/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.gradle.tasks.GradleMessageWriter;
import io.quarkus.gradle.tasks.QuarkusTask;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.platform.descriptor.resolver.json.QuarkusJsonPlatformDescriptorResolver;
import io.quarkus.platform.tools.MessageWriter;
import io.quarkus.platform.tools.config.QuarkusPlatformConfig;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;

public abstract class QuarkusPlatformTask
extends QuarkusTask {
    QuarkusPlatformTask(String description) {
        super(description);
    }

    protected void execute() {
        try {
            this.setupPlatformDescriptor();
            this.doExecute();
        }
        finally {
            QuarkusPlatformConfig.clearThreadLocal();
        }
    }

    protected abstract void doExecute();

    protected void setupPlatformDescriptor() {
        if (QuarkusPlatformConfig.hasThreadLocal()) {
            this.getProject().getLogger().debug("Quarkus platform descriptor has already been initialized");
            return;
        }
        this.getProject().getLogger().debug("Initializing Quarkus platform descriptor");
        Path currentDir = this.getProject().getProjectDir().toPath();
        Path gradlePropsPath = currentDir.resolve("gradle.properties");
        if (Files.exists(gradlePropsPath, new LinkOption[0])) {
            Properties props = new Properties();
            try (InputStream is = Files.newInputStream(gradlePropsPath, new OpenOption[0]);){
                props.load(is);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to load " + gradlePropsPath, e);
            }
            QuarkusPlatformDescriptor platform = QuarkusJsonPlatformDescriptorResolver.newInstance().setArtifactResolver(this.extension().resolveAppModel()).setMessageWriter((MessageWriter)new GradleMessageWriter(this.getProject().getLogger())).resolveFromBom(QuarkusPlatformTask.getRequiredProperty(props, "quarkusPlatformGroupId"), QuarkusPlatformTask.getRequiredProperty(props, "quarkusPlatformArtifactId"), QuarkusPlatformTask.getRequiredProperty(props, "quarkusPlatformVersion"));
            QuarkusPlatformConfig.threadLocalConfigBuilder().setPlatformDescriptor(platform).build();
        } else {
            this.getProject().getLogger().warn("Failed to locate " + gradlePropsPath + " to determine the Quarkus Platform BOM coordinates");
        }
    }

    private static String getRequiredProperty(Properties props, String name) {
        String value = props.getProperty(name);
        if (value == null) {
            throw new IllegalStateException("Required property " + name + " is missing from gradle.properties");
        }
        return value;
    }
}

