/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.cli.commands.ListExtensions;
import io.quarkus.cli.commands.file.BuildFile;
import io.quarkus.cli.commands.writer.FileProjectWriter;
import io.quarkus.cli.commands.writer.ProjectWriter;
import io.quarkus.gradle.GradleBuildFileFromConnector;
import io.quarkus.gradle.tasks.QuarkusPlatformTask;
import java.io.IOException;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class QuarkusListExtensions
extends QuarkusPlatformTask {
    private boolean all = true;
    private String format = "concise";
    private String searchPattern;

    @Optional
    @Input
    public boolean isAll() {
        return this.all;
    }

    @Option(description="List all extensions or just the installable.", option="all")
    public void setAll(boolean all) {
        this.all = all;
    }

    @Optional
    @Input
    public String getFormat() {
        return this.format;
    }

    @Option(description="Select the output format among 'name' (display the name only), 'concise' (display name and description) and 'full' (concise format and version related columns).", option="format")
    public void setFormat(String format) {
        this.format = format;
    }

    @Optional
    @Input
    public String getSearchPattern() {
        return this.searchPattern;
    }

    @Option(description="Search filter on extension list. The format is based on Java Pattern.", option="searchPattern")
    public void setSearchPattern(String searchPattern) {
        this.searchPattern = searchPattern;
    }

    public QuarkusListExtensions() {
        super("Lists the available quarkus extensions");
    }

    @TaskAction
    public void listExtensions() {
        this.execute();
    }

    @Override
    protected void doExecute() {
        try {
            new ListExtensions((BuildFile)new GradleBuildFileFromConnector((ProjectWriter)new FileProjectWriter(this.getProject().getProjectDir()))).listExtensions(this.isAll(), this.getFormat(), this.getSearchPattern());
        }
        catch (IOException e) {
            throw new GradleException("Unable to list extensions", (Throwable)e);
        }
    }
}

