/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.creator.AppCreatorException;
import io.quarkus.creator.CuratedApplicationCreator;
import io.quarkus.creator.CuratedTask;
import io.quarkus.creator.phase.generateconfig.GenerateConfigTask;
import io.quarkus.gradle.tasks.QuarkusTask;
import java.io.File;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class QuarkusGenerateConfig
extends QuarkusTask {
    private String file = "application.properties.example";

    public QuarkusGenerateConfig() {
        super("Generates an example config file");
    }

    @Optional
    @Input
    public String getFile() {
        return this.file;
    }

    @Option(description="The name of the file to generate", option="file")
    public void setFile(String file) {
        this.file = file;
    }

    @TaskAction
    public void buildQuarkus() {
        this.getLogger().lifecycle("generating example config");
        AppArtifact appArtifact = this.extension().getAppArtifact();
        AppModelResolver modelResolver = this.extension().resolveAppModel();
        try {
            AppModel appModel = modelResolver.resolveModel(appArtifact);
        }
        catch (AppModelResolverException e) {
            throw new GradleException("Failed to resolve application model " + appArtifact + " dependencies", (Throwable)e);
        }
        if (this.extension().resourcesDir().isEmpty()) {
            throw new GradleException("No resources directory, cannot create application.properties");
        }
        File target = this.extension().resourcesDir().iterator().next();
        String name = this.file;
        if (name == null || name.isEmpty()) {
            name = "application.properties.example";
        }
        try (CuratedApplicationCreator appCreationContext = CuratedApplicationCreator.builder().setWorkDir(this.getProject().getBuildDir().toPath()).build();){
            appCreationContext.runTask((CuratedTask)new GenerateConfigTask(new File(target, name).toPath()));
            this.getLogger().lifecycle("Generated config file " + name);
        }
        catch (AppCreatorException e) {
            throw new GradleException("Failed to generate config file", (Throwable)e);
        }
    }
}

