/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.util.PropertyUtils;
import io.quarkus.dev.DevModeContext;
import io.quarkus.dev.DevModeMain;
import io.quarkus.gradle.QuarkusPluginExtension;
import io.quarkus.gradle.tasks.QuarkusTask;
import io.quarkus.utilities.JavaBinFinder;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.options.Option;

public class QuarkusDev
extends QuarkusTask {
    private Set<File> filesIncludedInClasspath = new HashSet<File>();
    private File buildDir;
    private String sourceDir;
    private String workingDir;
    private String jvmArgs;
    private boolean preventnoverify = false;

    public QuarkusDev() {
        super("Development mode: enables hot deployment with background compilation");
    }

    @InputDirectory
    @Optional
    public File getBuildDir() {
        if (this.buildDir == null) {
            this.buildDir = this.getProject().getBuildDir();
        }
        return this.buildDir;
    }

    public void setBuildDir(File buildDir) {
        this.buildDir = buildDir;
    }

    @Optional
    @InputDirectory
    public File getSourceDir() {
        if (this.sourceDir == null) {
            return this.extension().sourceDir();
        }
        return new File(this.sourceDir);
    }

    @Option(description="Set source directory", option="source-dir")
    public void setSourceDir(String sourceDir) {
        this.sourceDir = sourceDir;
    }

    @Optional
    @InputDirectory
    public File getWorkingDir() {
        if (this.workingDir == null) {
            return this.extension().workingDir();
        }
        return new File(this.workingDir);
    }

    @Option(description="Set working directory", option="working-dir")
    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    @Optional
    @Input
    public String getJvmArgs() {
        return this.jvmArgs;
    }

    @Option(description="Set JVM arguments", option="jvm-args")
    public void setJvmArgs(String jvmArgs) {
        this.jvmArgs = jvmArgs;
    }

    @Optional
    @Input
    public boolean isPreventnoverify() {
        return this.preventnoverify;
    }

    @Option(description="value is intended to be set to true when some generated bytecode is erroneous causing the JVM to crash when the verify:none option is set (which is on by default)", option="prevent-noverify")
    public void setPreventnoverify(boolean preventnoverify) {
        this.preventnoverify = preventnoverify;
    }

    @TaskAction
    public void startDev() {
        Project project = this.getProject();
        QuarkusPluginExtension extension = (QuarkusPluginExtension)project.getExtensions().findByName("quarkus");
        if (!this.getSourceDir().isDirectory()) {
            throw new GradleException("The `src/main/java` directory is required, please create it.");
        }
        if (!this.extension().outputDirectory().isDirectory()) {
            throw new GradleException("The project has no output yet, this should not happen as build should have been executed first. Does the project have any source files?");
        }
        DevModeContext context = new DevModeContext();
        context.setSourceEncoding(this.getSourceEncoding());
        try {
            Object javaConvention;
            AppModel appModel;
            ArrayList<String> args = new ArrayList<String>();
            args.add(JavaBinFinder.findBin());
            String debug = System.getProperty("debug");
            String suspend = System.getProperty("suspend");
            String debugSuspend = "n";
            if (suspend != null) {
                switch (suspend.toLowerCase(Locale.ENGLISH)) {
                    case "n": 
                    case "false": {
                        debugSuspend = "n";
                        break;
                    }
                    case "": 
                    case "y": 
                    case "true": {
                        debugSuspend = "y";
                        break;
                    }
                    default: {
                        System.err.println("Ignoring invalid value \"" + suspend + "\" for \"suspend\" param and defaulting to \"n\"");
                    }
                }
            }
            if (debug == null) {
                try (Socket socket = new Socket(InetAddress.getByAddress(new byte[]{127, 0, 0, 1}), 5005);){
                    System.err.println("Port 5005 in use, not starting in debug mode");
                }
                catch (IOException e) {
                    args.add("-Xdebug");
                    args.add("-Xrunjdwp:transport=dt_socket,address=5005,server=y,suspend=" + debugSuspend);
                }
            } else if (debug.toLowerCase().equals("client")) {
                args.add("-Xdebug");
                args.add("-Xrunjdwp:transport=dt_socket,address=localhost:5005,server=n,suspend=" + debugSuspend);
            } else if (debug.toLowerCase().equals("true") || debug.isEmpty()) {
                args.add("-Xdebug");
                args.add("-Xrunjdwp:transport=dt_socket,address=localhost:5005,server=y,suspend=" + debugSuspend);
            } else if (!debug.toLowerCase().equals("false")) {
                try {
                    int port = Integer.parseInt(debug);
                    if (port <= 0) {
                        throw new GradleException("The specified debug port must be greater than 0");
                    }
                    args.add("-Xdebug");
                    args.add("-Xrunjdwp:transport=dt_socket,address=" + port + ",server=y,suspend=" + debugSuspend);
                }
                catch (NumberFormatException e) {
                    throw new GradleException("Invalid value for debug parameter: " + debug + " must be true|false|client|{port}");
                }
            }
            if (this.getJvmArgs() != null) {
                args.addAll(Arrays.asList(this.getJvmArgs().split(" ")));
            }
            args.add("-XX:TieredStopAtLevel=1");
            if (!this.isPreventnoverify()) {
                args.add("-Xverify:none");
            }
            StringBuilder classPathManifest = new StringBuilder();
            AppModelResolver modelResolver = this.extension().resolveAppModel();
            try {
                AppArtifact appArtifact = extension.getAppArtifact();
                appArtifact.setPath(extension.outputDirectory().toPath());
                appModel = modelResolver.resolveModel(appArtifact);
            }
            catch (AppModelResolverException e) {
                throw new GradleException("Failed to resolve application model " + extension.getAppArtifact() + " dependencies", (Throwable)e);
            }
            for (AppDependency appDep : appModel.getAllDependencies()) {
                this.addToClassPaths(classPathManifest, context, appDep.getArtifact().getPath().toFile());
            }
            args.add("-Djava.util.logging.manager=org.jboss.logmanager.LogManager");
            File wiringClassesDirectory = new File(this.getBuildDir(), "wiring-classes");
            wiringClassesDirectory.mkdirs();
            this.addToClassPaths(classPathManifest, context, wiringClassesDirectory);
            this.addGradlePluginDeps(classPathManifest, context);
            File tempFile = new File(this.getBuildDir(), extension.finalName() + "-dev.jar");
            tempFile.delete();
            tempFile.deleteOnExit();
            StringBuilder resources = new StringBuilder();
            String res = null;
            for (File file : extension.resourcesDir()) {
                if (resources.length() > 0) {
                    resources.append(File.pathSeparator);
                }
                resources.append(file.getAbsolutePath());
                res = file.getAbsolutePath();
            }
            Configuration compileCp = project.getConfigurations().getByName("compileClasspath");
            DependencySet compileCpDependencies = compileCp.getAllDependencies();
            for (Dependency dependency : compileCpDependencies) {
                Project dependencyProject;
                Convention convention;
                if (!(dependency instanceof ProjectDependency) || (javaConvention = (JavaPluginConvention)(convention = (dependencyProject = ((ProjectDependency)dependency).getDependencyProject()).getConvention()).findPlugin(JavaPluginConvention.class)) == null) continue;
                SourceSetContainer sourceSets = javaConvention.getSourceSets();
                SourceSet mainSourceSet = (SourceSet)sourceSets.getByName("main");
                HashSet<String> sourcePaths = new HashSet<String>();
                for (File sourceDir : mainSourceSet.getAllJava().getSrcDirs()) {
                    sourcePaths.add(sourceDir.getAbsolutePath());
                }
                String classesPaths = mainSourceSet.getOutput().getClassesDirs().getAsPath();
                String resourcePaths = mainSourceSet.getResources().getSourceDirectories().getAsPath();
                DevModeContext.ModuleInfo wsModuleInfo = new DevModeContext.ModuleInfo(dependencyProject.getName(), dependencyProject.getProjectDir().getAbsolutePath(), sourcePaths, classesPaths, resourcePaths);
                context.getModules().add(wsModuleInfo);
            }
            DevModeContext.ModuleInfo moduleInfo = new DevModeContext.ModuleInfo(project.getName(), project.getProjectDir().getAbsolutePath(), Collections.singleton(this.getSourceDir().getAbsolutePath()), extension.outputDirectory().getAbsolutePath(), res);
            context.getModules().add(moduleInfo);
            String outputClassDirectory = extension.outputDirectory().getAbsolutePath();
            String outputResourcesDirectory = extension.outputConfigDirectory().getAbsolutePath();
            context.getClassesRoots().add(extension.outputDirectory().getAbsoluteFile());
            if (!outputClassDirectory.equals(outputResourcesDirectory)) {
                context.getClassesRoots().add(extension.outputConfigDirectory().getAbsoluteFile());
            }
            context.setFrameworkClassesDir(wiringClassesDirectory.getAbsoluteFile());
            context.setCacheDir(new File(this.getBuildDir(), "transformer-cache").getAbsoluteFile());
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(tempFile));
            javaConvention = null;
            try {
                out.putNextEntry(new ZipEntry("META-INF/"));
                Manifest manifest = new Manifest();
                manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
                manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, classPathManifest.toString());
                manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, DevModeMain.class.getName());
                out.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
                manifest.write(out);
                out.putNextEntry(new ZipEntry("META-INF/dev-mode-context.dat"));
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                ObjectOutputStream obj = new ObjectOutputStream(new DataOutputStream(bytes));
                obj.writeObject(context);
                obj.close();
                out.write(bytes.toByteArray());
            }
            catch (Throwable manifest) {
                javaConvention = manifest;
                throw manifest;
            }
            finally {
                if (out != null) {
                    if (javaConvention != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable manifest) {
                            ((Throwable)javaConvention).addSuppressed(manifest);
                        }
                    } else {
                        out.close();
                    }
                }
            }
            extension.outputDirectory().mkdirs();
            args.add("-jar");
            args.add(tempFile.getAbsolutePath());
            ProcessBuilder pb = new ProcessBuilder(args.toArray(new String[0]));
            pb.redirectErrorStream(true);
            pb.redirectInput(ProcessBuilder.Redirect.INHERIT);
            pb.directory(this.getWorkingDir());
            System.out.println("Starting process: ");
            pb.command().forEach(System.out::println);
            System.out.println("Args: ");
            args.forEach(System.out::println);
            final Process p = pb.start();
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    p.destroy();
                }
            }, "Development Mode Shutdown Hook"));
            try {
                ExecutorService es = Executors.newSingleThreadExecutor();
                es.submit(() -> this.copyOutputToConsole(p.getInputStream()));
                p.waitFor();
            }
            catch (Exception e) {
                p.destroy();
                throw e;
            }
        }
        catch (Exception e) {
            throw new GradleException("Failed to run", (Throwable)e);
        }
    }

    private String getSourceEncoding() {
        Task javaCompile = this.getProject().getTasks().getByName("compileJava");
        if (javaCompile != null) {
            return ((JavaCompile)javaCompile).getOptions().getEncoding();
        }
        return null;
    }

    private void copyOutputToConsole(InputStream is) {
        try (InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (Exception e) {
            throw new GradleException("Failed to copy output to console", (Throwable)e);
        }
    }

    private void addGradlePluginDeps(StringBuilder classPathManifest, DevModeContext context) {
        Configuration conf = this.getProject().getBuildscript().getConfigurations().getByName("classpath");
        ResolvedDependency quarkusDep = conf.getResolvedConfiguration().getFirstLevelModuleDependencies().stream().filter(rd -> "quarkus-gradle-plugin".equals(rd.getModuleName())).findFirst().orElseThrow(() -> new IllegalStateException("Unable to find quarkus-gradle-plugin dependency"));
        quarkusDep.getAllModuleArtifacts().stream().map(ra -> ra.getFile()).forEach(f -> this.addToClassPaths(classPathManifest, context, (File)f));
    }

    private void addToClassPaths(StringBuilder classPathManifest, DevModeContext context, File file) {
        if (this.filesIncludedInClasspath.add(file)) {
            this.getProject().getLogger().info("Adding dependency {}", (Object)file);
            URI uri = file.toPath().toAbsolutePath().toUri();
            String path = uri.getRawPath();
            if (PropertyUtils.isWindows() && path.length() > 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':') {
                path = "/" + path;
            }
            classPathManifest.append(path);
            context.getClassPath().add(this.toUrl(uri));
            if (file.isDirectory()) {
                classPathManifest.append("/");
            }
            classPathManifest.append(" ");
        }
    }

    private URL toUrl(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Failed to convert URI to URL: " + uri, e);
        }
    }
}

