/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.creator.AppCreatorException;
import io.quarkus.creator.CuratedApplicationCreator;
import io.quarkus.creator.CuratedTask;
import io.quarkus.creator.phase.augment.AugmentTask;
import io.quarkus.gradle.tasks.QuarkusTask;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class QuarkusBuild
extends QuarkusTask {
    private String transformedClassesDirectory;
    private String wiringClassesDirectory;
    private String libDir;
    private String mainClass = "io.quarkus.runner.GeneratedMain";
    private boolean useStaticInit = true;
    private boolean uberJar = false;
    private List<String> ignoredEntries = new ArrayList<String>();

    public QuarkusBuild() {
        super("Quarkus builds a runner jar based on the build jar");
    }

    public File getTransformedClassesDirectory() {
        if (this.transformedClassesDirectory == null) {
            return this.extension().transformedClassesDirectory();
        }
        return new File(this.transformedClassesDirectory);
    }

    @Option(description="The directory for application classes transformed by processing.", option="transformed-classes-directory")
    public void setTransformedClassesDirectory(String transformedClassesDirectory) {
        this.transformedClassesDirectory = transformedClassesDirectory;
    }

    @Optional
    @Input
    public File getWiringClassesDirectory() {
        if (this.wiringClassesDirectory == null) {
            return this.extension().wiringClassesDirectory();
        }
        return new File(this.wiringClassesDirectory);
    }

    @Option(description="The directory for classes generated by processing", option="wiring-classes-directory")
    public void setWiringClassesDirectory(String wiringClassesDirectory) {
        this.wiringClassesDirectory = wiringClassesDirectory;
    }

    @Optional
    @Input
    public File getLibDir() {
        if (this.libDir == null) {
            return this.extension().libDir();
        }
        return new File(this.libDir);
    }

    @Option(description="The directory for library jars", option="lib-dir")
    public void setLibDir(String libDir) {
        this.libDir = libDir;
    }

    @Input
    @Optional
    public String getMainClass() {
        return this.mainClass;
    }

    @Option(description="Name of the main class generated by the quarkus build process", option="main-class")
    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    @Optional
    @Input
    public boolean isUseStaticInit() {
        return this.useStaticInit;
    }

    @Option(description="", option="use-static-init")
    public void setUseStaticInit(boolean useStaticInit) {
        this.useStaticInit = useStaticInit;
    }

    @Optional
    @Input
    public boolean isUberJar() {
        return this.uberJar;
    }

    @Option(description="Set to true if the build task should build an uberjar", option="uber-jar")
    public void setUberJar(boolean uberJar) {
        this.uberJar = uberJar;
    }

    @Optional
    @Input
    public List<String> getIgnoredEntries() {
        return this.ignoredEntries;
    }

    @Option(description="When using the uber-jar option, this option can be used to specify one or more entries that should be excluded from the final jar", option="ignored-entry")
    public void setIgnoredEntries(List<String> ignoredEntries) {
        this.ignoredEntries.addAll(ignoredEntries);
    }

    @TaskAction
    public void buildQuarkus() {
        this.getLogger().lifecycle("building quarkus runner");
        AppArtifact appArtifact = this.extension().getAppArtifact();
        AppModelResolver modelResolver = this.extension().resolveAppModel();
        try {
            modelResolver.resolveModel(appArtifact);
        }
        catch (AppModelResolverException e) {
            throw new GradleException("Failed to resolve application model " + appArtifact + " dependencies", (Throwable)e);
        }
        Map properties = this.getProject().getProperties();
        Properties realProperties = new Properties();
        for (Map.Entry entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key == null || !(value instanceof String) || !key.startsWith("quarkus.")) continue;
            realProperties.setProperty(key, (String)value);
        }
        realProperties.putIfAbsent("quarkus.application.name", appArtifact.getArtifactId());
        realProperties.putIfAbsent("quarkus.application.version", appArtifact.getVersion());
        boolean clear = false;
        if (this.uberJar && System.getProperty("quarkus.package.uber-jar") == null) {
            System.setProperty("quarkus.package.uber-jar", "true");
            clear = true;
        }
        try (CuratedApplicationCreator appCreationContext = CuratedApplicationCreator.builder().setWorkDir(this.getProject().getBuildDir().toPath()).setModelResolver(modelResolver).setBaseName(this.extension().finalName()).setAppArtifact(appArtifact).build();){
            AugmentTask task = AugmentTask.builder().setBuildSystemProperties(realProperties).setAppClassesDir(this.extension().outputDirectory().toPath()).setConfigDir(this.extension().outputConfigDirectory().toPath()).build();
            appCreationContext.runTask((CuratedTask)task);
        }
        catch (AppCreatorException e) {
            throw new GradleException("Failed to build a runnable JAR", (Throwable)e);
        }
        finally {
            if (clear) {
                System.clearProperty("quarkus.package.uber-jar");
            }
        }
    }
}

