/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.cli.commands.AddExtensions;
import io.quarkus.cli.commands.file.BuildFile;
import io.quarkus.cli.commands.file.GradleBuildFile;
import io.quarkus.cli.commands.writer.FileProjectWriter;
import io.quarkus.cli.commands.writer.ProjectWriter;
import io.quarkus.gradle.tasks.QuarkusPlatformTask;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class QuarkusAddExtension
extends QuarkusPlatformTask {
    private List<String> extensionsToAdd;

    public QuarkusAddExtension() {
        super("Adds Quarkus extensions specified by the user to the project.");
    }

    @Option(option="extensions", description="Configures the extensions to be added.")
    public void setExtensionsToAdd(List<String> extensionsToAdd) {
        this.extensionsToAdd = extensionsToAdd;
    }

    @Input
    public List<String> getExtensionsToAdd() {
        return this.extensionsToAdd;
    }

    @TaskAction
    public void addExtension() {
        this.execute();
    }

    @Override
    protected void doExecute() {
        Set extensionsSet = this.getExtensionsToAdd().stream().flatMap(ext -> Arrays.stream(ext.split(","))).map(String::trim).collect(Collectors.toSet());
        try {
            new AddExtensions((BuildFile)new GradleBuildFile((ProjectWriter)new FileProjectWriter(this.getProject().getProjectDir()))).addExtensions(extensionsSet);
        }
        catch (IOException e) {
            throw new GradleException("Failed to add extensions " + this.getExtensionsToAdd(), (Throwable)e);
        }
    }
}

