/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.gradle.AppModelGradleResolver;
import java.io.File;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;

public class QuarkusPluginExtension {
    private final Project project;
    private String transformedClassesDirectory = "transformed-classes";
    private String wiringClassesDirectory = "wiring-classes";
    private String libDir = "lib";
    private String outputDirectory;
    private String finalName;
    private String sourceDir;
    private String workingDir;
    private String outputConfigDirectory;

    public QuarkusPluginExtension(Project project) {
        this.project = project;
    }

    public File transformedClassesDirectory() {
        return new File(this.project.getBuildDir() + File.separator + this.transformedClassesDirectory);
    }

    public void setTransformedClassesDirectory(String transformedClassesDirectory) {
        this.transformedClassesDirectory = transformedClassesDirectory;
    }

    public File outputDirectory() {
        if (this.outputDirectory == null) {
            this.outputDirectory = ((SourceSet)((JavaPluginConvention)this.project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().getByName("main")).getOutput().getClassesDirs().getAsPath();
        }
        return new File(this.outputDirectory);
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public File outputConfigDirectory() {
        if (this.outputConfigDirectory == null) {
            this.outputConfigDirectory = ((SourceSet)((JavaPluginConvention)this.project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().getByName("main")).getOutput().getResourcesDir().getAbsolutePath();
        }
        return new File(this.outputConfigDirectory);
    }

    public void setConfigOutputDirectory(String outputDirectory) {
        this.outputConfigDirectory = outputDirectory;
    }

    public File sourceDir() {
        if (this.sourceDir == null) {
            this.sourceDir = ((SourceSet)((JavaPluginConvention)this.project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().getByName("main")).getAllJava().getSourceDirectories().getAsPath();
        }
        return new File(this.sourceDir);
    }

    public void setSourceDir(String sourceDir) {
        this.sourceDir = sourceDir;
    }

    public File workingDir() {
        if (this.workingDir == null) {
            this.workingDir = this.outputDirectory().getPath();
        }
        return new File(this.workingDir);
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public File wiringClassesDirectory() {
        return new File(this.project.getBuildDir() + File.separator + this.wiringClassesDirectory);
    }

    public void setWiringClassesDirectory(String wiringClassesDirectory) {
        this.wiringClassesDirectory = wiringClassesDirectory;
    }

    public File libDir() {
        return new File(this.project.getBuildDir() + File.separator + this.libDir);
    }

    public void setLibDir(String libDir) {
        this.libDir = libDir;
    }

    public String finalName() {
        if (this.finalName == null || this.finalName.length() == 0) {
            return this.project.getName() + "-" + this.project.getVersion();
        }
        return this.finalName;
    }

    public void setFinalName(String finalName) {
        this.finalName = finalName;
    }

    public boolean uberJar() {
        return false;
    }

    public Set<File> resourcesDir() {
        return ((SourceSet)((JavaPluginConvention)this.project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().getByName("main")).getResources().getSrcDirs();
    }

    public Set<File> dependencyFiles() {
        SourceSetContainer sourceSets = ((JavaPluginConvention)this.project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
        SourceSet sourceSet = (SourceSet)sourceSets.getByName("main");
        Set files = sourceSet.getCompileClasspath().getFiles();
        return files;
    }

    public AppArtifact getAppArtifact() {
        return new AppArtifact(this.project.getGroup().toString(), this.project.getName(), this.project.getVersion().toString());
    }

    public AppModelResolver resolveAppModel() {
        return new AppModelGradleResolver(this.project);
    }
}

