/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle;

import io.quarkus.gradle.QuarkusPluginExtension;
import io.quarkus.gradle.tasks.QuarkusAddExtension;
import io.quarkus.gradle.tasks.QuarkusBuild;
import io.quarkus.gradle.tasks.QuarkusDev;
import io.quarkus.gradle.tasks.QuarkusGenerateConfig;
import io.quarkus.gradle.tasks.QuarkusListExtensions;
import io.quarkus.gradle.tasks.QuarkusNative;
import io.quarkus.gradle.tasks.QuarkusTestConfig;
import io.quarkus.gradle.tasks.QuarkusTestNative;
import java.util.Collections;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.testing.Test;
import org.gradle.util.GradleVersion;

public class QuarkusPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        this.verifyGradleVersion();
        project.getExtensions().create("quarkus", QuarkusPluginExtension.class, new Object[]{project});
        this.registerTasks(project);
    }

    private void registerTasks(Project project) {
        TaskContainer tasks = project.getTasks();
        tasks.create("listExtensions", QuarkusListExtensions.class);
        tasks.create("addExtension", QuarkusAddExtension.class);
        Task quarkusBuild = tasks.create("quarkusBuild", QuarkusBuild.class);
        Task quarkusGenerateConfig = tasks.create("generateConfig", QuarkusGenerateConfig.class);
        Task quarkusDev = tasks.create("quarkusDev", QuarkusDev.class);
        project.getPlugins().withType(BasePlugin.class, basePlugin -> tasks.getByName("assemble").dependsOn(new Object[]{quarkusBuild}));
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> {
            Task classesTask = tasks.getByName("classes");
            quarkusDev.dependsOn(new Object[]{classesTask});
            quarkusBuild.dependsOn(new Object[]{classesTask});
            Task jarTask = tasks.getByName("jar");
            quarkusBuild.dependsOn(new Object[]{jarTask});
        });
        Task buildNative = tasks.create("buildNative", QuarkusNative.class);
        JavaPluginConvention javaPlugin2 = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
        if (javaPlugin2 != null) {
            buildNative.dependsOn(new Object[]{tasks.getByName("assemble")});
            SourceSetContainer sourceSets = javaPlugin2.getSourceSets();
            SourceSet nativeTestSourceSet = (SourceSet)sourceSets.create("native-test");
            SourceSetOutput mainSourceSetOutput = ((SourceSet)sourceSets.getByName("main")).getOutput();
            SourceSetOutput testSourceSetOutput = ((SourceSet)sourceSets.getByName("test")).getOutput();
            nativeTestSourceSet.setCompileClasspath(nativeTestSourceSet.getCompileClasspath().plus((FileCollection)mainSourceSetOutput).plus((FileCollection)testSourceSetOutput));
            nativeTestSourceSet.setRuntimeClasspath(nativeTestSourceSet.getRuntimeClasspath().plus((FileCollection)mainSourceSetOutput).plus((FileCollection)testSourceSetOutput));
            ConfigurationContainer configurations = project.getConfigurations();
            ((Configuration)configurations.maybeCreate("nativeTestImplementation")).extendsFrom(new Configuration[]{(Configuration)configurations.findByName("implementation")});
            ((Configuration)configurations.maybeCreate("nativeTestRuntimeOnly")).extendsFrom(new Configuration[]{(Configuration)configurations.findByName("runtimeOnly")});
            Task testNative = ((QuarkusTestNative)tasks.create("testNative", QuarkusTestNative.class)).dependsOn(new Object[]{buildNative});
            testNative.setShouldRunAfter(Collections.singletonList(tasks.findByName("test")));
            tasks.getByName("check").dependsOn(new Object[]{testNative});
        }
        QuarkusTestConfig quarkusTestConfig = (QuarkusTestConfig)tasks.create("quarkusTestConfig", QuarkusTestConfig.class);
        tasks.withType(Test.class).forEach(t -> {
            t.dependsOn(new Object[]{quarkusTestConfig});
            t.useJUnitPlatform();
        });
    }

    private void verifyGradleVersion() {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"5.0")) < 0) {
            throw new GradleException("Quarkus plugin requires Gradle 5.0 or later. Current version is: " + GradleVersion.current());
        }
    }
}

