/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle;

import io.quarkus.cli.commands.file.GradleBuildFile;
import io.quarkus.cli.commands.writer.ProjectWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.gradle.tooling.BuildException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.eclipse.EclipseExternalDependency;
import org.gradle.tooling.model.eclipse.EclipseProject;

public class GradleBuildFileFromConnector
extends GradleBuildFile {
    private List<Dependency> dependencies = null;

    public GradleBuildFileFromConnector(ProjectWriter writer) {
        super(writer);
    }

    public List<Dependency> getDependencies() throws IOException {
        if (this.dependencies == null) {
            EclipseProject eclipseProject = null;
            if (this.getBuildContent() != null && this.getWriter().hasFile()) {
                try {
                    ProjectConnection connection = GradleConnector.newConnector().forProjectDirectory(this.getWriter().getProjectFolder()).connect();
                    eclipseProject = (EclipseProject)connection.getModel(EclipseProject.class);
                }
                catch (BuildException e) {
                    e.printStackTrace();
                }
            }
            this.dependencies = eclipseProject != null ? eclipseProject.getClasspath().stream().map(this::gradleModuleVersionToDependency).filter(Objects::nonNull).collect(Collectors.toList()) : Collections.emptyList();
            this.dependencies = Collections.unmodifiableList(this.dependencies);
        }
        return this.dependencies;
    }

    private Dependency gradleModuleVersionToDependency(EclipseExternalDependency eed) {
        Dependency dependency = new Dependency();
        if (eed == null || eed.getGradleModuleVersion() == null) {
            System.err.println("Found null dependency:" + eed);
            return null;
        }
        dependency.setGroupId(eed.getGradleModuleVersion().getGroup());
        dependency.setArtifactId(eed.getGradleModuleVersion().getName());
        dependency.setVersion(eed.getGradleModuleVersion().getVersion());
        return dependency;
    }
}

