/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.gradle.GradleDependencyArtifact;
import io.quarkus.gradle.QuarkusExtDependency;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.provider.Provider;
import org.gradle.jvm.tasks.Jar;

public class AppModelGradleResolver
implements AppModelResolver {
    private AppModel appModel;
    private final Project project;

    public AppModelGradleResolver(Project project) {
        this.project = project;
    }

    public String getLatestVersion(AppArtifact arg0, String arg1, boolean arg2) throws AppModelResolverException {
        throw new UnsupportedOperationException();
    }

    public String getLatestVersionFromRange(AppArtifact appArtifact, String range) throws AppModelResolverException {
        throw new UnsupportedOperationException();
    }

    public String getNextVersion(AppArtifact arg0, String fromVersion, boolean fromVersionIncluded, String arg1, boolean arg2) throws AppModelResolverException {
        throw new UnsupportedOperationException();
    }

    public List<String> listLaterVersions(AppArtifact arg0, String arg1, boolean arg2) throws AppModelResolverException {
        throw new UnsupportedOperationException();
    }

    public void relink(AppArtifact arg0, Path arg1) throws AppModelResolverException {
    }

    public Path resolve(AppArtifact appArtifact) throws AppModelResolverException {
        if (!appArtifact.isResolved()) {
            GradleDependencyArtifact dep = new GradleDependencyArtifact();
            dep.setExtension(appArtifact.getType());
            dep.setType(appArtifact.getType());
            dep.setName(appArtifact.getArtifactId());
            QuarkusExtDependency gradleDep = new QuarkusExtDependency(appArtifact.getGroupId(), appArtifact.getArtifactId(), appArtifact.getVersion(), null);
            gradleDep.addArtifact(dep);
            Configuration detachedConfig = this.project.getConfigurations().detachedConfiguration(new Dependency[]{gradleDep});
            ResolvedConfiguration rc = detachedConfig.getResolvedConfiguration();
            Set resolvedArtifacts = rc.getResolvedArtifacts();
            for (ResolvedArtifact a : resolvedArtifacts) {
                if (!appArtifact.getArtifactId().equals(a.getName()) || !appArtifact.getType().equals(a.getType()) || !appArtifact.getGroupId().equals(a.getModuleVersion().getId().getGroup())) continue;
                appArtifact.setPath(a.getFile().toPath());
            }
            if (!appArtifact.isResolved()) {
                throw new AppModelResolverException("Failed to resolve " + appArtifact);
            }
        }
        return appArtifact.getPath();
    }

    public List<AppDependency> resolveUserDependencies(AppArtifact appArtifact, List<AppDependency> directDeps) throws AppModelResolverException {
        return Collections.emptyList();
    }

    public AppModel resolveModel(AppArtifact appArtifact) throws AppModelResolverException {
        if (this.appModel != null && this.appModel.getAppArtifact().equals((Object)appArtifact)) {
            return this.appModel;
        }
        Configuration compileCp = this.project.getConfigurations().getByName("compileClasspath");
        ArrayList<Dependency> extensionDeps = new ArrayList<Dependency>();
        ArrayList<AppDependency> userDeps = new ArrayList<AppDependency>();
        HashMap<ModuleIdentifier, ModuleVersionIdentifier> userModules = new HashMap<ModuleIdentifier, ModuleVersionIdentifier>();
        for (ResolvedArtifact a : compileCp.getResolvedConfiguration().getResolvedArtifacts()) {
            Dependency dep;
            File f = a.getFile();
            if (!"jar".equals(a.getExtension()) && !f.isDirectory()) continue;
            userModules.put(this.getModuleId(a), a.getModuleVersion().getId());
            userDeps.add(this.toAppDependency(a));
            if (f.isDirectory()) {
                dep = this.processQuarkusDir(a, f.toPath().resolve("META-INF"));
            } else {
                try (FileSystem artifactFs = FileSystems.newFileSystem(f.toPath(), null);){
                    dep = this.processQuarkusDir(a, artifactFs.getPath("META-INF", new String[0]));
                }
                catch (IOException e) {
                    throw new GradleException("Failed to process " + f, (Throwable)e);
                }
            }
            if (dep == null) continue;
            extensionDeps.add(dep);
        }
        ArrayList<AppDependency> deploymentDeps = new ArrayList<AppDependency>();
        if (!extensionDeps.isEmpty()) {
            Configuration deploymentConfig = this.project.getConfigurations().detachedConfiguration(extensionDeps.toArray(new Dependency[extensionDeps.size()]));
            ResolvedConfiguration rc = deploymentConfig.getResolvedConfiguration();
            for (ResolvedArtifact a : rc.getResolvedArtifacts()) {
                ModuleVersionIdentifier userVersion = (ModuleVersionIdentifier)userModules.get(this.getModuleId(a));
                if (userVersion != null) continue;
                deploymentDeps.add(this.toAppDependency(a));
            }
        }
        if (!appArtifact.isResolved()) {
            File f;
            Jar jarTask = (Jar)this.project.getTasks().findByName("jar");
            if (jarTask == null) {
                throw new AppModelResolverException("Failed to locate task 'jar' in the project.");
            }
            Provider jarProvider = jarTask.getArchiveFile();
            if (jarProvider.isPresent() && (f = ((RegularFile)jarProvider.get()).getAsFile()).exists()) {
                appArtifact.setPath(f.toPath());
            }
        }
        this.appModel = new AppModel(appArtifact, userDeps, deploymentDeps);
        return this.appModel;
    }

    public AppModel resolveModel(AppArtifact arg0, List<AppDependency> arg1) throws AppModelResolverException {
        throw new UnsupportedOperationException();
    }

    private ModuleIdentifier getModuleId(ResolvedArtifact a) {
        String[] split = a.getModuleVersion().toString().split(":");
        return DefaultModuleIdentifier.newId((String)split[0], (String)split[1]);
    }

    private AppDependency toAppDependency(ResolvedArtifact a) {
        String[] split = a.getModuleVersion().toString().split(":");
        AppArtifact appArtifact = new AppArtifact(split[0], split[1], split[2]);
        appArtifact.setPath(a.getFile().toPath());
        return new AppDependency(appArtifact, "runtime");
    }

    private Dependency processQuarkusDir(ResolvedArtifact a, Path quarkusDir) {
        if (!Files.exists(quarkusDir, new LinkOption[0])) {
            return null;
        }
        Path quarkusDescr = quarkusDir.resolve("quarkus-extension.properties");
        if (!Files.exists(quarkusDescr, new LinkOption[0])) {
            return null;
        }
        Properties extProps = this.resolveDescriptor(quarkusDescr);
        if (extProps == null) {
            return null;
        }
        String value = extProps.getProperty("deployment-artifact");
        String[] split = value.split(":");
        return new QuarkusExtDependency(split[0], split[1], split[2], null);
    }

    private Properties resolveDescriptor(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        Properties rtProps = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(path);){
            rtProps.load(reader);
        }
        catch (IOException e) {
            throw new GradleException("Failed to load extension description " + path, (Throwable)e);
        }
        return rtProps;
    }
}

