/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gcp.functions;

import io.quarkus.gcp.functions.GoogleCloudFunctionInfo;
import io.quarkus.gcp.functions.GoogleCloudFunctionsConfig;
import io.quarkus.gcp.functions.QuarkusBackgroundFunction;
import io.quarkus.gcp.functions.QuarkusCloudEventsFunction;
import io.quarkus.gcp.functions.QuarkusHttpFunction;
import io.quarkus.runtime.annotations.Recorder;
import java.util.HashMap;
import java.util.List;

@Recorder
public class GoogleCloudFunctionRecorder {
    public void selectDelegate(GoogleCloudFunctionsConfig config, List<GoogleCloudFunctionInfo> cloudFunctions) {
        HashMap<GoogleCloudFunctionInfo.FunctionType, String> delegates = new HashMap<GoogleCloudFunctionInfo.FunctionType, String>();
        if (config.function.isPresent()) {
            String functionName = config.function.get();
            boolean found = false;
            for (GoogleCloudFunctionInfo info : cloudFunctions) {
                if (!functionName.equals(info.getBeanName())) continue;
                delegates.put(info.getFunctionType(), info.getClassName());
                found = true;
            }
            if (!found) {
                throw new RuntimeException("No function named " + functionName + ", did you forget to annotate your function with @Named ?");
            }
        } else {
            for (GoogleCloudFunctionInfo info : cloudFunctions) {
                if (delegates.containsKey((Object)info.getFunctionType())) {
                    throw new RuntimeException("Multiple functions found, please use 'quarkus.google-cloud-functions.function' to select one");
                }
                delegates.put(info.getFunctionType(), info.getClassName());
            }
        }
        QuarkusHttpFunction.setDelegate((String)delegates.get((Object)GoogleCloudFunctionInfo.FunctionType.HTTP));
        QuarkusBackgroundFunction.setDelegates((String)delegates.get((Object)GoogleCloudFunctionInfo.FunctionType.BACKGROUND), (String)delegates.get((Object)GoogleCloudFunctionInfo.FunctionType.RAW_BACKGROUND));
        QuarkusCloudEventsFunction.setDelegate((String)delegates.get((Object)GoogleCloudFunctionInfo.FunctionType.CLOUD_EVENT));
    }
}

