/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.lambda.event.sqs;

import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import io.quarkus.funqy.lambda.config.FunqyAmazonConfig;
import io.quarkus.funqy.lambda.event.EventHandler;
import io.quarkus.funqy.lambda.model.pipes.BatchItemFailures;
import io.quarkus.funqy.lambda.model.pipes.Response;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class PipesSqsEventHandler
implements EventHandler<List<SQSEvent.SQSMessage>, SQSEvent.SQSMessage, Response> {
    @Override
    public Stream<SQSEvent.SQSMessage> streamEvent(List<SQSEvent.SQSMessage> event, FunqyAmazonConfig amazonConfig) {
        return event.stream();
    }

    @Override
    public String getIdentifier(SQSEvent.SQSMessage message, FunqyAmazonConfig amazonConfig) {
        return message.getMessageId();
    }

    @Override
    public Supplier<InputStream> getBody(SQSEvent.SQSMessage message, FunqyAmazonConfig amazonConfig) {
        if (message.getBody() == null) {
            return InputStream::nullInputStream;
        }
        return () -> new ByteArrayInputStream(message.getBody().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public Response createResponse(List<String> failures, FunqyAmazonConfig amazonConfig) {
        if (!amazonConfig.advancedEventHandling().sqs().reportBatchItemFailures()) {
            return null;
        }
        return new Response(failures.stream().map(BatchItemFailures::new).toList());
    }

    @Override
    public Class<SQSEvent.SQSMessage> getMessageClass() {
        return SQSEvent.SQSMessage.class;
    }
}

