/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.generate_doc;

import io.quarkus.annotation.processor.generate_doc.ConfigDocItem;
import java.util.List;
import java.util.Objects;

public class ConfigDocGeneratedOutput {
    private final String fileName;
    private final boolean searchable;
    private final boolean hasAnchorPrefix;
    private final List<ConfigDocItem> configDocItems;

    public ConfigDocGeneratedOutput(String fileName, boolean searchable, List<ConfigDocItem> configDocItems, boolean hasAnchorPrefix) {
        this.fileName = fileName;
        this.searchable = searchable;
        this.configDocItems = configDocItems;
        this.hasAnchorPrefix = hasAnchorPrefix;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public List<ConfigDocItem> getConfigDocItems() {
        return this.configDocItems;
    }

    public String getAnchorPrefix() {
        if (!this.hasAnchorPrefix) {
            return "";
        }
        String anchorPrefix = this.fileName;
        if (this.fileName.endsWith(".adoc")) {
            anchorPrefix = anchorPrefix.substring(0, anchorPrefix.length() - 5);
        }
        return anchorPrefix + "_";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigDocGeneratedOutput that = (ConfigDocGeneratedOutput)o;
        return Objects.equals(this.fileName, that.fileName);
    }

    public int hashCode() {
        return Objects.hash(this.fileName);
    }

    public String toString() {
        return "ConfigItemsOutput{fileName='" + this.fileName + "', searchable=" + this.searchable + ", configDocItems=" + String.valueOf(this.configDocItems) + "}";
    }
}

