/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config.discovery;

import io.quarkus.annotation.processor.documentation.config.discovery.ResolvedType;
import io.quarkus.annotation.processor.documentation.config.model.Deprecation;
import io.quarkus.annotation.processor.documentation.config.model.SourceElementType;
import io.quarkus.annotation.processor.documentation.config.util.TypeUtil;
import io.quarkus.annotation.processor.util.Strings;

public class DiscoveryConfigProperty {
    private final String path;
    private final String sourceType;
    private final String sourceElementName;
    private final SourceElementType sourceElementType;
    private final String defaultValue;
    private final String defaultValueForDoc;
    private final Deprecation deprecation;
    private final String mapKey;
    private final boolean unnamedMapKey;
    private final ResolvedType type;
    private final boolean converted;
    private final boolean enforceHyphenateEnumValue;
    private final boolean section;
    private final boolean sectionGenerated;

    public DiscoveryConfigProperty(String path, String sourceType, String sourceElementName, SourceElementType sourceElementType, String defaultValue, String defaultValueForDoc, Deprecation deprecation, String mapKey, boolean unnamedMapKey, ResolvedType type, boolean converted, boolean enforceHyphenateEnumValue, boolean section, boolean sectionGenerated) {
        this.path = path;
        this.sourceType = sourceType;
        this.sourceElementName = sourceElementName;
        this.sourceElementType = sourceElementType;
        this.defaultValue = defaultValue;
        this.defaultValueForDoc = defaultValueForDoc;
        this.deprecation = deprecation;
        this.mapKey = mapKey;
        this.unnamedMapKey = unnamedMapKey;
        this.type = type;
        this.converted = converted;
        this.enforceHyphenateEnumValue = enforceHyphenateEnumValue;
        this.section = section;
        this.sectionGenerated = sectionGenerated;
    }

    public String getPath() {
        return this.path;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getSourceElementName() {
        return this.sourceElementName;
    }

    public SourceElementType getSourceElementType() {
        return this.sourceElementType;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getDefaultValueForDoc() {
        return this.defaultValueForDoc;
    }

    public Deprecation getDeprecation() {
        return this.deprecation;
    }

    public boolean isDeprecated() {
        return this.deprecation != null;
    }

    public String getMapKey() {
        return this.mapKey;
    }

    public boolean isUnnamedMapKey() {
        return this.unnamedMapKey;
    }

    public ResolvedType getType() {
        return this.type;
    }

    public boolean isConverted() {
        return this.converted;
    }

    public boolean isEnforceHyphenateEnumValue() {
        return this.enforceHyphenateEnumValue;
    }

    public boolean isSection() {
        return this.section;
    }

    public boolean isSectionGenerated() {
        return this.sectionGenerated;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix + "name = " + this.path + "\n");
        sb.append(prefix + "sourceType = " + this.sourceType + "\n");
        sb.append(prefix + "sourceElementName = " + this.sourceElementName + "\n");
        sb.append(prefix + "type = " + String.valueOf(this.type) + "\n");
        if (this.defaultValue != null) {
            sb.append(prefix + "defaultValue = " + this.defaultValue + "\n");
        }
        if (this.defaultValueForDoc != null) {
            sb.append(prefix + "defaultValueForDoc = " + this.defaultValueForDoc + "\n");
        }
        if (this.deprecation != null) {
            sb.append(prefix + "deprecated = true\n");
        }
        if (this.mapKey != null) {
            sb.append(prefix + "mapKey = " + this.mapKey + "\n");
        }
        if (this.unnamedMapKey) {
            sb.append(prefix + "unnamedMapKey = true\n");
        }
        if (this.converted) {
            sb.append(prefix + "converted = true\n");
        }
        return sb.toString();
    }

    public static Builder builder(String sourceType, String sourceElementName, SourceElementType sourceElementType, ResolvedType type) {
        return new Builder(sourceType, sourceElementName, sourceElementType, type);
    }

    public static class Builder {
        private String name;
        private final String sourceType;
        private final String sourceElementName;
        private final SourceElementType sourceElementType;
        private final ResolvedType type;
        private String defaultValue;
        private String defaultValueForDoc;
        private Deprecation deprecation;
        private String mapKey;
        private boolean unnamedMapKey = false;
        private boolean converted = false;
        private boolean enforceHyphenateEnumValue = false;
        private boolean section = false;
        private boolean sectionGenerated = false;

        public Builder(String sourceType, String sourceElementName, SourceElementType sourceElementType, ResolvedType type) {
            this.sourceType = sourceType;
            this.sourceElementName = sourceElementName;
            this.sourceElementType = sourceElementType;
            this.type = type;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder defaultValueForDoc(String defaultValueForDoc) {
            this.defaultValueForDoc = defaultValueForDoc;
            return this;
        }

        public Builder deprecated(String since, String replacement, String reason) {
            this.deprecation = new Deprecation(since, replacement);
            return this;
        }

        public Builder mapKey(String mapKey) {
            this.mapKey = mapKey;
            return this;
        }

        public Builder unnamedMapKey() {
            this.unnamedMapKey = true;
            return this;
        }

        public Builder converted() {
            this.converted = true;
            return this;
        }

        public Builder enforceHyphenateEnumValues() {
            this.enforceHyphenateEnumValue = true;
            return this;
        }

        public Builder section(boolean generated) {
            this.section = true;
            this.sectionGenerated = generated;
            return this;
        }

        public DiscoveryConfigProperty build() {
            if (this.type.isPrimitive() && this.defaultValue == null) {
                this.defaultValue = TypeUtil.getPrimitiveDefaultValue(this.type.qualifiedName());
            }
            if (this.type.isDuration() && !Strings.isBlank(this.defaultValue)) {
                this.defaultValue = TypeUtil.normalizeDurationValue(this.defaultValue);
            }
            return new DiscoveryConfigProperty(this.name, this.sourceType, this.sourceElementName, this.sourceElementType, this.defaultValue, this.defaultValueForDoc, this.deprecation, this.mapKey, this.unnamedMapKey, this.type, this.converted, this.enforceHyphenateEnumValue, this.section, this.sectionGenerated);
        }
    }
}

