/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config.scanner;

import io.quarkus.annotation.processor.documentation.config.discovery.DiscoveryConfigGroup;
import io.quarkus.annotation.processor.documentation.config.discovery.DiscoveryConfigRoot;
import io.quarkus.annotation.processor.documentation.config.discovery.EnumDefinition;
import io.quarkus.annotation.processor.documentation.config.model.JavadocElements;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ConfigCollector {
    private Map<String, JavadocElements.JavadocElement> javadocElements = new HashMap<String, JavadocElements.JavadocElement>();
    private Map<String, DiscoveryConfigRoot> configRoots = new HashMap<String, DiscoveryConfigRoot>();
    private Map<String, DiscoveryConfigGroup> resolvedConfigGroups = new HashMap<String, DiscoveryConfigGroup>();
    private Map<String, EnumDefinition> resolvedEnums = new HashMap<String, EnumDefinition>();

    public void addJavadocElement(String key, JavadocElements.JavadocElement element) {
        this.javadocElements.put(key, element);
    }

    public Map<String, JavadocElements.JavadocElement> getJavadocElements() {
        return Collections.unmodifiableMap(this.javadocElements);
    }

    public void addConfigRoot(DiscoveryConfigRoot configRoot) {
        this.configRoots.put(configRoot.getQualifiedName(), configRoot);
    }

    public Collection<DiscoveryConfigRoot> getConfigRoots() {
        return Collections.unmodifiableCollection(this.configRoots.values());
    }

    public void addResolvedConfigGroup(DiscoveryConfigGroup configGroup) {
        this.resolvedConfigGroups.put(configGroup.getQualifiedName(), configGroup);
    }

    public Collection<DiscoveryConfigGroup> getResolvedConfigGroups() {
        return Collections.unmodifiableCollection(this.resolvedConfigGroups.values());
    }

    public DiscoveryConfigGroup getResolvedConfigGroup(String configGroupClassName) {
        return this.resolvedConfigGroups.get(configGroupClassName);
    }

    public boolean isConfigGroup(String className) {
        return this.isResolvedConfigGroup(className);
    }

    public boolean isResolvedConfigGroup(String className) {
        return this.resolvedConfigGroups.containsKey(className);
    }

    public void addResolvedEnum(EnumDefinition enumDefinition) {
        this.resolvedEnums.put(enumDefinition.qualifiedName(), enumDefinition);
    }

    public boolean isEnum(String className) {
        return this.isResolvedEnum(className);
    }

    public boolean isResolvedEnum(String className) {
        return this.resolvedEnums.containsKey(className);
    }

    public EnumDefinition getResolvedEnum(String name) {
        EnumDefinition enumDefinition = this.resolvedEnums.get(name);
        if (enumDefinition == null) {
            throw new IllegalStateException("Could not find registered EnumDefinition for " + name);
        }
        return enumDefinition;
    }

    public Map<String, EnumDefinition> getResolvedEnums() {
        return this.resolvedEnums;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("=======================================================\n");
        sb.append("= Config roots\n");
        sb.append("=======================================================\n\n");
        for (DiscoveryConfigRoot configRoot : this.configRoots.values()) {
            sb.append("- " + configRoot.getQualifiedName() + "\n");
            sb.append(configRoot.toString("  "));
            sb.append("\n\n===\n\n");
        }
        if (this.configRoots.isEmpty()) {
            sb.append(" No config roots were detected\n\n");
        }
        sb.append("=======================================================\n");
        sb.append("= Config groups\n");
        sb.append("=======================================================\n\n");
        for (DiscoveryConfigGroup configGroup : this.resolvedConfigGroups.values()) {
            sb.append("- " + configGroup.getQualifiedName() + "\n");
            sb.append(configGroup.toString("  "));
            sb.append("\n\n===\n\n");
        }
        if (this.resolvedConfigGroups.isEmpty()) {
            sb.append(" No config groups were detected\n\n");
        }
        return sb.toString();
    }
}

