/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config.model;

import io.quarkus.annotation.processor.documentation.config.model.AbstractConfigItem;
import io.quarkus.annotation.processor.documentation.config.model.ConfigItemCollection;
import io.quarkus.annotation.processor.documentation.config.model.ConfigProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ConfigSection
extends AbstractConfigItem
implements ConfigItemCollection {
    private boolean generated;
    private final List<AbstractConfigItem> items = new ArrayList<AbstractConfigItem>();
    private final int level;

    public ConfigSection(String sourceClass, String sourceName, String path, String type, int level, boolean generated, boolean deprecated) {
        super(sourceClass, sourceName, path, type, deprecated);
        this.generated = generated;
        this.level = level;
    }

    @Override
    public void addItem(AbstractConfigItem item) {
        this.items.add(item);
    }

    @Override
    public List<AbstractConfigItem> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    @Override
    public int compareTo(AbstractConfigItem o) {
        if (o instanceof ConfigProperty) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isSection() {
        return true;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public int getLevel() {
        return this.level;
    }

    public void appendState(boolean generated, boolean deprecated) {
        this.generated = this.generated || generated;
        this.deprecated = this.deprecated && deprecated;
    }

    public void merge(ConfigSection other, Map<String, ConfigSection> existingConfigSections) {
        this.generated = this.generated || other.generated;
        for (AbstractConfigItem otherItem : other.getItems()) {
            if (otherItem instanceof ConfigSection) {
                ConfigSection otherConfigSection = (ConfigSection)otherItem;
                ConfigSection similarConfigSection = existingConfigSections.get(otherConfigSection.getPath());
                if (similarConfigSection == null) {
                    this.items.add(otherConfigSection);
                    continue;
                }
                similarConfigSection.merge(otherConfigSection, existingConfigSections);
                continue;
            }
            if (otherItem instanceof ConfigProperty) {
                ConfigProperty configProperty = (ConfigProperty)otherItem;
                this.items.add(configProperty);
                continue;
            }
            throw new IllegalStateException("Unknown item type: " + String.valueOf(otherItem.getClass()));
        }
        Collections.sort(this.items);
    }

    @Override
    public boolean hasDurationType() {
        for (AbstractConfigItem item : this.items) {
            if (!item.hasDurationType() || item.deprecated) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasMemorySizeType() {
        for (AbstractConfigItem item : this.items) {
            if (!item.hasMemorySizeType() || item.deprecated) continue;
            return true;
        }
        return false;
    }
}

