/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.jdbc;

import io.quarkus.agroal.DataSource;
import io.quarkus.arc.Arc;
import io.quarkus.elytron.security.jdbc.AttributeMappingConfig;
import io.quarkus.elytron.security.jdbc.JdbcSecurityRealmRuntimeConfig;
import io.quarkus.elytron.security.jdbc.PrincipalQueriesConfig;
import io.quarkus.elytron.security.jdbc.PrincipalQueryConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.security.Provider;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.wildfly.security.auth.realm.jdbc.ColumnMapper;
import org.wildfly.security.auth.realm.jdbc.JdbcSecurityRealm;
import org.wildfly.security.auth.realm.jdbc.JdbcSecurityRealmBuilder;
import org.wildfly.security.auth.realm.jdbc.QueryBuilder;
import org.wildfly.security.auth.realm.jdbc.mapper.AttributeMapper;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.password.WildFlyElytronPasswordProvider;

@Recorder
public class JdbcRecorder {
    private static final Provider[] PROVIDERS = new Provider[]{new WildFlyElytronPasswordProvider()};
    private final RuntimeValue<JdbcSecurityRealmRuntimeConfig> runtimeConfig;

    public JdbcRecorder(RuntimeValue<JdbcSecurityRealmRuntimeConfig> runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
    }

    public RuntimeValue<SecurityRealm> createRealm() {
        Supplier<Provider[]> providers = new Supplier<Provider[]>(){

            @Override
            public Provider[] get() {
                return PROVIDERS;
            }
        };
        JdbcSecurityRealmBuilder builder = JdbcSecurityRealm.builder().setProviders((Supplier)providers);
        PrincipalQueriesConfig principalQueries = ((JdbcSecurityRealmRuntimeConfig)this.runtimeConfig.getValue()).principalQueries();
        this.registerPrincipalQuery(principalQueries.defaultPrincipalQuery(), builder);
        principalQueries.namedPrincipalQueries().forEach((name, principalQuery) -> this.registerPrincipalQuery((PrincipalQueryConfig)principalQuery, builder));
        return new RuntimeValue((Object)builder.build());
    }

    private void registerPrincipalQuery(PrincipalQueryConfig principalQuery, JdbcSecurityRealmBuilder builder) {
        QueryBuilder queryBuilder = builder.principalQuery(principalQuery.sql().orElseThrow(() -> new IllegalStateException("quarkus.security.jdbc.principal-query.sql property must be set"))).from(this.getDataSource(principalQuery));
        AttributeMapper[] mappers = (AttributeMapper[])principalQuery.attributeMappings().entrySet().stream().map(entry -> new AttributeMapper(((AttributeMappingConfig)entry.getValue()).index(), ((AttributeMappingConfig)entry.getValue()).to())).toArray(AttributeMapper[]::new);
        queryBuilder.withMapper((ColumnMapper[])mappers);
        if (principalQuery.clearPasswordMapperConfig().enabled()) {
            queryBuilder.withMapper(new ColumnMapper[]{principalQuery.clearPasswordMapperConfig().toPasswordKeyMapper()});
        }
        if (principalQuery.bcryptPasswordKeyMapperConfig().enabled()) {
            queryBuilder.withMapper(new ColumnMapper[]{principalQuery.bcryptPasswordKeyMapperConfig().toPasswordKeyMapper()});
        }
    }

    private DataSource getDataSource(PrincipalQueryConfig principalQuery) {
        if (principalQuery.datasource().isPresent()) {
            return (DataSource)Arc.container().instance(DataSource.class, new Annotation[]{new DataSource.DataSourceLiteral(principalQuery.datasource().get())}).get();
        }
        return (DataSource)Arc.container().instance(DataSource.class, new Annotation[0]).get();
    }
}

