/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.jdbc;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.smallrye.config.WithDefault;
import org.wildfly.security.auth.realm.jdbc.mapper.PasswordKeyMapper;
import org.wildfly.security.password.spec.Encoding;

@ConfigGroup
public interface BcryptPasswordKeyMapperConfig {
    public static final String BCRYPT = "bcrypt";

    @WithDefault(value="false")
    public boolean enabled();

    @WithDefault(value="0")
    public int passwordIndex();

    @WithDefault(value="BASE64")
    public Encoding hashEncoding();

    @WithDefault(value="-1")
    public int saltIndex();

    @WithDefault(value="BASE64")
    public Encoding saltEncoding();

    @WithDefault(value="-1")
    public int iterationCountIndex();

    default public PasswordKeyMapper toPasswordKeyMapper() {
        return PasswordKeyMapper.builder().setDefaultAlgorithm(BCRYPT).setHashColumn(this.passwordIndex()).setHashEncoding(this.hashEncoding()).setSaltColumn(this.saltIndex()).setSaltEncoding(this.saltEncoding()).setIterationCountColumn(this.iterationCountIndex()).build();
    }

    public String toString();
}

