/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.docs.generation;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptorBuilder;
import org.codehaus.plexus.util.xml.XmlStreamReader;

public class QuarkusMavenPluginDocsGenerator {
    private static final String QUARKUS_MAVEN_PLUGIN = "quarkus-maven-plugin-";
    private static final String GOAL_PARAMETER_ANCHOR_FORMAT = "quarkus-maven-plugin-goal-%s-%s";

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            throw new IllegalArgumentException("Path for input and output were not provided");
        }
        Path pluginXmlDescriptorPath = Path.of(args[0], new String[0]);
        Path mavenPluginAdocPath = Path.of(args[1], new String[0]);
        if (!Files.exists(pluginXmlDescriptorPath, new LinkOption[0]) || !Files.isRegularFile(pluginXmlDescriptorPath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.valueOf(pluginXmlDescriptorPath) + " does not exist or is not a regular file");
        }
        PluginDescriptor pluginDescriptor = null;
        try (XmlStreamReader input = new XmlStreamReader((InputStream)new FileInputStream(pluginXmlDescriptorPath.toFile()));){
            pluginDescriptor = new PluginDescriptorBuilder().build((Reader)input);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to deserialize PluginDescriptor", e);
        }
        if (pluginDescriptor != null && (pluginDescriptor.getMojos() == null || pluginDescriptor.getMojos().isEmpty())) {
            return;
        }
        StringBuilder asciidoc = new StringBuilder();
        for (MojoDescriptor mojo : pluginDescriptor.getMojos()) {
            asciidoc.append("= ").append(mojo.getFullGoalName()).append("\n\n");
            if (mojo.getDescription() != null && !mojo.getDescription().isBlank()) {
                asciidoc.append(mojo.getDescription()).append("\n\n");
            }
            if (mojo.getParameters() == null || mojo.getParameters().isEmpty()) continue;
            asciidoc.append("[.configuration-reference, cols=\"70,15,15\"]\n");
            asciidoc.append("|===\n\n");
            asciidoc.append("h|[[").append(String.format(GOAL_PARAMETER_ANCHOR_FORMAT, mojo.getGoal(), "parameter-table")).append("]] Parameter\n");
            asciidoc.append("h|Type\n");
            asciidoc.append("h|Default value\n\n");
            for (Parameter parameter : mojo.getParameters()) {
                String property = QuarkusMavenPluginDocsGenerator.getPropertyFromExpression(parameter.getExpression());
                String name = Optional.ofNullable(property).orElseGet(() -> ((Parameter)parameter).getName());
                asciidoc.append("a| [[").append(String.format(GOAL_PARAMETER_ANCHOR_FORMAT, mojo.getGoal(), name)).append("]] ").append(name).append("\n");
                if (parameter.getDescription() != null && !parameter.getDescription().isBlank()) {
                    asciidoc.append("\n[.description]\n--\n").append(QuarkusMavenPluginDocsGenerator.escapeCellContent(parameter.getDescription())).append("\n--\n");
                }
                asciidoc.append("|").append("`" + QuarkusMavenPluginDocsGenerator.simplifyType(parameter.getType()) + "`").append(parameter.isRequired() ? " (required)" : "").append("\n");
                asciidoc.append("|").append((String)(parameter.getDefaultValue() != null && !parameter.getDefaultValue().isEmpty() ? "`" + QuarkusMavenPluginDocsGenerator.escapeCellContent(parameter.getDefaultValue()) + "`" : "")).append("\n\n");
            }
            asciidoc.append("|===\n\n");
        }
        Files.createDirectories(mavenPluginAdocPath.getParent(), new FileAttribute[0]);
        Files.writeString(mavenPluginAdocPath, (CharSequence)asciidoc.toString(), new OpenOption[0]);
    }

    private static String getPropertyFromExpression(String expression) {
        if (expression != null && !expression.isEmpty() && expression.startsWith("${") && expression.endsWith("}") && !expression.substring(2).contains("${")) {
            return expression.substring(2, expression.length() - 1);
        }
        return null;
    }

    private static String simplifyType(String type) {
        if (type == null || type.isBlank() || type.indexOf(46) == -1) {
            return type;
        }
        return type.substring(type.lastIndexOf(46) + 1);
    }

    private static String escapeCellContent(String value) {
        if (value == null) {
            return null;
        }
        return value.replace("|", "\\|");
    }
}

