/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.docs.generation;

import io.fabric8.maven.Maven;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.collections.api.multimap.Multimap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.multimap.sortedset.MutableSortedSetMultimap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.factory.Multimaps;
import org.eclipse.collections.impl.tuple.Tuples;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.JavaDocCapable;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class QuarkusBuildItemDoc {
    public Path outputFile;
    public List<Path> paths;
    private PrintStream out = System.out;

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Must specify output file (first) followed by at least one source directory");
            System.exit(1);
        }
        QuarkusBuildItemDoc buildItemDoc = new QuarkusBuildItemDoc();
        buildItemDoc.outputFile = Path.of(args[0], new String[0]);
        buildItemDoc.paths = Arrays.stream(args).skip(1L).map(x$0 -> Path.of(x$0, new String[0])).collect(Collectors.toList());
        try {
            buildItemDoc.run();
        }
        catch (Exception e) {
            System.err.println("Exception occurred while trying to collect build item documentation");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void run() throws Exception {
        if (this.outputFile != null) {
            Files.createDirectories(this.outputFile.getParent(), new FileAttribute[0]);
            this.out = new PrintStream(Files.newOutputStream(this.outputFile, new OpenOption[0]));
        }
        Multimap<String, Pair<Path, JavaClassSource>> multimap = this.collect();
        Map<String, String> names = this.extractNames(Paths.get(".", new String[0]), (Iterable<String>)multimap.keySet());
        this.printTableHeader(names.remove("Core"));
        for (Pair source : multimap.get((Object)"Core")) {
            this.printTableRow((Pair<Path, JavaClassSource>)source);
        }
        this.printTableFooter();
        names.forEach((key, name) -> {
            this.printTableHeader((String)name);
            for (Pair source : multimap.get(key)) {
                this.printTableRow((Pair<Path, JavaClassSource>)source);
            }
            this.printTableFooter();
        });
    }

    private String getJavaDoc(JavaDocCapable<?> source) {
        if (!source.hasJavaDoc()) {
            return "<i>No Javadoc found</i>";
        }
        return source.getJavaDoc().getFullText();
    }

    private Multimap<String, Pair<Path, JavaClassSource>> collect() throws IOException {
        MutableSortedSetMultimap multimap = Multimaps.mutable.sortedSet.with(Comparator.comparing(o -> ((JavaClassSource)o.getTwo()).getName()));
        for (Path path : this.paths) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>((MutableMultimap)multimap){
                final /* synthetic */ MutableMultimap val$multimap;
                {
                    this.val$multimap = mutableMultimap;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.toString().endsWith("BuildItem.java")) {
                        QuarkusBuildItemDoc.this.process((MutableMultimap<String, Pair<Path, JavaClassSource>>)this.val$multimap, file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return multimap;
    }

    private void process(MutableMultimap<String, Pair<Path, JavaClassSource>> multimap, Path path) throws IOException {
        JavaClassSource source = (JavaClassSource)Roaster.parse(JavaClassSource.class, (File)path.toFile());
        if (!source.hasAnnotation(Deprecated.class) && source.isPublic()) {
            String name;
            Path pom = this.findPom(path);
            if (pom != null) {
                name = Maven.readModel((Path)pom).getName();
            } else {
                String pathString = path.toString();
                int spiIdx = pathString.indexOf("/spi/src");
                int runtimeIdx = pathString.indexOf("/runtime/src");
                int deploymentIdx = pathString.indexOf("/deployment/src");
                int idx = Math.max(Math.max(spiIdx, runtimeIdx), deploymentIdx);
                int extensionsIdx = pathString.indexOf("extensions/");
                int startIdx = 0;
                if (extensionsIdx != -1) {
                    startIdx = extensionsIdx + 11;
                }
                name = idx == -1 ? pathString.substring(startIdx, pathString.indexOf("/", startIdx + 1)) : pathString.substring(startIdx, idx);
            }
            name = name.replace("Quarkus - ", "").replace(" - Deployment", "");
            Pair pair = Tuples.pair((Object)path, (Object)source);
            multimap.put((Object)name, (Object)pair);
        }
    }

    private Path findPom(Path path) {
        Path pom = null;
        Path parent = path;
        while (pom == null && (parent = parent.getParent()) != null) {
            Path resolve = parent.resolve("pom.xml");
            if (!Files.exists(resolve, new LinkOption[0])) continue;
            pom = resolve;
        }
        return pom;
    }

    private Map<String, String> extractNames(Path root, Iterable<String> extensionDirs) throws IOException {
        TreeMap<String, String> names = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        for (String extension : extensionDirs) {
            Path yamlPath = root.resolve("extensions/" + extension + "/runtime/src/main/resources/META-INF/quarkus-extension.yaml");
            if (Files.exists(yamlPath, new LinkOption[0])) {
                InputStream is = Files.newInputStream(yamlPath, new OpenOption[0]);
                try {
                    Map map = (Map)yaml.load(is);
                    names.put(extension, (String)map.get("name"));
                    continue;
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                    continue;
                }
            }
            names.put(extension, extension);
        }
        return names;
    }

    private void printTableHeader(String title) {
        this.out.println("== " + title);
        this.out.println("[.configuration-reference,cols=2*]");
        this.out.println("|===");
        this.out.println("h|Class Name\nh|Attributes \n\n");
    }

    private void printTableRow(Pair<Path, JavaClassSource> pair) {
        Path root = Paths.get(".", new String[0]).toAbsolutePath().normalize();
        String link = "https://github.com/quarkusio/quarkus/blob/main/" + String.valueOf(root.relativize(((Path)pair.getOne()).normalize()));
        JavaClassSource source = (JavaClassSource)pair.getTwo();
        String className = source.getQualifiedName();
        String attributes = this.buildAttributes(source);
        String description = this.getJavaDoc((JavaDocCapable<?>)source);
        String baseBuildItemText = source.isAbstract() ? "icon:building[title=Non-instantiatable Build Item (can be inherited from)]" : "";
        String linkToClass = String.format("%s[`%s`, window=\"_blank\"]", link, className);
        this.out.println(String.format("\n\na|%s %s\n[.description]\n--\n%s\n-- a|%s", baseBuildItemText, linkToClass, this.javadocToAsciidoc(description), attributes));
    }

    private String buildAttributes(JavaClassSource source) {
        StringBuilder sb = new StringBuilder();
        for (FieldSource field : source.getFields()) {
            if (field.isStatic()) continue;
            sb.append(String.format("`%s %s` \n\n%s\n\n", field.getType().getQualifiedNameWithGenerics(), field.getName(), this.javadocToAsciidoc(this.getJavaDoc((JavaDocCapable<?>)field))));
        }
        return sb.length() == 0 ? "None" : sb.toString();
    }

    private void printTableFooter() {
        this.out.println("|===");
    }

    private String javadocToAsciidoc(String content) {
        return content.replaceAll("<p> *", "\n").replaceAll("</p> *", "\n").replaceAll("<br> *", "\n").replaceAll("\\{?@(link|see|code) ([^}]*)}", "`$2`").replaceAll("<pre>", "```\n").replaceAll("</pre>", "\n```").replaceAll("<h2>", "\n[discrete]\n== ").replaceAll("</h2> *", "\n\n").replaceAll("</?i>", "_").replaceAll("</?ul> *", "\n").replaceAll("<li>", "\n* ").replaceAll("</li> *", "\n\n").replaceAll("</?tt>", "`").replaceAll("<a href=\"([^\"]*)\">([^<]*)</a>", "$1[$2,window=_blank]");
    }
}

