/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.docs.generation;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CopyExampleSource {
    public Path outputPath;
    public Path rootPath;
    public List<Path> srcPaths;
    Map<String, String> allTargets = new HashMap<String, String>();

    static Path docsDir() {
        Path path = Paths.get(System.getProperty("user.dir"), new String[0]);
        if (path.endsWith("docs")) {
            return path;
        }
        return path.resolve("docs");
    }

    public static void main(String[] args) throws Exception {
        CopyExampleSource copyExamples = new CopyExampleSource();
        if (args.length < 1) {
            System.err.println("Must specify target output directory");
            System.exit(1);
        }
        copyExamples.outputPath = Path.of(args[0], new String[0]).normalize();
        System.out.println("[INFO] Output directory: " + String.valueOf(copyExamples.outputPath));
        copyExamples.rootPath = args.length > 1 ? Path.of(args[1], new String[0]).normalize() : CopyExampleSource.docsDir().resolve("..").normalize();
        System.out.println("[INFO] Project root: " + String.valueOf(copyExamples.rootPath));
        copyExamples.srcPaths = args.length > 2 ? Arrays.stream(args).skip(2L).map(x -> Path.of(x, new String[0]).normalize()).collect(Collectors.toList()) : List.of(CopyExampleSource.docsDir().resolve("src/main/asciidoc").normalize());
        try {
            copyExamples.run();
        }
        catch (Exception e) {
            System.err.println("Exception occurred while trying to copy examples");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void run() throws Exception {
        Files.createDirectories(this.outputPath, new FileAttribute[0]);
        final ObjectMapper om = new ObjectMapper((JsonFactory)new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES)).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        for (Path path : this.srcPaths) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    if (path.toString().endsWith("-examples.yaml")) {
                        System.out.println("[INFO] Reading: " + String.valueOf(path));
                        MappingList mapping = (MappingList)om.readValue(path.toFile(), MappingList.class);
                        for (Example example : mapping.examples) {
                            Path relativePath = Path.of(example.source, new String[0]);
                            Path sourcePath = CopyExampleSource.this.rootPath.resolve(relativePath);
                            Path targetPath = CopyExampleSource.this.outputPath.resolve(example.target);
                            if (Files.exists(sourcePath, new LinkOption[0])) {
                                String former = CopyExampleSource.this.allTargets.put(example.target, example.source);
                                if (former != null) {
                                    System.err.printf("[ERROR] Duplicate target: %s%n        Previous value: %s%n        New value: %s%n", example.target, former, example.source);
                                    mapping.duplicateKey = true;
                                    continue;
                                }
                                Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                                try {
                                    BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(sourcePath, StandardOpenOption.READ), "UTF-8"));
                                    try {
                                        PrintWriter bw = new PrintWriter(new OutputStreamWriter(Files.newOutputStream(targetPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING)));
                                        try {
                                            String line;
                                            while ((line = br.readLine()) != null) {
                                                if (line.startsWith("// Source: {{source}}")) {
                                                    bw.println("// Source: " + String.valueOf(relativePath));
                                                    continue;
                                                }
                                                if (line.startsWith("# Source: {{source}}")) {
                                                    bw.println("# Source: " + String.valueOf(relativePath));
                                                    continue;
                                                }
                                                bw.println(line);
                                            }
                                            System.out.printf("[INFO] Copied %s %n        to %s%n", relativePath, targetPath);
                                            continue;
                                        }
                                        finally {
                                            bw.close();
                                            continue;
                                        }
                                    }
                                    finally {
                                        br.close();
                                        continue;
                                    }
                                }
                                catch (IOException ioe) {
                                    System.err.printf("[ERROR] Error copying %s %n        to %s%n", relativePath, targetPath);
                                    throw ioe;
                                }
                            }
                            System.err.println("[ERROR] Specified source file doesn't exist: " + String.valueOf(sourcePath));
                            mapping.missingSource = true;
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    static class Example {
        String source;
        String target;

        Example() {
        }
    }

    static class MappingList {
        List<Example> examples;
        @JsonIgnore
        boolean missingSource = false;
        @JsonIgnore
        boolean duplicateKey = false;

        MappingList() {
        }
    }
}

