/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.mcp;

import io.quarkus.devui.runtime.comms.JsonRpcResponseWriter;
import io.quarkus.devui.runtime.comms.MessageType;
import io.quarkus.devui.runtime.jsonrpc.json.JsonMapper;
import io.quarkus.devui.runtime.mcp.model.tool.CallToolResult;
import io.vertx.core.http.HttpServerResponse;
import java.nio.charset.StandardCharsets;

public class McpResponseWriter
implements JsonRpcResponseWriter {
    private final HttpServerResponse response;
    private final String requestMethodName;
    private final JsonMapper jsonMapper;

    public McpResponseWriter(HttpServerResponse response, JsonMapper jsonMapper, String requestMethodName) {
        this.response = response;
        this.jsonMapper = jsonMapper;
        this.requestMethodName = requestMethodName;
    }

    @Override
    public void write(String message) {
        String output = message + "\n\n";
        int length = output.getBytes(StandardCharsets.UTF_8).length;
        if (!this.response.closed()) {
            this.response.putHeader("Content-Type", "application/json").putHeader("Content-Length", String.valueOf(length)).end(output);
        }
    }

    @Override
    public void close() {
        this.response.end();
    }

    @Override
    public boolean isOpen() {
        return !this.response.closed();
    }

    @Override
    public boolean isClosed() {
        return this.response.closed();
    }

    public HttpServerResponse getResponse() {
        return this.response;
    }

    @Override
    public Object decorateObject(Object object, MessageType messageType) {
        if (this.requestMethodName.equalsIgnoreCase("initialize") || this.requestMethodName.equalsIgnoreCase("notification") || this.requestMethodName.equalsIgnoreCase("tools/list") || this.requestMethodName.equalsIgnoreCase("resources/list") || this.requestMethodName.equalsIgnoreCase("resources/read")) {
            return object;
        }
        String text = this.jsonMapper.toString(object, true);
        return new CallToolResult(text);
    }
}

