/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.jsonrpc;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Usage;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public final class JsonRpcMethod {
    private Class bean;
    private String methodName;
    private String description;
    private Method javaMethod;
    private Map<String, Parameter> parameters;
    private List<Usage> usage;
    private boolean mcpEnabledByDefault = false;
    private RuntimeValue runtimeValue;
    private boolean isExplicitlyBlocking;
    private boolean isExplicitlyNonBlocking;
    private static final String UNDERSCORE = "_";

    public Class getBean() {
        return this.bean;
    }

    public void setBean(Class bean) {
        this.bean = bean;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getJavaMethodName() {
        if (this.methodName.contains(UNDERSCORE)) {
            return this.methodName.substring(this.methodName.indexOf(UNDERSCORE) + 1);
        }
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Usage> getUsage() {
        return this.usage;
    }

    public void setUsage(List<Usage> usage) {
        this.usage = usage;
    }

    public boolean isMcpEnabledByDefault() {
        return this.mcpEnabledByDefault;
    }

    public void setMcpEnabledByDefault(boolean mcpEnabledByDefault) {
        this.mcpEnabledByDefault = mcpEnabledByDefault;
    }

    public Method getJavaMethod() {
        return this.javaMethod;
    }

    public void setJavaMethod(Method javaMethod) {
        this.javaMethod = javaMethod;
    }

    public Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Parameter> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(String name, String description) {
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap<String, Parameter>();
        }
        this.parameters.put(name, new Parameter(String.class, description));
    }

    public void addParameter(String name, Class<?> type, String description) {
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap<String, Parameter>();
        }
        this.parameters.put(name, new Parameter(type, description));
    }

    public boolean hasParameters() {
        return this.parameters != null && !this.parameters.isEmpty();
    }

    public RuntimeValue getRuntimeValue() {
        return this.runtimeValue;
    }

    public void setRuntimeValue(RuntimeValue runtimeValue) {
        this.runtimeValue = runtimeValue;
    }

    public boolean isIsExplicitlyBlocking() {
        return this.isExplicitlyBlocking;
    }

    public void setIsExplicitlyBlocking(boolean isExplicitlyBlocking) {
        this.isExplicitlyBlocking = isExplicitlyBlocking;
    }

    public boolean isIsExplicitlyNonBlocking() {
        return this.isExplicitlyNonBlocking;
    }

    public void setIsExplicitlyNonBlocking(boolean isExplicitlyNonBlocking) {
        this.isExplicitlyNonBlocking = isExplicitlyNonBlocking;
    }

    public boolean isReturningMulti() {
        return this.javaMethod.getReturnType().getName().equals(Multi.class.getName());
    }

    public boolean isReturningUni() {
        return this.javaMethod.getReturnType().getName().equals(Uni.class.getName());
    }

    public boolean isReturningCompletionStage() {
        return this.javaMethod.getReturnType().getName().equals(CompletionStage.class.getName());
    }

    public boolean isReturningCompletableFuture() {
        return this.javaMethod.getReturnType().getName().equals(CompletableFuture.class.getName());
    }

    public static class Parameter {
        private Class<?> type;
        private String description;

        public Parameter() {
        }

        public Parameter(Class<?> type, String description) {
            this.type = type;
            this.description = description;
        }

        public Class<?> getType() {
            return this.type;
        }

        public void setType(Class<?> type) {
            this.type = type;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }
}

