/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.config;

import io.quarkus.registry.config.ConfigSource;
import io.quarkus.registry.config.RegistriesConfig;
import io.quarkus.registry.config.RegistriesConfigImpl;
import io.quarkus.registry.config.RegistriesConfigMapperHelper;
import io.quarkus.registry.config.RegistryConfig;
import io.quarkus.registry.config.RegistryConfigImpl;
import io.quarkus.registry.config.RegistryMavenConfig;
import io.quarkus.registry.config.RegistryMavenRepoConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;

public class RegistriesConfigLocator {
    public static final String CONFIG_RELATIVE_PATH = ".quarkus/config.yaml";
    public static final String CONFIG_FILE_PATH_PROPERTY = "quarkus.tools.config";
    static final String QUARKUS_REGISTRIES = "QUARKUS_REGISTRIES";
    static final String QUARKUS_REGISTRY_ENV_VAR_PREFIX = "QUARKUS_REGISTRY_";

    public static RegistriesConfig resolveConfig() {
        RegistriesConfig config = RegistriesConfigLocator.initFromEnvironmentOrNull(System.getenv());
        if (config != null) {
            return config;
        }
        Path configYaml = RegistriesConfigLocator.locateConfigYaml();
        if (configYaml == null) {
            return new RegistriesConfigImpl.Builder().build().setSource(ConfigSource.DEFAULT);
        }
        return RegistriesConfigLocator.load(configYaml);
    }

    public static RegistriesConfig load(Path configYaml) {
        try {
            RegistriesConfigImpl.Builder config = RegistriesConfigMapperHelper.deserialize(configYaml, RegistriesConfigImpl.Builder.class);
            if (config == null) {
                config = new RegistriesConfigImpl.Builder();
            }
            return config.setSource(new ConfigSource.FileConfigSource(configYaml)).build();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to parse config file " + String.valueOf(configYaml), e);
        }
    }

    public static RegistriesConfig load(InputStream configYaml) {
        try {
            RegistriesConfigImpl.Builder instance = RegistriesConfigMapperHelper.deserializeYaml(configYaml, RegistriesConfigImpl.Builder.class);
            return instance == null ? null : instance.build();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to parse config file " + String.valueOf(configYaml), e);
        }
    }

    public static RegistriesConfig load(Reader configYaml) {
        try {
            RegistriesConfigImpl.Builder instance = RegistriesConfigMapperHelper.deserializeYaml(configYaml, RegistriesConfigImpl.Builder.class);
            return instance == null ? null : instance.build();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to parse config file " + String.valueOf(configYaml), e);
        }
    }

    public static Path locateConfigYaml() {
        return RegistriesConfigLocator.locateConfigYaml(null);
    }

    public static Path locateConfigYaml(Path configYaml) {
        if (configYaml == null) {
            String prop = System.getProperty(CONFIG_FILE_PATH_PROPERTY);
            if (prop != null) {
                configYaml = Paths.get(prop, new String[0]);
                if (!Files.exists(configYaml, new LinkOption[0])) {
                    throw new IllegalStateException("Quarkus extension registry configuration file " + String.valueOf(configYaml) + " specified by the system property quarkus.tools.config does not exist");
                }
                return configYaml;
            }
            configYaml = Paths.get("", new String[0]).normalize().toAbsolutePath().resolve(CONFIG_RELATIVE_PATH);
            if (Files.exists(configYaml, new LinkOption[0])) {
                return configYaml;
            }
            configYaml = RegistriesConfigLocator.getDefaultConfigYamlLocation();
        }
        return Files.exists(configYaml, new LinkOption[0]) ? configYaml : null;
    }

    static Path getDefaultConfigYamlLocation() {
        return Paths.get(System.getProperty("user.home"), new String[0]).resolve(CONFIG_RELATIVE_PATH);
    }

    public static RegistryConfig getDefaultRegistry() {
        return RegistryConfigImpl.getDefaultRegistry();
    }

    static RegistriesConfig initFromEnvironmentOrNull(Map<String, String> map) {
        String envRegistries = map.get(QUARKUS_REGISTRIES);
        if (envRegistries == null || envRegistries.isBlank()) {
            return null;
        }
        RegistriesConfigImpl.Builder registriesConfigBuilder = new RegistriesConfigImpl.Builder();
        for (String registryId : envRegistries.split(",")) {
            RegistryConfigImpl.Builder builder = new RegistryConfigImpl.Builder().setId(registryId);
            String envvarPrefix = RegistriesConfigLocator.getEnvVarPrefix(registryId);
            for (Map.Entry<String, String> var : map.entrySet()) {
                if (!var.getKey().startsWith(envvarPrefix)) continue;
                if (RegistriesConfigLocator.isEnvVarOption(var.getKey(), envvarPrefix, "UPDATE_POLICY")) {
                    builder.setUpdatePolicy(var.getValue());
                    continue;
                }
                if (RegistriesConfigLocator.isEnvVarOption(var.getKey(), envvarPrefix, "REPO_URL")) {
                    builder.setMaven(RegistryMavenConfig.builder().setRepository(RegistryMavenRepoConfig.builder().setUrl(var.getValue()).build()).build());
                    continue;
                }
                if (!RegistriesConfigLocator.isEnvVarOption(var.getKey(), envvarPrefix, "OFFERING")) continue;
                builder.setExtra(Map.of("offering", var.getValue()));
            }
            registriesConfigBuilder.addRegistry(builder.build());
        }
        return registriesConfigBuilder.build().setSource(ConfigSource.ENV);
    }

    private static boolean isEnvVarOption(String varName, String registryPrefix, String optionName) {
        return varName.regionMatches(registryPrefix.length(), optionName, 0, optionName.length());
    }

    private static String getEnvVarPrefix(String registryId) {
        StringBuilder buf = new StringBuilder(QUARKUS_REGISTRY_ENV_VAR_PREFIX);
        for (int i = 0; i < registryId.length(); ++i) {
            char c = registryId.charAt(i);
            if (c == '.') {
                buf.append('_');
                continue;
            }
            buf.append(Character.toUpperCase(c));
        }
        return buf.append('_').toString();
    }
}

