/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.platform.catalog.compatibility;

import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.platform.catalog.compatibility.ExtensionCompatibility;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ExtensionCatalogCompatibility {
    private final List<ExtensionCompatibility> compatibilityInfo;

    public static ExtensionCatalogCompatibility forCatalog(ExtensionCatalog catalog) {
        return ExtensionCatalogCompatibility.forExtensions(catalog.getExtensions(), catalog);
    }

    public static ExtensionCatalogCompatibility forExtensions(Iterable<Extension> extensions, ExtensionCatalog catalog) {
        HashMap<ArtifactKey, Extension> catalogExtMap = new HashMap<ArtifactKey, Extension>(catalog.getExtensions().size());
        for (Extension e : catalog.getExtensions()) {
            catalogExtMap.put(e.getArtifact().getKey(), e);
        }
        HashMap<ArtifactKey, Map<String, CapabilityInfo>> capInfoMap = new HashMap<ArtifactKey, Map<String, CapabilityInfo>>();
        ArrayList<ExtensionCapabilityInfo> branches = new ArrayList<ExtensionCapabilityInfo>();
        for (Extension e : extensions) {
            List<ArtifactKey> depKeys = ExtensionCatalogCompatibility.extensionDependencies(e.getMetadata());
            Map<String, CapabilityInfo> allCaps = Collections.emptyMap();
            Map<String, CapabilityInfo> extCaps = ExtensionCatalogCompatibility.providedCapabilities(e, capInfoMap);
            if (!extCaps.isEmpty()) {
                allCaps = new HashMap<String, CapabilityInfo>(extCaps);
            }
            for (ArtifactKey key : depKeys) {
                Extension dep = (Extension)catalogExtMap.get(key);
                if (dep == null || (extCaps = ExtensionCatalogCompatibility.providedCapabilities(dep, capInfoMap)).isEmpty()) continue;
                if (allCaps.isEmpty()) {
                    allCaps = new HashMap<String, CapabilityInfo>(extCaps);
                    continue;
                }
                allCaps.putAll(extCaps);
            }
            if (allCaps.isEmpty()) continue;
            branches.add(new ExtensionCapabilityInfo(e, allCaps));
        }
        List<ExtensionCompatibility> conflictingExtensions = Collections.emptyList();
        for (ExtensionCapabilityInfo extCapInfo : branches) {
            HashMap<ArtifactKey, Extension> conflicts = null;
            for (ExtensionCapabilityInfo otherExtCapInfo : branches) {
                if (otherExtCapInfo == extCapInfo || !extCapInfo.isInConflictWith(otherExtCapInfo)) continue;
                if (conflicts == null) {
                    conflicts = new HashMap<ArtifactKey, Extension>();
                }
                conflicts.put(otherExtCapInfo.e.getArtifact().getKey(), otherExtCapInfo.e);
            }
            if (conflicts == null) continue;
            if (conflictingExtensions.isEmpty()) {
                conflictingExtensions = new ArrayList<ExtensionCompatibility>();
            }
            conflictingExtensions.add(new ExtensionCompatibility(extCapInfo.e, conflicts));
        }
        return new ExtensionCatalogCompatibility(conflictingExtensions);
    }

    private ExtensionCatalogCompatibility(List<ExtensionCompatibility> conflictingExtensions) {
        this.compatibilityInfo = Objects.requireNonNull(conflictingExtensions);
    }

    public Collection<ExtensionCompatibility> getExtensionCompatibility() {
        return this.compatibilityInfo;
    }

    public boolean isEmpty() {
        return this.compatibilityInfo.isEmpty();
    }

    private static Map<String, CapabilityInfo> providedCapabilities(Extension e, Map<ArtifactKey, Map<String, CapabilityInfo>> capInfoMap) {
        Map<String, CapabilityInfo> map = capInfoMap.get(e.getArtifact().getKey());
        if (map == null) {
            List<String> providedNames = ExtensionCatalogCompatibility.providedCapabilities(e);
            if (providedNames.isEmpty()) {
                map = Collections.emptyMap();
            } else {
                map = new HashMap<String, CapabilityInfo>(providedNames.size());
                for (String name : providedNames) {
                    map.put(name, new CapabilityInfo(name, e));
                }
            }
            capInfoMap.put(e.getArtifact().getKey(), map);
        }
        return map;
    }

    private static List<String> providedCapabilities(Extension e) {
        Map map = e.getMetadata().getOrDefault("capabilities", Collections.emptyMap());
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        List caps = (List)map.get("provides");
        return caps == null ? Collections.emptyList() : caps;
    }

    private static List<ArtifactKey> extensionDependencies(Map<String, Object> metadata) {
        List extDeps = metadata.getOrDefault("extension-dependencies", Collections.emptyList());
        if (extDeps.isEmpty()) {
            return Collections.emptyList();
        }
        return extDeps.stream().map(ArtifactKey::fromString).collect(Collectors.toList());
    }

    private static class ExtensionCapabilityInfo {
        final Extension e;
        final Map<String, CapabilityInfo> caps;

        ExtensionCapabilityInfo(Extension e, Map<String, CapabilityInfo> caps) {
            this.e = e;
            this.caps = caps;
        }

        boolean isInConflictWith(ExtensionCapabilityInfo other) {
            if (other.caps.isEmpty() || this.caps.isEmpty()) {
                return false;
            }
            for (CapabilityInfo otherCap : other.caps.values()) {
                CapabilityInfo provided = this.caps.get(otherCap.name);
                if (provided == null || provided.providerKey().equals(otherCap.providerKey())) continue;
                return true;
            }
            return false;
        }
    }

    private static class CapabilityInfo {
        final String name;
        final Extension provider;

        CapabilityInfo(String name, Extension provider) {
            this.name = Objects.requireNonNull(name);
            this.provider = Objects.requireNonNull(provider);
        }

        ArtifactKey providerKey() {
            return this.provider.getArtifact().getKey();
        }
    }
}

