/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.oidc;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.bean.JavaBeanUtil;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.dev.devservices.DevServicesConfig;
import io.quarkus.devservices.oidc.OidcDevServicesConfig;
import io.quarkus.devservices.oidc.OidcDevServicesConfigBuildItem;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.smallrye.jwt.build.Jwt;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.core.http.HttpServer;
import io.vertx.mutiny.ext.web.Router;
import io.vertx.mutiny.ext.web.RoutingContext;
import io.vertx.mutiny.ext.web.handler.BodyHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.logging.Logger;
import org.jose4j.base64url.Base64Url;

@BuildSteps(onlyIfNot={IsNormal.class}, onlyIf={DevServicesConfig.Enabled.class})
public class OidcDevServicesProcessor {
    private static final Logger LOG = Logger.getLogger(OidcDevServicesProcessor.class);
    private static final String CONFIG_PREFIX = "quarkus.oidc.";
    private static final String OIDC_ENABLED = "quarkus.oidc.enabled";
    private static final String TENANT_ENABLED_CONFIG_KEY = "quarkus.oidc.tenant-enabled";
    private static final String AUTH_SERVER_URL_CONFIG_KEY = "quarkus.oidc.auth-server-url";
    private static final String PROVIDER_CONFIG_KEY = "quarkus.oidc.provider";
    private static final String APPLICATION_TYPE_CONFIG_KEY = "quarkus.oidc.application-type";
    private static final String CLIENT_ID_CONFIG_KEY = "quarkus.oidc.client-id";
    private static final String CLIENT_SECRET_CONFIG_KEY = "quarkus.oidc.credentials.secret";
    private static volatile KeyPair kp;
    private static volatile String kid;
    private static volatile String baseURI;
    private static volatile String clientId;
    private static volatile String clientSecret;
    private static volatile String applicationType;
    private static volatile Map<String, String> configProperties;
    private static volatile Map<String, List<String>> userToDefaultRoles;
    private static volatile Runnable closeDevServiceTask;

    @BuildStep
    DevServicesResultBuildItem startServer(CuratedApplicationShutdownBuildItem closeBuildItem, OidcDevServicesConfig devServicesConfig, DockerStatusBuildItem dockerStatusBuildItem, BuildProducer<OidcDevServicesConfigBuildItem> devServiceConfigProducer) {
        if (OidcDevServicesProcessor.shouldNotStartServer(devServicesConfig, dockerStatusBuildItem)) {
            OidcDevServicesProcessor.closeDevSvcIfNecessary();
            return null;
        }
        userToDefaultRoles = devServicesConfig.roles();
        if (closeDevServiceTask == null) {
            LOG.info((Object)"Starting Dev Services for OIDC");
            final Vertx vertx = Vertx.vertx();
            HttpServerOptions options = new HttpServerOptions();
            options.setPort(0);
            final HttpServer httpServer = vertx.createHttpServer(options);
            Router router = Router.router((Vertx)vertx);
            httpServer.requestHandler((Consumer)router);
            OidcDevServicesProcessor.registerRoutes(router);
            httpServer.listenAndAwait();
            baseURI = "http://localhost:" + httpServer.actualPort();
            closeDevServiceTask = new Runnable(){
                private volatile boolean closed = false;

                @Override
                public void run() {
                    if (this.closed) {
                        return;
                    }
                    this.closed = true;
                    httpServer.getDelegate().close(httpServerResult -> {
                        if (httpServerResult != null && httpServerResult.failed()) {
                            LOG.error((Object)"Failed to close HTTP Server", httpServerResult.cause());
                        }
                        vertx.getDelegate().close(vertxResult -> {
                            if (vertxResult != null && vertxResult.failed()) {
                                LOG.error((Object)"Failed to close Vertx instance", vertxResult.cause());
                            }
                        });
                    });
                }
            };
            closeBuildItem.addCloseTask(OidcDevServicesProcessor::closeDevSvcIfNecessary, true);
            OidcDevServicesProcessor.updateDevSvcConfigProperties();
            LOG.infof("Dev Services for OIDC started on %s", (Object)baseURI);
        } else if (!OidcDevServicesProcessor.getOidcClientId().equals(clientId) || !OidcDevServicesProcessor.getOidcApplicationType().equals(applicationType)) {
            OidcDevServicesProcessor.updateDevSvcConfigProperties();
        }
        devServiceConfigProducer.produce((BuildItem)new OidcDevServicesConfigBuildItem(configProperties));
        return new DevServicesResultBuildItem.RunningDevService("oidc-dev-services", null, () -> {}, configProperties).toBuildItem();
    }

    private static void closeDevSvcIfNecessary() {
        if (closeDevServiceTask != null) {
            closeDevServiceTask.run();
            closeDevServiceTask = null;
        }
    }

    private static boolean shouldNotStartServer(OidcDevServicesConfig devServicesConfig, DockerStatusBuildItem dockerStatusBuildItem) {
        boolean explicitlyDisabled;
        boolean bl = explicitlyDisabled = devServicesConfig.enabled().isPresent() && devServicesConfig.enabled().get() == false;
        if (explicitlyDisabled) {
            LOG.debug((Object)"Not starting Dev Services for OIDC as it has been disabled in the config");
            return true;
        }
        if (!OidcDevServicesProcessor.isOidcEnabled()) {
            LOG.debug((Object)"Not starting Dev Services for OIDC as OIDC extension has been disabled in the config");
            return true;
        }
        if (!OidcDevServicesProcessor.isOidcTenantEnabled()) {
            LOG.debug((Object)"Not starting Dev Services for OIDC as 'quarkus.oidc.tenant.enabled' is false");
            return true;
        }
        if (ConfigUtils.isPropertyPresent((String)AUTH_SERVER_URL_CONFIG_KEY)) {
            LOG.debug((Object)"Not starting Dev Services for OIDC as 'quarkus.oidc.auth-server-url' has been provided");
            return true;
        }
        if (ConfigUtils.isPropertyPresent((String)PROVIDER_CONFIG_KEY)) {
            LOG.debug((Object)"Not starting Dev Services for OIDC as 'quarkus.oidc.provider' has been provided");
            return true;
        }
        if (devServicesConfig.enabled().isEmpty() && dockerStatusBuildItem.isContainerRuntimeAvailable()) {
            LOG.debug((Object)"Not starting Dev Services for OIDC as a container runtime is available and a Keycloak Dev Services will be started");
            return true;
        }
        return false;
    }

    private static void updateDevSvcConfigProperties() {
        clientId = OidcDevServicesProcessor.getOidcClientId();
        clientSecret = OidcDevServicesProcessor.getOidcClientSecret();
        applicationType = OidcDevServicesProcessor.getOidcApplicationType();
        HashMap<String, String> aConfigProperties = new HashMap<String, String>();
        aConfigProperties.put(AUTH_SERVER_URL_CONFIG_KEY, baseURI);
        aConfigProperties.put(APPLICATION_TYPE_CONFIG_KEY, applicationType);
        aConfigProperties.put(CLIENT_ID_CONFIG_KEY, clientId);
        aConfigProperties.put(CLIENT_SECRET_CONFIG_KEY, clientSecret);
        configProperties = Map.copyOf(aConfigProperties);
    }

    private static void registerRoutes(Router router) {
        KeyPairGenerator kpg;
        BodyHandler bodyHandler = BodyHandler.create();
        router.get("/").handler(OidcDevServicesProcessor::mainRoute);
        router.get("/.well-known/openid-configuration").handler(OidcDevServicesProcessor::configuration);
        router.get("/authorize").handler(OidcDevServicesProcessor::authorize);
        router.post("/login").handler((Consumer)bodyHandler).handler(OidcDevServicesProcessor::login);
        router.post("/token").handler((Consumer)bodyHandler).handler(OidcDevServicesProcessor::token);
        router.get("/keys").handler(OidcDevServicesProcessor::getKeys);
        router.get("/logout").handler(OidcDevServicesProcessor::logout);
        router.get("/userinfo").handler(OidcDevServicesProcessor::userInfo);
        try {
            kpg = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        kpg.initialize(2048);
        kp = kpg.generateKeyPair();
        kid = OidcDevServicesProcessor.createKeyId();
    }

    private static List<String> getUsers() {
        if (userToDefaultRoles.isEmpty()) {
            return Arrays.asList("alice", "bob");
        }
        ArrayList<String> ret = new ArrayList<String>(userToDefaultRoles.keySet());
        Collections.sort(ret);
        return ret;
    }

    private static List<String> getUserRoles(String user) {
        List<String> roles = userToDefaultRoles.get(user);
        return roles == null ? ("alice".equals(user) ? List.of("admin", "user") : List.of("user")) : roles;
    }

    private static boolean isOidcEnabled() {
        return (Boolean)ConfigProvider.getConfig().getValue(OIDC_ENABLED, Boolean.class);
    }

    private static boolean isOidcTenantEnabled() {
        return ConfigProvider.getConfig().getOptionalValue(TENANT_ENABLED_CONFIG_KEY, Boolean.class).orElse(true);
    }

    private static String getOidcApplicationType() {
        return ConfigProvider.getConfig().getOptionalValue(APPLICATION_TYPE_CONFIG_KEY, String.class).orElse("service");
    }

    private static String getOidcClientId() {
        return ConfigProvider.getConfig().getOptionalValue(CLIENT_ID_CONFIG_KEY, String.class).orElse("quarkus-app");
    }

    private static String getOidcClientSecret() {
        return ConfigProvider.getConfig().getOptionalValue(CLIENT_SECRET_CONFIG_KEY, String.class).orElseGet(() -> UUID.randomUUID().toString());
    }

    private static void mainRoute(RoutingContext rc) {
        rc.response().endAndForget("OIDC server up and running");
    }

    private static void configuration(RoutingContext rc) {
        String data = "{\n   \"token_endpoint\":\"%1$s/token\",\n   \"token_endpoint_auth_methods_supported\":[\n      \"client_secret_post\",\n      \"private_key_jwt\",\n      \"client_secret_basic\"\n   ],\n   \"jwks_uri\":\"%1$s/keys\",\n   \"response_modes_supported\":[\n      \"query\"\n   ],\n   \"subject_types_supported\":[\n      \"pairwise\"\n   ],\n   \"id_token_signing_alg_values_supported\":[\n      \"RS256\"\n   ],\n   \"response_types_supported\":[\n      \"code\",\n      \"id_token\",\n      \"code id_token\",\n      \"id_token token\",\n      \"code id_token token\"\n   ],\n   \"scopes_supported\":[\n      \"openid\",\n      \"profile\",\n      \"email\",\n      \"offline_access\"\n   ],\n   \"issuer\":\"%1$s\",\n   \"request_uri_parameter_supported\":false,\n   \"userinfo_endpoint\":\"%1$s/userinfo\",\n   \"authorization_endpoint\":\"%1$s/authorize\",\n   \"device_authorization_endpoint\":\"%1$s/devicecode\",\n   \"http_logout_supported\":true,\n   \"frontchannel_logout_supported\":true,\n   \"end_session_endpoint\":\"%1$s/logout\",\n   \"claims_supported\":[\n      \"sub\",\n      \"iss\",\n      \"aud\",\n      \"exp\",\n      \"iat\",\n      \"auth_time\",\n      \"acr\",\n      \"nonce\",\n      \"preferred_username\",\n      \"name\",\n      \"tid\",\n      \"ver\",\n      \"at_hash\",\n      \"c_hash\",\n      \"email\"\n   ]\n}\n".formatted(baseURI);
        rc.response().putHeader("Content-Type", "application/json");
        rc.endAndForget(data);
    }

    private static void authorize(RoutingContext rc) {
        URI redirect;
        String response_type = rc.request().params().get("response_type");
        String clientId = rc.request().params().get("client_id");
        String scope = rc.request().params().get("scope");
        String state = rc.request().params().get("state");
        String redirect_uri = rc.request().params().get("redirect_uri");
        try {
            redirect = new URI(redirect_uri + "?state=" + state);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        StringBuilder predefinedUsers = new StringBuilder();
        for (String predefinedUser : OidcDevServicesProcessor.getUsers()) {
            predefinedUsers.append("   <button name='predefined-" + predefinedUser + "' class='link' type='submit' value='").append(predefinedUser).append("' title='Log in as ").append(predefinedUser).append(" with roles: ").append(String.join((CharSequence)",", OidcDevServicesProcessor.getUserRoles(predefinedUser))).append("'>").append(predefinedUser).append("</button>\n");
        }
        rc.response().endAndForget("<html>\n <head>\n  <title>Login</title>\n  <style>\n        body {\n        display: flex;\n        flex-direction: column;\n        background-color: hsla(210, 10%, 23%, 1.0);\n        color: hsla(214, 96%, 96%, 0.9);\n        height: 100vh;\n        align-items: center;\n        justify-content: center;\n        margin: 0px;\n        font-family: -apple-system, BlinkMacSystemFont, 'Roboto', 'Segoe UI', Helvetica, Arial, sans-serif, 'Apple Color Emoji', 'Segoe UI Emoji', 'Segoe UI Symbol';\n      }\n      .card {\n        display: flex;\n        flex-direction: column;\n        justify-content: space-between;\n        border: 1px solid hsla(214, 60%, 80%, 0.14);\n        border-radius: 4px;\n        width: 400px;\n        filter: brightness(90%);\n      }\n      .card-header {\n        font-size: 1.125rem;\n        line-height: 1;\n        height: 25px;\n        display: flex;\n        flex-direction: row;\n        justify-content: space-between;\n        align-items: center;\n        padding: 10px 10px;\n        background-color: hsla(214, 65%, 85%, 0.06);\n        border-bottom: 1px solid hsla(214, 60%, 80%, 0.14);\n      }\n      .card-body {\n        line-height: 1;\n        display: flex;\n        flex-direction: column;\n        justify-content: space-between;\n        padding: 10px 10px;\n        gap: 10px;\n      }\n      .card:hover {\n        box-shadow: 0 4px 8px 0 rgba(0,0,0,0.2);\n      }\n      .predefined-form {\n        display: flex;\n        flex-direction: column;\n        align-items: flex-start;\n        gap: 10px;\n      }\n      .link {\n        background: none!important;\n        border: none;\n        color: hsla(214, 96%, 96%, 0.9);\n        padding: 0!important;\n        text-decoration: none;\n        cursor: pointer;\n        font-size: large;\n      }\n      .link:hover {\n        filter: brightness(90%);\n      }\n      .custom-link{\n        display: flex;\n        font-size: large;\n        padding-top: 4px;\n        cursor: pointer;\n      }\n      .custom-form {\n        display: flex;\n        flex-direction: column;\n        gap: 5px;\n        padding-top: 5px;\n      }\n      .custom-button {\n        background: hsla(145, 65%, 42%, 0.5);\n        border: unset;\n        color: hsla(214, 96%, 96%, 0.9);\n        font-size: large;\n        cursor: pointer;\n      }\n      .custom-button:hover {\n        filter: brightness(90%);\n      }\n  </style>\n </head>\n <body>\n  <div class='card'>\n   <div class='card-header'>\n    <div>Login</div>\n   </div>\n   <div class='card-body'>\n    <form class='predefined-form' action='/login' method='post'>\n" + "    <input type='hidden' name='redirect_uri' value='%1$s'>\n    <input type='hidden' name='response_type' value='%3$s'>\n    <input type='hidden' name='client_id' value='%4$s'>\n    <input type='hidden' name='scope' value='%5$s'>\n        %2$s\n    </form>\n    <details>\n     <summary class='custom-link'>Custom user</summary>\n     <form class='custom-form' action='/login' method='post'>\n      <input type='hidden' name='redirect_uri' value='%1$s'>\n      <input type='hidden' name='response_type' value='%3$s'>\n      <input type='hidden' name='client_id' value='%4$s'>\n      <input type='hidden' name='scope' value='%5$s'>\n      <input type='text' name='name' placeholder='Name'><br/>\n      <input type='text' name='roles' placeholder='Roles (comma-separated)'><br/>\n      <button class='custom-button' type='submit' name='login'>Login</button>\n     </form>\n    </details>\n   </div>\n  </div>\n </body>\n</html>\n".formatted(redirect.toASCIIString(), predefinedUsers, response_type, clientId, scope));
    }

    private static void login(RoutingContext rc) {
        String redirect_uri = rc.request().params().get("redirect_uri");
        String predefined = null;
        for (Map.Entry param : rc.request().params()) {
            if (!((String)param.getKey()).startsWith("predefined")) continue;
            predefined = (String)param.getValue();
            break;
        }
        String name = rc.request().params().get("name");
        String roles = rc.request().params().get("roles");
        String scope = rc.request().params().get("scope");
        String clientId = rc.request().params().get("client_id");
        String responseType = rc.request().params().get("response_type");
        if (predefined != null) {
            name = predefined;
            roles = String.join((CharSequence)",", OidcDevServicesProcessor.getUserRoles(name));
        }
        if (name == null || name.isBlank()) {
            name = "user";
        }
        if (responseType == null || responseType.isEmpty()) {
            rc.response().setStatusCode(500).endAndForget("Illegal state - the 'response_type' parameter is required");
            return;
        }
        StringBuilder queryParams = new StringBuilder();
        if (responseType.contains("code")) {
            String code = new UserAndRoles(name, roles).encode();
            queryParams.append("&code=").append(code);
        }
        if (responseType.contains("idtoken")) {
            String idToken = OidcDevServicesProcessor.createIdToken(name, OidcDevServicesProcessor.getUserRolesSet(roles), clientId);
            queryParams.append("&id_token=").append(idToken);
        }
        if (responseType.contains(" token")) {
            String accessToken = OidcDevServicesProcessor.createAccessToken(name, OidcDevServicesProcessor.getUserRolesSet(roles), OidcDevServicesProcessor.getScopeAsSet(scope));
            queryParams.append("&access_token=").append(accessToken);
        }
        rc.response().putHeader("Location", redirect_uri + String.valueOf(queryParams)).setStatusCode(302).endAndForget();
    }

    private static void token(RoutingContext rc) {
        String grantType;
        switch (grantType = rc.request().formAttributes().get("grant_type")) {
            case "authorization_code": {
                OidcDevServicesProcessor.authorizationCodeFlowTokenEndpoint(rc);
                break;
            }
            case "refresh_token": {
                OidcDevServicesProcessor.refreshTokenEndpoint(rc);
                break;
            }
            case "client_credentials": {
                OidcDevServicesProcessor.clientCredentialsTokenEndpoint(rc);
                break;
            }
            case "password": {
                OidcDevServicesProcessor.passwordTokenEndpoint(rc);
                break;
            }
            default: {
                rc.response().setStatusCode(400).putHeader("Content-Type", "application/json").putHeader("Cache-Control", "no-store").endAndForget("Unsupported grant type: " + grantType);
            }
        }
    }

    private static void passwordTokenEndpoint(RoutingContext rc) {
        String scope = rc.request().formAttributes().get("scope");
        String clientId = rc.request().formAttributes().get("client_id");
        String username = rc.request().formAttributes().get("username");
        if (clientId == null || clientId.isEmpty()) {
            LOG.warn((Object)"Client id is not present, denying token request");
            OidcDevServicesProcessor.invalidTokenResponse(rc);
            return;
        }
        if (username == null || username.isEmpty()) {
            LOG.warn((Object)"Username is not present, denying token request");
            OidcDevServicesProcessor.invalidTokenResponse(rc);
            return;
        }
        List<String> userRoles = OidcDevServicesProcessor.getUserRoles(username);
        String accessToken = OidcDevServicesProcessor.createAccessToken(username, new HashSet<String>(userRoles), OidcDevServicesProcessor.getScopeAsSet(scope));
        String refreshToken = new UserAndRoles(username, String.join((CharSequence)",", userRoles)).encode();
        String data = "{\n  \"access_token\":\"%s\",\n  \"token_type\":\"Bearer\",\n  \"expires_in\":3600,\n  \"refresh_token\":\"%s\"\n}\n".formatted(accessToken, refreshToken);
        rc.response().putHeader("Content-Type", "application/json").putHeader("Cache-Control", "no-store").endAndForget(data);
    }

    private static void clientCredentialsTokenEndpoint(RoutingContext rc) {
        String scope = rc.request().formAttributes().get("scope");
        String clientId = rc.request().formAttributes().get("client_id");
        if (clientId == null || clientId.isEmpty()) {
            LOG.warn((Object)"Client id is not present, denying token request");
            OidcDevServicesProcessor.invalidTokenResponse(rc);
            return;
        }
        String accessToken = OidcDevServicesProcessor.createAccessToken(clientId, new HashSet<String>(OidcDevServicesProcessor.getUserRoles(clientId)), OidcDevServicesProcessor.getScopeAsSet(scope));
        String data = "{\n      \"access_token\": \"%s\",\n      \"token_type\": \"Bearer\",\n      \"expires_in\": 3600\n}\n".formatted(accessToken);
        rc.response().putHeader("Content-Type", "application/json").putHeader("Cache-Control", "no-store").endAndForget(data);
    }

    private static void refreshTokenEndpoint(RoutingContext rc) {
        String clientId = rc.request().formAttributes().get("client_id");
        String clientSecret = rc.request().formAttributes().get("client_secret");
        String scope = rc.request().formAttributes().get("scope");
        if (clientId == null || clientId.isEmpty()) {
            LOG.warn((Object)"Client id is not present, denying token request");
            OidcDevServicesProcessor.invalidTokenResponse(rc);
            return;
        }
        if (clientSecret == null || clientSecret.isEmpty()) {
            LOG.warn((Object)"Client secret is not present, denying token request");
            OidcDevServicesProcessor.invalidTokenResponse(rc);
            return;
        }
        String refreshToken = rc.request().formAttributes().get("refresh_token");
        UserAndRoles userAndRoles = OidcDevServicesProcessor.decode(refreshToken);
        if (userAndRoles == null) {
            LOG.warnf("Received invalid refresh token, denying token refresh: %s", (Object)refreshToken);
            OidcDevServicesProcessor.invalidTokenResponse(rc);
            return;
        }
        String accessToken = OidcDevServicesProcessor.createAccessToken(userAndRoles.user, userAndRoles.getRolesAsSet(), OidcDevServicesProcessor.getScopeAsSet(scope));
        String data = "{\n   \"access_token\": \"%s\",\n   \"token_type\": \"Bearer\",\n   \"refresh_token\": \"%s\",\n   \"expires_in\": 3600\n}\n".formatted(accessToken, refreshToken);
        rc.response().putHeader("Content-Type", "application/json").putHeader("Cache-Control", "no-store").endAndForget(data);
    }

    private static void authorizationCodeFlowTokenEndpoint(RoutingContext rc) {
        String clientId = rc.request().formAttributes().get("client_id");
        if (clientId == null || clientId.isEmpty()) {
            clientId = OidcDevServicesProcessor.clientId;
        }
        String scope = rc.request().formAttributes().get("scope");
        String code = rc.request().formAttributes().get("code");
        UserAndRoles userAndRoles = OidcDevServicesProcessor.decode(code);
        if (userAndRoles == null) {
            OidcDevServicesProcessor.invalidTokenResponse(rc);
            return;
        }
        String accessToken = OidcDevServicesProcessor.createAccessToken(userAndRoles.user, userAndRoles.getRolesAsSet(), OidcDevServicesProcessor.getScopeAsSet(scope));
        String idToken = OidcDevServicesProcessor.createIdToken(userAndRoles.user, userAndRoles.getRolesAsSet(), clientId);
        String data = "{\n \"token_type\":\"Bearer\",\n \"scope\":\"openid email profile\",\n \"expires_in\":3600,\n \"ext_expires_in\":3600,\n \"access_token\":\"%s\",\n \"id_token\":\"%s\",\n \"refresh_token\": \"%s\"\n }\n".formatted(accessToken, idToken, userAndRoles.encode());
        rc.response().putHeader("Content-Type", "application/json").putHeader("Cache-Control", "no-store").endAndForget(data);
    }

    private static void invalidTokenResponse(RoutingContext rc) {
        rc.response().setStatusCode(400).putHeader("Content-Type", "application/json").putHeader("Cache-Control", "no-store").endAndForget("{\n   \"error\": \"invalid_request\"\n}\n");
    }

    private static String createIdToken(String user, Set<String> roles, String clientId) {
        return Jwt.claims().expiresIn(Duration.ofDays(1L)).issuedAt(Instant.now()).issuer(baseURI).audience(clientId).subject(user).upn(user).claim("name", (Object)OidcDevServicesProcessor.buildNameClaimValue(user)).claim(Claims.preferred_username, (Object)OidcDevServicesProcessor.buildEmailClaimValue(user)).claim(Claims.email, (Object)OidcDevServicesProcessor.buildEmailClaimValue(user)).groups(roles).jws().keyId(kid).sign(kp.getPrivate());
    }

    private static String createAccessToken(String user, Set<String> roles, Set<String> scope) {
        return Jwt.claims().expiresIn(Duration.ofDays(1L)).issuedAt(Instant.now()).issuer(baseURI).subject(user).scope(scope).upn(user).claim("name", (Object)OidcDevServicesProcessor.buildNameClaimValue(user)).claim(Claims.preferred_username, (Object)OidcDevServicesProcessor.buildEmailClaimValue(user)).claim(Claims.email, (Object)OidcDevServicesProcessor.buildEmailClaimValue(user)).groups(roles).jws().keyId(kid).sign(kp.getPrivate());
    }

    private static String buildNameClaimValue(String user) {
        if (user.contains("@")) {
            return JavaBeanUtil.capitalize((String)user.split("@")[0]);
        }
        return JavaBeanUtil.capitalize((String)user);
    }

    private static String buildEmailClaimValue(String user) {
        if (user.contains("@")) {
            return user;
        }
        return user + "@example.com";
    }

    private static void getKeys(RoutingContext rc) {
        RSAPublicKey pub = (RSAPublicKey)kp.getPublic();
        String modulus = Base64.getUrlEncoder().encodeToString(pub.getModulus().toByteArray());
        String exponent = Base64.getUrlEncoder().encodeToString(pub.getPublicExponent().toByteArray());
        String data = "{\n  \"keys\": [\n    {\n      \"alg\": \"RS256\",\n      \"kty\": \"RSA\",\n      \"n\": \"%s\",\n      \"use\": \"sig\",\n      \"kid\": \"%s\",\n      \"issuer\": \"%s\",\n      \"e\": \"%s\"\n    }\n  ]\n}\n".formatted(modulus, kid, baseURI, exponent);
        rc.response().putHeader("Content-Type", "application/json").endAndForget(data);
    }

    private static void logout(RoutingContext rc) {
        String redirect_uri = rc.request().params().get("post_logout_redirect_uri");
        rc.response().putHeader("Location", redirect_uri).setStatusCode(302).endAndForget();
    }

    private static void userInfo(RoutingContext rc) {
        String token;
        JsonObject claims;
        String authorization = rc.request().getHeader("Authorization");
        if (authorization != null && authorization.startsWith("Bearer ") && (claims = OidcDevServicesProcessor.decodeJwtContent(token = authorization.substring("Bearer ".length()))) != null && claims.containsKey(Claims.preferred_username.name())) {
            String data = "{\n    \"preferred_username\": \"%1$s\",\n    \"sub\": \"%2$s\",\n    \"name\": \"%3$s\",\n    \"family_name\": \"%3$s\",\n    \"given_name\": \"%3$s\",\n    \"email\": \"%4$s\"\n}\n".formatted(claims.getString(Claims.preferred_username.name()), claims.getString(Claims.sub.name()), claims.getString("name"), claims.getString(Claims.email.name()));
            rc.response().putHeader("Content-Type", "application/json").endAndForget(data);
            return;
        }
        rc.response().setStatusCode(401).endAndForget("WWW-Authenticate: Bearer error=\"invalid_token\"");
    }

    private static UserAndRoles decode(String encodedContent) {
        if (encodedContent != null && !encodedContent.isEmpty()) {
            String decodedCode = new String(Base64.getUrlDecoder().decode(encodedContent), StandardCharsets.UTF_8);
            int separator = decodedCode.indexOf(124);
            if (separator != -1) {
                String user = decodedCode.substring(0, separator);
                String roles = decodedCode.substring(separator + 1);
                if (roles.isBlank()) {
                    roles = String.join((CharSequence)",", OidcDevServicesProcessor.getUserRoles(user));
                }
                return new UserAndRoles(user, roles);
            }
            if (OidcDevServicesProcessor.getUsers().contains(decodedCode)) {
                String roles = String.join((CharSequence)",", OidcDevServicesProcessor.getUserRoles(decodedCode));
                return new UserAndRoles(decodedCode, roles);
            }
        }
        return null;
    }

    private static JsonObject decodeJwtContent(String jwt) {
        String encodedContent = OidcDevServicesProcessor.getJwtContentPart(jwt);
        if (encodedContent == null) {
            return null;
        }
        return OidcDevServicesProcessor.decodeAsJsonObject(encodedContent);
    }

    private static String getJwtContentPart(String jwt) {
        StringTokenizer tokens = new StringTokenizer(jwt, ".");
        tokens.nextToken();
        if (!tokens.hasMoreTokens()) {
            return null;
        }
        String encodedContent = tokens.nextToken();
        if (tokens.countTokens() != 1) {
            return null;
        }
        return encodedContent;
    }

    private static String base64UrlDecode(String encodedContent) {
        return new String(Base64.getUrlDecoder().decode(encodedContent), StandardCharsets.UTF_8);
    }

    private static JsonObject decodeAsJsonObject(String encodedContent) {
        try {
            return new JsonObject(OidcDevServicesProcessor.base64UrlDecode(encodedContent));
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    private static Set<String> getUserRolesSet(String roles) {
        if (roles == null || roles.isEmpty()) {
            return Set.of();
        }
        return Arrays.stream(roles.split(",")).map(String::trim).collect(Collectors.toSet());
    }

    private static Set<String> getScopeAsSet(String scope) {
        if (scope == null || scope.isEmpty()) {
            return Set.of();
        }
        return Arrays.stream(scope.split(" ")).collect(Collectors.toSet());
    }

    private static String createKeyId() {
        try {
            return Base64Url.encode((byte[])MessageDigest.getInstance("SHA-256").digest(kp.getPrivate().getEncoded()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to generate key id", e);
        }
    }

    private record UserAndRoles(String user, String roles) {
        private String encode() {
            return Base64.getUrlEncoder().encodeToString((this.user + "|" + this.roles).getBytes(StandardCharsets.UTF_8));
        }

        private Set<String> getRolesAsSet() {
            if (this.roles == null || this.roles.isEmpty()) {
                return Set.of();
            }
            return new HashSet<String>(Arrays.asList(this.roles.split("[,\\s]+")));
        }
    }
}

