/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.keycloak;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevServicesSupportedByLaunchMode;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesComposeProjectBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.DevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ComposeLocator;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerAddress;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.devservices.keycloak.KeycloakAdminPageBuildItem;
import io.quarkus.devservices.keycloak.KeycloakDevServicesConfig;
import io.quarkus.devservices.keycloak.KeycloakDevServicesConfigBuildItem;
import io.quarkus.devservices.keycloak.KeycloakDevServicesConfigurator;
import io.quarkus.devservices.keycloak.KeycloakDevServicesRequiredBuildItem;
import io.quarkus.devservices.keycloak.KeycloakDevServicesUtils;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.ExternalPageBuilder;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.MemorySize;
import io.smallrye.mutiny.TimeoutException;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.RolesRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.util.JsonSerialization;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

@BuildSteps(onlyIf={IsDevServicesSupportedByLaunchMode.class, DevServicesConfig.Enabled.class})
public class KeycloakDevServicesProcessor {
    private static final Logger LOG = Logger.getLogger(KeycloakDevServicesProcessor.class);
    private static final String CONFIG_PREFIX = "quarkus.oidc.";
    private static final String CLIENT_AUTH_SERVER_URL_CONFIG_KEY = "client.quarkus.oidc.auth-server-url";
    private static final String CLIENT_ID_CONFIG_KEY = "quarkus.oidc.client-id";
    private static final String CLIENT_SECRET_CONFIG_KEY = "quarkus.oidc.credentials.secret";
    static final String KEYCLOAK_URL_KEY = "keycloak.url";
    private static final String KEYCLOAK_CONTAINER_NAME = "keycloak";
    private static final int KEYCLOAK_PORT = 8080;
    private static final int KEYCLOAK_HTTPS_PORT = 8443;
    private static final String KEYCLOAK_LEGACY_IMAGE_VERSION_PART = "-legacy";
    private static final String KEYCLOAK_ADMIN_USER = "admin";
    private static final String KEYCLOAK_ADMIN_PASSWORD = "admin";
    private static final String KEYCLOAK_WILDFLY_FRONTEND_URL = "KEYCLOAK_FRONTEND_URL";
    private static final String KEYCLOAK_WILDFLY_USER_PROP = "KEYCLOAK_USER";
    private static final String KEYCLOAK_WILDFLY_PASSWORD_PROP = "KEYCLOAK_PASSWORD";
    private static final String KEYCLOAK_WILDFLY_DB_VENDOR = "H2";
    private static final String KEYCLOAK_WILDFLY_VENDOR_PROP = "DB_VENDOR";
    private static final String KEYCLOAK_QUARKUS_HOSTNAME = "KC_HOSTNAME";
    private static final String KEYCLOAK_QUARKUS_ADMIN_PROP = "KC_BOOTSTRAP_ADMIN_USERNAME";
    private static final String KEYCLOAK_QUARKUS_ADMIN_PASSWORD_PROP = "KC_BOOTSTRAP_ADMIN_PASSWORD";
    private static final String KEYCLOAK_QUARKUS_START_CMD = "start --http-enabled=true --hostname-strict=false --spi-user-profile-declarative-user-profile-config-file=/opt/keycloak/upconfig.json";
    private static final String JAVA_OPTS = "JAVA_OPTS";
    private static final String OIDC_USERS = "oidc.users";
    private static final String KEYCLOAK_REALMS = "keycloak.realms";
    private static final String DEV_SERVICE_LABEL = "quarkus-dev-service-keycloak";
    private static final ContainerLocator KEYCLOAK_DEV_MODE_CONTAINER_LOCATOR = ContainerLocator.locateContainerWithLabels((int)8080, (String[])new String[]{"quarkus-dev-service-keycloak"});
    private static volatile DevServicesResultBuildItem.RunningDevService devService;
    private static volatile KeycloakDevServicesConfig capturedDevServicesConfiguration;
    private static volatile boolean first;
    private static volatile Set<FileTime> capturedRealmFileLastModifiedDate;
    private static volatile Vertx vertxInstance;

    @BuildStep
    DevServicesResultBuildItem startKeycloakContainer(List<KeycloakDevServicesRequiredBuildItem> devSvcRequiredMarkerItems, DevServicesComposeProjectBuildItem composeProjectBuildItem, BuildProducer<KeycloakDevServicesConfigBuildItem> keycloakBuildItemBuildProducer, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, KeycloakDevServicesConfig config, CuratedApplicationShutdownBuildItem closeBuildItem, LaunchModeBuildItem launchMode, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, DevServicesConfig devServicesConfig, DockerStatusBuildItem dockerStatusBuildItem) {
        if (!devServicesConfig.enabled() || !config.enabled()) {
            LOG.debug((Object)"Not starting Dev Services for Keycloak as it has been disabled in the configuration");
            return null;
        }
        if (devSvcRequiredMarkerItems.isEmpty() || KeycloakDevServicesProcessor.oidcDevServicesEnabled() || KeycloakDevServicesProcessor.linuxContainersNotAvailable(dockerStatusBuildItem, devSvcRequiredMarkerItems)) {
            if (devService != null) {
                KeycloakDevServicesProcessor.closeDevService();
            }
            return null;
        }
        KeycloakDevServicesConfigurator devServicesConfigurator = KeycloakDevServicesRequiredBuildItem.getDevServicesConfigurator(devSvcRequiredMarkerItems);
        if (devService != null) {
            Set<FileTime> currentRealmFileLastModifiedDate;
            boolean restartRequired;
            boolean bl = restartRequired = !config.equals(capturedDevServicesConfiguration);
            if (!restartRequired && (currentRealmFileLastModifiedDate = KeycloakDevServicesProcessor.getRealmFileLastModifiedDate(config.realmPath())) != null && !currentRealmFileLastModifiedDate.equals(capturedRealmFileLastModifiedDate)) {
                restartRequired = true;
                capturedRealmFileLastModifiedDate = currentRealmFileLastModifiedDate;
            }
            if (!restartRequired) {
                DevServicesResultBuildItem result = devService.toBuildItem();
                String usersString = (String)result.getConfig().get(OIDC_USERS);
                Map users = usersString == null || usersString.isBlank() ? Map.of() : Arrays.stream(usersString.split(",")).map(s -> s.split("=")).collect(Collectors.toMap(s -> s[0], s -> s[1]));
                String realmsString = (String)result.getConfig().get(KEYCLOAK_REALMS);
                List realms = realmsString == null || realmsString.isBlank() ? List.of() : Arrays.stream(realmsString.split(",")).toList();
                keycloakBuildItemBuildProducer.produce((BuildItem)new KeycloakDevServicesConfigBuildItem(result.getConfig(), Map.of(OIDC_USERS, users, KEYCLOAK_REALMS, realms), false));
                return result;
            }
            KeycloakDevServicesProcessor.closeDevService();
        }
        capturedDevServicesConfiguration = config;
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Keycloak Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            ArrayList<String> errors = new ArrayList<String>();
            boolean useSharedNetwork = DevServicesSharedNetworkBuildItem.isSharedNetworkRequired((DevServicesConfig)devServicesConfig, devServicesSharedNetworkBuildItem);
            DevServicesResultBuildItem.RunningDevService newDevService = KeycloakDevServicesProcessor.startContainer(composeProjectBuildItem, keycloakBuildItemBuildProducer, useSharedNetwork, devServicesConfig.timeout(), errors, devServicesConfigurator);
            if (newDevService == null) {
                if (errors.isEmpty()) {
                    compressor.close();
                } else {
                    compressor.closeAndDumpCaptured();
                }
                return null;
            }
            devService = newDevService;
            if (first) {
                first = false;
                Runnable closeTask = new Runnable(){

                    @Override
                    public void run() {
                        if (devService != null) {
                            try {
                                devService.close();
                            }
                            catch (Throwable t) {
                                LOG.error((Object)"Failed to stop Keycloak container", t);
                            }
                        }
                        if (vertxInstance != null) {
                            try {
                                vertxInstance.close();
                            }
                            catch (Throwable t) {
                                LOG.error((Object)"Failed to close Vertx instance", t);
                            }
                        }
                        first = true;
                        devService = null;
                        capturedDevServicesConfiguration = null;
                        vertxInstance = null;
                        capturedRealmFileLastModifiedDate = null;
                    }
                };
                closeBuildItem.addCloseTask(closeTask, true);
            }
            capturedRealmFileLastModifiedDate = KeycloakDevServicesProcessor.getRealmFileLastModifiedDate(capturedDevServicesConfiguration.realmPath());
            if (devService != null && errors.isEmpty()) {
                compressor.close();
            } else {
                compressor.closeAndDumpCaptured();
            }
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
        LOG.info((Object)"Dev Services for Keycloak started.");
        return devService.toBuildItem();
    }

    private static boolean oidcDevServicesEnabled() {
        return ConfigProvider.getConfig().getOptionalValue("quarkus.oidc.devservices.enabled", Boolean.TYPE).orElse(false);
    }

    private static boolean linuxContainersNotAvailable(DockerStatusBuildItem dockerStatusBuildItem, List<KeycloakDevServicesRequiredBuildItem> devSvcRequiredMarkerItems) {
        if (dockerStatusBuildItem.isContainerRuntimeAvailable()) {
            return false;
        }
        for (KeycloakDevServicesRequiredBuildItem requirement : devSvcRequiredMarkerItems) {
            LOG.warnf("Please configure '%s' or get a working docker instance", (Object)requirement.getAuthServerUrl());
        }
        return true;
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void produceDevUiCardWithKeycloakUrl(Optional<KeycloakDevServicesConfigBuildItem> configProps, List<KeycloakAdminPageBuildItem> keycloakAdminPageBuildItems, BuildProducer<CardPageBuildItem> cardPageProducer) {
        String keycloakAdminUrl = KeycloakDevServicesConfigBuildItem.getKeycloakUrl(configProps);
        if (keycloakAdminUrl != null) {
            keycloakAdminPageBuildItems.forEach(i -> {
                i.cardPage.addPage((PageBuilder)((ExternalPageBuilder)Page.externalPageBuilder((String)"Keycloak Admin").icon("font-awesome-solid:key")).doNotEmbed(true).url(keycloakAdminUrl));
                cardPageProducer.produce((BuildItem)i.cardPage);
            });
        }
    }

    private static void closeDevService() {
        try {
            devService.close();
        }
        catch (Throwable e) {
            LOG.error((Object)"Failed to stop Keycloak container", e);
        }
        devService = null;
        capturedDevServicesConfiguration = null;
    }

    private static String getBaseURL(String scheme, String host, Integer port) {
        return scheme + host + ":" + port;
    }

    private static String startURL(String scheme, String host, Integer port, boolean isKeycloakX) {
        return KeycloakDevServicesProcessor.getBaseURL(scheme, host, port) + (isKeycloakX ? "" : "/auth");
    }

    private static String startURL(String baseUrl, boolean isKeycloakX) {
        return baseUrl + (isKeycloakX ? "" : "/auth");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> prepareConfiguration(BuildProducer<KeycloakDevServicesConfigBuildItem> keycloakBuildItemBuildProducer, String internalURL, String hostURL, List<RealmRepresentation> realmReps, List<String> errors, KeycloakDevServicesConfigurator devServicesConfigurator, String internalBaseUrl) {
        String realmName = !realmReps.isEmpty() ? realmReps.iterator().next().getRealm() : KeycloakDevServicesProcessor.getDefaultRealmName();
        String authServerInternalUrl = KeycloakDevServicesProcessor.realmsURL(internalURL, realmName);
        String clientAuthServerBaseUrl = hostURL != null ? hostURL : internalURL;
        String clientAuthServerUrl = KeycloakDevServicesProcessor.realmsURL(clientAuthServerBaseUrl, realmName);
        boolean createDefaultRealm = (realmReps == null || realmReps.isEmpty()) && capturedDevServicesConfiguration.createRealm();
        String oidcClientId = KeycloakDevServicesProcessor.getOidcClientId();
        String oidcClientSecret = KeycloakDevServicesProcessor.getOidcClientSecret();
        Map<String, String> users = KeycloakDevServicesProcessor.getUsers(capturedDevServicesConfiguration.users(), createDefaultRealm);
        LinkedList<String> realmNames = new LinkedList<String>();
        if (createDefaultRealm || !realmReps.isEmpty()) {
            if (vertxInstance == null) {
                vertxInstance = Vertx.vertx();
            }
            try (WebClient client = KeycloakDevServicesUtils.createWebClient(vertxInstance);){
                String adminToken = KeycloakDevServicesProcessor.getAdminToken(client, clientAuthServerBaseUrl);
                if (createDefaultRealm) {
                    KeycloakDevServicesProcessor.createDefaultRealm(client, adminToken, clientAuthServerBaseUrl, users, oidcClientId, oidcClientSecret, errors, devServicesConfigurator);
                    realmNames.add(realmName);
                } else if (realmReps != null) {
                    for (RealmRepresentation realmRep : realmReps) {
                        KeycloakDevServicesProcessor.createRealm(client, adminToken, clientAuthServerBaseUrl, realmRep, errors);
                        realmNames.add(realmRep.getRealm());
                    }
                }
            }
        }
        HashMap<String, String> configProperties = new HashMap<String, String>();
        KeycloakDevServicesConfigurator.ConfigPropertiesContext configPropertiesContext = new KeycloakDevServicesConfigurator.ConfigPropertiesContext(authServerInternalUrl, oidcClientId, oidcClientSecret, internalBaseUrl);
        configProperties.putAll(devServicesConfigurator.createProperties(configPropertiesContext));
        configProperties.put(KEYCLOAK_URL_KEY, internalURL);
        configProperties.put(CLIENT_AUTH_SERVER_URL_CONFIG_KEY, clientAuthServerUrl);
        configProperties.put(OIDC_USERS, users.entrySet().stream().map(Object::toString).collect(Collectors.joining(",")));
        configProperties.put(KEYCLOAK_REALMS, realmNames.stream().collect(Collectors.joining(",")));
        keycloakBuildItemBuildProducer.produce((BuildItem)new KeycloakDevServicesConfigBuildItem(configProperties, Map.of(OIDC_USERS, users, KEYCLOAK_REALMS, realmNames), true));
        return configProperties;
    }

    private static String realmsURL(String baseURL, String realmName) {
        return baseURL + "/realms/" + realmName;
    }

    private static String getDefaultRealmName() {
        return capturedDevServicesConfiguration.realmName().orElse("quarkus");
    }

    private static DevServicesResultBuildItem.RunningDevService startContainer(DevServicesComposeProjectBuildItem composeProjectBuildItem, BuildProducer<KeycloakDevServicesConfigBuildItem> keycloakBuildItemBuildProducer, boolean useSharedNetwork, Optional<Duration> timeout, List<String> errors, KeycloakDevServicesConfigurator devServicesConfigurator) {
        if (!capturedDevServicesConfiguration.enabled()) {
            LOG.debug((Object)"Not starting Dev Services for Keycloak as it has been disabled in the config");
            return null;
        }
        Optional maybeContainerAddress = KEYCLOAK_DEV_MODE_CONTAINER_LOCATOR.locateContainer(capturedDevServicesConfiguration.serviceName(), capturedDevServicesConfiguration.shared(), LaunchMode.current());
        String imageName = capturedDevServicesConfiguration.imageName();
        DockerImageName dockerImageName = DockerImageName.parse((String)imageName).asCompatibleSubstituteFor(imageName);
        Supplier<DevServicesResultBuildItem.RunningDevService> defaultKeycloakContainerSupplier = () -> {
            QuarkusOidcContainer oidcContainer = new QuarkusOidcContainer(dockerImageName, capturedDevServicesConfiguration.port(), composeProjectBuildItem.getDefaultNetworkId(), useSharedNetwork, capturedDevServicesConfiguration.realmPath().orElse(List.of()), KeycloakDevServicesProcessor.resourcesMap(errors), capturedDevServicesConfiguration.serviceName(), capturedDevServicesConfiguration.shared(), capturedDevServicesConfiguration.javaOpts(), capturedDevServicesConfiguration.startCommand(), capturedDevServicesConfiguration.features(), capturedDevServicesConfiguration.showLogs(), capturedDevServicesConfiguration.containerMemoryLimit(), errors);
            timeout.ifPresent(arg_0 -> ((QuarkusOidcContainer)oidcContainer).withStartupTimeout(arg_0));
            oidcContainer.withEnv(capturedDevServicesConfiguration.containerEnv());
            oidcContainer.start();
            String internalBaseUrl = KeycloakDevServicesProcessor.getBaseURL(oidcContainer.isHttps() ? "https://" : "http://", oidcContainer.getHost(), oidcContainer.getPort());
            String internalUrl = KeycloakDevServicesProcessor.startURL(internalBaseUrl, oidcContainer.keycloakX);
            String hostUrl = oidcContainer.useSharedNetwork ? KeycloakDevServicesProcessor.startURL("http://", oidcContainer.getSharedNetworkExternalHost(), oidcContainer.getSharedNetworkExternalPort(), oidcContainer.keycloakX) : null;
            Map<String, String> configs = KeycloakDevServicesProcessor.prepareConfiguration(keycloakBuildItemBuildProducer, internalUrl, hostUrl, oidcContainer.realmReps, errors, devServicesConfigurator, internalBaseUrl);
            return new DevServicesResultBuildItem.RunningDevService(KEYCLOAK_CONTAINER_NAME, oidcContainer.getContainerId(), () -> ((QuarkusOidcContainer)oidcContainer).close(), configs);
        };
        return maybeContainerAddress.or(() -> ComposeLocator.locateContainer((DevServicesComposeProjectBuildItem)composeProjectBuildItem, List.of(imageName, KEYCLOAK_CONTAINER_NAME), (int)8080, (LaunchMode)LaunchMode.current(), (boolean)useSharedNetwork)).map(containerAddress -> {
            String sharedContainerUrl = KeycloakDevServicesProcessor.getSharedContainerUrl(containerAddress);
            Map<String, String> configs = KeycloakDevServicesProcessor.prepareConfiguration(keycloakBuildItemBuildProducer, sharedContainerUrl, sharedContainerUrl, List.of(), errors, devServicesConfigurator, sharedContainerUrl);
            return new DevServicesResultBuildItem.RunningDevService(KEYCLOAK_CONTAINER_NAME, containerAddress.getId(), null, configs);
        }).orElseGet(defaultKeycloakContainerSupplier);
    }

    private static Map<String, String> resourcesMap(List<String> errors) {
        HashMap<String, String> resources = new HashMap<String, String>();
        for (Map.Entry<String, String> aliasEntry : capturedDevServicesConfiguration.resourceAliases().entrySet()) {
            if (capturedDevServicesConfiguration.resourceMappings().containsKey(aliasEntry.getKey())) {
                resources.put(aliasEntry.getValue(), capturedDevServicesConfiguration.resourceMappings().get(aliasEntry.getKey()));
                continue;
            }
            errors.add(String.format("%s alias for the %s resource does not have a mapping", aliasEntry.getKey(), aliasEntry.getValue()));
            LOG.errorf("%s alias for the %s resource does not have a mapping", (Object)aliasEntry.getKey(), (Object)aliasEntry.getValue());
        }
        return resources;
    }

    private static boolean isKeycloakX(DockerImageName dockerImageName) {
        return capturedDevServicesConfiguration.keycloakXImage().isPresent() ? capturedDevServicesConfiguration.keycloakXImage().get() : !dockerImageName.getVersionPart().endsWith(KEYCLOAK_LEGACY_IMAGE_VERSION_PART);
    }

    private static String getSharedContainerUrl(ContainerAddress containerAddress) {
        return "http://" + ("0.0.0.0".equals(containerAddress.getHost()) ? "localhost" : containerAddress.getHost()) + ":" + containerAddress.getPort();
    }

    private static Set<FileTime> getRealmFileLastModifiedDate(Optional<List<String>> realms) {
        if (realms.isPresent()) {
            HashSet<FileTime> times = new HashSet<FileTime>();
            for (String realm : realms.get()) {
                Path realmPath = Paths.get(realm, new String[0]);
                try {
                    times.add(Files.getLastModifiedTime(realmPath, new LinkOption[0]));
                }
                catch (IOException ex) {
                    LOG.tracef("Unable to get the last modified date of the realm file %s", (Object)realmPath);
                }
            }
            return times;
        }
        return null;
    }

    private static void createDefaultRealm(WebClient client, String token, String keycloakUrl, Map<String, String> users, String oidcClientId, String oidcClientSecret, List<String> errors, KeycloakDevServicesConfigurator devServicesConfigurator) {
        RealmRepresentation realm = KeycloakDevServicesProcessor.createDefaultRealmRep();
        if (capturedDevServicesConfiguration.createClient()) {
            realm.getClients().add(KeycloakDevServicesProcessor.createClient(oidcClientId, oidcClientSecret));
        }
        for (Map.Entry<String, String> entry : users.entrySet()) {
            realm.getUsers().add(KeycloakDevServicesProcessor.createUser(entry.getKey(), entry.getValue(), KeycloakDevServicesProcessor.getUserRoles(entry.getKey())));
        }
        devServicesConfigurator.customizeDefaultRealm(realm);
        KeycloakDevServicesProcessor.createRealm(client, token, keycloakUrl, realm, errors);
    }

    private static String getAdminToken(WebClient client, String keycloakUrl) {
        try {
            LOG.tracef("Acquiring admin token", new Object[0]);
            return (String)KeycloakDevServicesUtils.getPasswordAccessToken(client, keycloakUrl + "/realms/master/protocol/openid-connect/token", "admin-cli", null, "admin", "admin", null).await().atMost(capturedDevServicesConfiguration.webClientTimeout());
        }
        catch (TimeoutException e) {
            LOG.error((Object)"Admin token can not be acquired due to a client connection timeout. You may try increasing the `quarkus.keycloak.devservices.web-client-timeout` property.");
        }
        catch (Throwable t) {
            LOG.error((Object)"Admin token can not be acquired", t);
        }
        return null;
    }

    private static void createRealm(WebClient client, String token, String keycloakUrl, RealmRepresentation realm, List<String> errors) {
        try {
            LOG.tracef("Creating the realm %s", (Object)realm.getRealm());
            HttpResponse createRealmResponse = (HttpResponse)client.postAbs(keycloakUrl + "/admin/realms").putHeader(HttpHeaders.CONTENT_TYPE.toString(), "application/json").putHeader(HttpHeaders.AUTHORIZATION.toString(), "Bearer " + token).sendBuffer(Buffer.buffer().appendString(JsonSerialization.writeValueAsString((Object)realm))).await().atMost(capturedDevServicesConfiguration.webClientTimeout());
            if (createRealmResponse.statusCode() > 299) {
                errors.add(String.format("Realm %s can not be created %d - %s ", realm.getRealm(), createRealmResponse.statusCode(), createRealmResponse.statusMessage()));
                LOG.errorf("Realm %s can not be created %d - %s ", (Object)realm.getRealm(), (Object)createRealmResponse.statusCode(), (Object)createRealmResponse.statusMessage());
            }
            Uni realmStatusCodeUni = client.getAbs(keycloakUrl + "/realms/" + realm.getRealm()).send().onItem().transform(resp -> {
                LOG.debugf("Realm status: %d", resp.statusCode());
                if (resp.statusCode() == 200) {
                    LOG.debugf("Realm %s has been created", (Object)realm.getRealm());
                    return 200;
                }
                throw new RealmEndpointAccessException(resp.statusCode());
            }).onFailure(KeycloakDevServicesProcessor.realmEndpointNotAvailable()).retry().withBackOff(Duration.ofSeconds(2L), Duration.ofSeconds(2L)).expireIn(10000L).onFailure().transform(t -> new RuntimeException("Keycloak server is not available" + (String)(t.getMessage() != null ? ": " + t.getMessage() : "")));
            realmStatusCodeUni.await().atMost(Duration.ofSeconds(10L));
        }
        catch (Throwable t2) {
            errors.add(String.format("Realm %s can not be created: %s", realm.getRealm(), t2.getMessage()));
            LOG.errorf(t2, "Realm %s can not be created", (Object)realm.getRealm());
        }
    }

    private static Predicate<? super Throwable> realmEndpointNotAvailable() {
        return t -> t instanceof SocketException || t instanceof RealmEndpointAccessException && ((RealmEndpointAccessException)t).getErrorStatus() == 404;
    }

    private static Map<String, String> getUsers(Map<String, String> configuredUsers, boolean createRealm) {
        if (configuredUsers.isEmpty() && createRealm) {
            LinkedHashMap<String, String> users = new LinkedHashMap<String, String>();
            users.put("alice", "alice");
            users.put("bob", "bob");
            return users;
        }
        return configuredUsers;
    }

    private static List<String> getUserRoles(String user) {
        List<String> roles = capturedDevServicesConfiguration.roles().get(user);
        return roles == null ? ("alice".equals(user) ? List.of("admin", "user") : List.of("user")) : roles;
    }

    private static RealmRepresentation createDefaultRealmRep() {
        RealmRepresentation realm = new RealmRepresentation();
        realm.setRealm(KeycloakDevServicesProcessor.getDefaultRealmName());
        realm.setEnabled(Boolean.valueOf(true));
        realm.setUsers(new ArrayList());
        realm.setClients(new ArrayList());
        realm.setAccessTokenLifespan(Integer.valueOf(600));
        realm.setSsoSessionMaxLifespan(Integer.valueOf(600));
        realm.setRefreshTokenMaxReuse(Integer.valueOf(10));
        RolesRepresentation roles = new RolesRepresentation();
        ArrayList realmRoles = new ArrayList();
        roles.setRealm(realmRoles);
        realm.setRoles(roles);
        if (capturedDevServicesConfiguration.roles().isEmpty()) {
            realm.getRoles().getRealm().add(new RoleRepresentation("user", null, false));
            realm.getRoles().getRealm().add(new RoleRepresentation("admin", null, false));
        } else {
            HashSet<String> allRoles = new HashSet<String>();
            for (List<String> distinctRoles : capturedDevServicesConfiguration.roles().values()) {
                for (String role : distinctRoles) {
                    if (allRoles.contains(role)) continue;
                    allRoles.add(role);
                    realm.getRoles().getRealm().add(new RoleRepresentation(role, null, false));
                }
            }
        }
        return realm;
    }

    private static ClientRepresentation createClient(String clientId, String oidcClientSecret) {
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(clientId);
        client.setRedirectUris(List.of("*"));
        client.setPublicClient(Boolean.valueOf(false));
        client.setSecret(oidcClientSecret);
        client.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
        client.setServiceAccountsEnabled(Boolean.valueOf(true));
        client.setImplicitFlowEnabled(Boolean.valueOf(true));
        client.setEnabled(Boolean.valueOf(true));
        client.setRedirectUris(List.of("*"));
        client.setDefaultClientScopes(List.of("microprofile-jwt", "basic"));
        return client;
    }

    private static UserRepresentation createUser(String username, String password, List<String> realmRoles) {
        UserRepresentation user = new UserRepresentation();
        user.setUsername(username);
        user.setEnabled(Boolean.valueOf(true));
        user.setCredentials(new ArrayList());
        user.setRealmRoles(realmRoles);
        CredentialRepresentation credential = new CredentialRepresentation();
        credential.setType("password");
        credential.setValue(password);
        credential.setTemporary(Boolean.valueOf(false));
        user.getCredentials().add(credential);
        return user;
    }

    private static String getOidcClientId() {
        return ConfigProvider.getConfig().getOptionalValue(CLIENT_ID_CONFIG_KEY, String.class).orElse(capturedDevServicesConfiguration.createClient() ? "quarkus-app" : "");
    }

    private static String getOidcClientSecret() {
        return ConfigProvider.getConfig().getOptionalValue(CLIENT_SECRET_CONFIG_KEY, String.class).orElse(capturedDevServicesConfiguration.createClient() ? "secret" : "");
    }

    static {
        first = true;
    }

    private static class RealmEndpointAccessException
    extends RuntimeException {
        private final int errorStatus;

        public RealmEndpointAccessException(int errorStatus) {
            this.errorStatus = errorStatus;
        }

        public int getErrorStatus() {
            return this.errorStatus;
        }
    }

    private static class QuarkusOidcContainer
    extends GenericContainer<QuarkusOidcContainer> {
        private final OptionalInt fixedExposedPort;
        private final boolean useSharedNetwork;
        private final List<String> realmPaths;
        private final Map<String, String> resources;
        private final String containerLabelValue;
        private final Optional<String> javaOpts;
        private final boolean sharedContainer;
        private final String hostName;
        private final boolean keycloakX;
        private final List<RealmRepresentation> realmReps = new LinkedList<RealmRepresentation>();
        private final Optional<String> startCommand;
        private final Optional<Set<String>> features;
        private final boolean showLogs;
        private final MemorySize containerMemoryLimit;
        private final List<String> errors;

        public QuarkusOidcContainer(DockerImageName dockerImageName, OptionalInt fixedExposedPort, String defaultNetworkId, boolean useSharedNetwork, List<String> realmPaths, Map<String, String> resources, String containerLabelValue, boolean sharedContainer, Optional<String> javaOpts, Optional<String> startCommand, Optional<Set<String>> features, boolean showLogs, MemorySize containerMemoryLimit, List<String> errors) {
            super(dockerImageName);
            this.useSharedNetwork = useSharedNetwork;
            this.realmPaths = realmPaths;
            this.resources = resources;
            this.containerLabelValue = containerLabelValue;
            this.sharedContainer = sharedContainer;
            this.javaOpts = javaOpts;
            this.keycloakX = KeycloakDevServicesProcessor.isKeycloakX(dockerImageName);
            if (useSharedNetwork && fixedExposedPort.isEmpty()) {
                fixedExposedPort = OptionalInt.of(QuarkusOidcContainer.findRandomPort());
            }
            this.fixedExposedPort = fixedExposedPort;
            this.startCommand = startCommand;
            this.features = features;
            this.showLogs = showLogs;
            this.containerMemoryLimit = containerMemoryLimit;
            this.errors = errors;
            super.setWaitStrategy((WaitStrategy)Wait.forLogMessage((String)".*Keycloak.*started.*", (int)1));
            this.hostName = ConfigureUtil.configureNetwork((GenericContainer)this, (String)defaultNetworkId, (boolean)useSharedNetwork, (String)KeycloakDevServicesProcessor.KEYCLOAK_CONTAINER_NAME);
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                if (this.keycloakX) {
                    this.addEnv(KeycloakDevServicesProcessor.KEYCLOAK_QUARKUS_HOSTNAME, (this.isHttps() ? "https://" : "http://") + this.hostName + ":8080");
                } else {
                    this.addEnv(KeycloakDevServicesProcessor.KEYCLOAK_WILDFLY_FRONTEND_URL, "http://localhost:" + this.fixedExposedPort.getAsInt());
                }
            }
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), 8080);
                if (this.useSharedNetwork) {
                    this.addExposedPort(8080);
                }
            } else {
                this.addExposedPort(8080);
            }
            if (this.sharedContainer && LaunchMode.current() == LaunchMode.DEVELOPMENT) {
                this.withLabel(KeycloakDevServicesProcessor.DEV_SERVICE_LABEL, this.containerLabelValue);
                this.withLabel("io.quarkus.devservice", this.containerLabelValue);
            }
            if (this.javaOpts.isPresent()) {
                this.addEnv(KeycloakDevServicesProcessor.JAVA_OPTS, this.javaOpts.get());
            }
            if (this.keycloakX) {
                this.addEnv(KeycloakDevServicesProcessor.KEYCLOAK_QUARKUS_ADMIN_PROP, "admin");
                this.addEnv(KeycloakDevServicesProcessor.KEYCLOAK_QUARKUS_ADMIN_PASSWORD_PROP, "admin");
                Object finalStartCommand = this.startCommand.orElse(KeycloakDevServicesProcessor.KEYCLOAK_QUARKUS_START_CMD);
                if (this.features.isPresent()) {
                    finalStartCommand = (String)finalStartCommand + " --features=" + this.features.get().stream().collect(Collectors.joining(","));
                }
                this.withCommand((String)finalStartCommand);
                this.addUpConfigResource();
                if (this.isHttps()) {
                    this.addExposedPort(8443);
                }
            } else {
                this.addEnv(KeycloakDevServicesProcessor.KEYCLOAK_WILDFLY_USER_PROP, "admin");
                this.addEnv(KeycloakDevServicesProcessor.KEYCLOAK_WILDFLY_PASSWORD_PROP, "admin");
                this.addEnv(KeycloakDevServicesProcessor.KEYCLOAK_WILDFLY_VENDOR_PROP, KeycloakDevServicesProcessor.KEYCLOAK_WILDFLY_DB_VENDOR);
            }
            for (String string : this.realmPaths) {
                URL realmPathUrl = null;
                realmPathUrl = Thread.currentThread().getContextClassLoader().getResource(string);
                if (realmPathUrl != null) {
                    QuarkusOidcContainer.readRealmFile(realmPathUrl, string, this.errors).ifPresent(realmRep -> this.realmReps.add((RealmRepresentation)realmRep));
                    continue;
                }
                Path filePath = Paths.get(string, new String[0]);
                if (Files.exists(filePath, new LinkOption[0])) {
                    QuarkusOidcContainer.readRealmFile(filePath.toUri(), string, this.errors).ifPresent(realmRep -> this.realmReps.add((RealmRepresentation)realmRep));
                    continue;
                }
                this.errors.add(String.format("Realm %s resource is not available", string));
                LOG.debugf("Realm %s resource is not available", (Object)string);
            }
            for (Map.Entry entry : this.resources.entrySet()) {
                this.mapResource((String)entry.getKey(), (String)entry.getValue());
            }
            if (this.showLogs) {
                super.withLogConsumer(t -> LOG.info((Object)("Keycloak: " + t.getUtf8StringWithoutLineEnding())));
            }
            super.withCreateContainerCmdModifier(container -> Optional.ofNullable(container.getHostConfig()).ifPresent(hostConfig -> {
                long limit = this.containerMemoryLimit.asLongValue();
                hostConfig.withMemory(Long.valueOf(limit));
                LOG.debug((Object)("Set container memory limit (bytes): " + limit));
            }));
            LOG.infof("Using %s powered Keycloak distribution", (Object)(this.keycloakX ? "Quarkus" : "WildFly"));
        }

        private void mapResource(String resourcePath, String mappedResource) {
            if (Thread.currentThread().getContextClassLoader().getResource(resourcePath) != null) {
                LOG.debugf("Mapping the classpath %s resource to %s", (Object)resourcePath, (Object)mappedResource);
                this.withClasspathResourceMapping(resourcePath, mappedResource, BindMode.READ_ONLY);
            } else if (Files.exists(Paths.get(resourcePath, new String[0]), new LinkOption[0])) {
                LOG.debugf("Mapping the file system %s resource to %s", (Object)resourcePath, (Object)mappedResource);
                this.withFileSystemBind(resourcePath, mappedResource, BindMode.READ_ONLY);
            } else {
                this.errors.add(String.format("%s resource can not be mapped to %s because it is not available on the classpath and file system", resourcePath, mappedResource));
                LOG.errorf("%s resource can not be mapped to %s because it is not available on the classpath and file system", (Object)resourcePath, (Object)mappedResource);
            }
        }

        private void addUpConfigResource() {
            if (Thread.currentThread().getContextClassLoader().getResource("/dev-service/upconfig.json") != null) {
                LOG.debug((Object)"Mapping the classpath /dev-service/upconfig.json resource to /opt/keycloak/upconfig.json");
                this.withClasspathResourceMapping("/dev-service/upconfig.json", "/opt/keycloak/upconfig.json", BindMode.READ_ONLY);
            }
        }

        private static Integer findRandomPort() {
            Integer n;
            ServerSocket socket = new ServerSocket(0);
            try {
                n = socket.getLocalPort();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            socket.close();
            return n;
        }

        private static Optional<RealmRepresentation> readRealmFile(URI uri, String realmPath, List<String> errors) {
            try {
                return QuarkusOidcContainer.readRealmFile(uri.toURL(), realmPath, errors);
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }

        private static Optional<RealmRepresentation> readRealmFile(URL url, String realmPath, List<String> errors) {
            Optional<RealmRepresentation> optional;
            block8: {
                InputStream is = url.openStream();
                try {
                    optional = Optional.of((RealmRepresentation)JsonSerialization.readValue((InputStream)is, RealmRepresentation.class));
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        errors.add(String.format("Realm %s resource can not be opened: %s", realmPath, ex.getMessage()));
                        LOG.errorf("Realm %s resource can not be opened: %s", (Object)realmPath, (Object)ex.getMessage());
                        return Optional.empty();
                    }
                }
                is.close();
            }
            return optional;
        }

        public String getHost() {
            if (this.useSharedNetwork) {
                return this.hostName;
            }
            return super.getHost();
        }

        private String getSharedNetworkExternalHost() {
            return super.getHost();
        }

        private int getSharedNetworkExternalPort() {
            return this.getFirstMappedPort();
        }

        public int getPort() {
            if (this.useSharedNetwork) {
                return 8080;
            }
            if (this.fixedExposedPort.isPresent()) {
                return this.fixedExposedPort.getAsInt();
            }
            return super.getMappedPort(this.isHttps() ? 8443 : 8080);
        }

        public boolean isHttps() {
            return this.startCommand.isPresent() && this.startCommand.get().contains("--https");
        }
    }
}

