/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.db2.deployment;

import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceContainerConfig;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProviderBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.DevServicesComposeProjectBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.dev.devservices.DevServicesConfig;
import io.quarkus.devservices.common.ComposeLocator;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerAddress;
import io.quarkus.devservices.common.ContainerShutdownCloseable;
import io.quarkus.devservices.common.JBossLoggingConsumer;
import io.quarkus.devservices.common.Labels;
import io.quarkus.devservices.common.Volumes;
import io.quarkus.devservices.db2.deployment.DB2DatasourceServiceConfigurator;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.testcontainers.containers.Db2Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class DB2DevServicesProcessor {
    private static final Logger LOG = Logger.getLogger(DB2DevServicesProcessor.class);
    private static final DB2DatasourceServiceConfigurator configurator = new DB2DatasourceServiceConfigurator();

    @BuildStep
    DevServicesDatasourceProviderBuildItem setupDB2(final List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, final DevServicesComposeProjectBuildItem composeProjectBuildItem, final DevServicesConfig devServicesConfig) {
        return new DevServicesDatasourceProviderBuildItem("db2", new DevServicesDatasourceProvider(){

            public DevServicesDatasourceProvider.RunningDevServicesDatasource startDatabase(Optional<String> username, Optional<String> password, String datasourceName, DevServicesDatasourceContainerConfig containerConfig, LaunchMode launchMode, Optional<Duration> startupTimeout) {
                boolean useSharedNetwork = DevServicesSharedNetworkBuildItem.isSharedNetworkRequired((DevServicesConfig)devServicesConfig, (List)devServicesSharedNetworkBuildItem);
                String effectiveUsername = containerConfig.getUsername().orElse(username.orElse("quarkus"));
                String effectivePassword = containerConfig.getPassword().orElse(password.orElse("quarkus"));
                String effectiveDbName = containerConfig.getDbName().orElse(DataSourceUtil.isDefault((String)datasourceName) ? "quarkus" : datasourceName);
                Supplier<DevServicesDatasourceProvider.RunningDevServicesDatasource> maybe = () -> {
                    QuarkusDb2Container container = new QuarkusDb2Container(containerConfig.getImageName(), containerConfig.getFixedExposedPort(), composeProjectBuildItem.getDefaultNetworkId(), useSharedNetwork);
                    startupTimeout.ifPresent(arg_0 -> ((QuarkusDb2Container)container).withStartupTimeout(arg_0));
                    container.withUsername(effectiveUsername).withPassword(effectivePassword).withDatabaseName(effectiveDbName).withReuse(containerConfig.isReuse());
                    Labels.addDataSourceLabel((GenericContainer)container, (String)datasourceName);
                    Volumes.addVolumes((GenericContainer)container, (Map)containerConfig.getVolumes());
                    container.withEnv(containerConfig.getContainerEnv());
                    containerConfig.getAdditionalJdbcUrlProperties().forEach((arg_0, arg_1) -> ((QuarkusDb2Container)container).withUrlParam(arg_0, arg_1));
                    containerConfig.getCommand().ifPresent(arg_0 -> ((QuarkusDb2Container)container).setCommand(arg_0));
                    containerConfig.getInitScriptPath().ifPresent(arg_0 -> ((QuarkusDb2Container)container).withInitScripts(arg_0));
                    if (containerConfig.isShowLogs()) {
                        container.withLogConsumer((Consumer)new JBossLoggingConsumer(LOG));
                    }
                    container.start();
                    LOG.info((Object)"Dev Services for IBM Db2 started.");
                    return new DevServicesDatasourceProvider.RunningDevServicesDatasource(container.getContainerId(), container.getEffectiveJdbcUrl(), container.getReactiveUrl(), container.getUsername(), container.getPassword(), (Closeable)new ContainerShutdownCloseable((GenericContainer)container, "IBM Db2"));
                };
                List<String> images = List.of(containerConfig.getImageName().orElseGet(() -> ConfigureUtil.getDefaultImageNameFor((String)"db2")), "db2");
                return ComposeLocator.locateContainer((DevServicesComposeProjectBuildItem)composeProjectBuildItem, images, (int)50000, (LaunchMode)launchMode, (boolean)useSharedNetwork).map(containerAddress -> configurator.composeRunningService((ContainerAddress)containerAddress, containerConfig)).orElseGet(maybe);
            }
        });
    }

    private static class QuarkusDb2Container
    extends Db2Container {
        private final OptionalInt fixedExposedPort;
        private final boolean useSharedNetwork;
        private final String hostName;

        public QuarkusDb2Container(Optional<String> imageName, OptionalInt fixedExposedPort, String defaultNetworkId, boolean useSharedNetwork) {
            super(DockerImageName.parse((String)imageName.orElseGet(() -> ConfigureUtil.getDefaultImageNameFor((String)"db2"))).asCompatibleSubstituteFor(DockerImageName.parse((String)"icr.io/db2_community/db2")));
            this.fixedExposedPort = fixedExposedPort;
            this.useSharedNetwork = useSharedNetwork;
            this.hostName = ConfigureUtil.configureNetwork((GenericContainer)this, (String)defaultNetworkId, (boolean)useSharedNetwork, (String)"db2");
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                return;
            }
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), 50000);
            } else {
                this.addExposedPorts(new int[]{50000});
            }
        }

        public String getEffectiveJdbcUrl() {
            if (this.useSharedNetwork) {
                String additionalUrlParams = this.constructUrlParameters(":", ";", ";");
                return "jdbc:db2://" + this.hostName + ":50000/" + this.getDatabaseName() + additionalUrlParams;
            }
            return super.getJdbcUrl();
        }

        public String getReactiveUrl() {
            return this.getEffectiveJdbcUrl().replaceFirst("jdbc:", "vertx-reactive:");
        }
    }
}

