/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import io.quarkus.runtime.annotations.Recorder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@Recorder
public class JVMChecksRecorder {
    public void disableUnsafeRelatedWarnings() {
        if (Runtime.version().feature() < 24) {
            return;
        }
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Method trySetMemoryAccessWarnedMethod = unsafeClass.getDeclaredMethod("trySetMemoryAccessWarned", new Class[0]);
            trySetMemoryAccessWarnedMethod.setAccessible(true);
            trySetMemoryAccessWarnedMethod.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }
}

