package io.quarkus;

import static java.lang.annotation.ElementType.CONSTRUCTOR;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.LOCAL_VARIABLE;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.PACKAGE;
import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.SOURCE;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * The {@code @Generated} annotation is used to mark source code that has been generated during the gRPC generation phase.
 * Classes generated by {@code protoc} are post-processed to remove the {@code jakarta.annotation.Generated} and use
 * this annotation instead, avoiding a dependency on a pre-jakarta annotation.
 * <p>
 * This class is a direct copy of {@code jakarta.annotation.Generated}.
 */
@Documented
@Retention(SOURCE)
@Target({ PACKAGE, TYPE, METHOD, CONSTRUCTOR, FIELD,
        LOCAL_VARIABLE, PARAMETER })
public @interface Generated {

    /**
     * The value element MUST have the name of the code generator. The
     * name is the fully qualified name of the code generator.
     *
     * @return The name of the code generator
     */
    String[] value();

    /**
     * Date when the source was generated. The date element must follow the ISO
     * 8601 standard. For example the date element would have the following
     * value 2017-07-04T12:08:56.235-0700 which represents 2017-07-04 12:08:56
     * local time in the U.S. Pacific Time zone.
     *
     * @return The date the source was generated
     */
    String date() default "";

    /**
     * A placeholder for any comments that the code generator may want to
     * include in the generated code.
     *
     * @return Comments that the code generated included
     */
    String comments() default "";
}
