/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import io.quarkus.bootstrap.logging.InitialConfigurator;
import io.quarkus.bootstrap.runner.RunnerClassLoader;
import io.quarkus.runtime.Application;
import io.quarkus.runtime.ImageMode;
import io.quarkus.runtime.PreventFurtherStepsException;
import io.quarkus.runtime.QuarkusApplication;
import io.quarkus.runtime.QuarkusBindException;
import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.runtime.graal.DiagnosticPrinter;
import io.quarkus.runtime.util.ExceptionUtil;
import io.quarkus.runtime.util.StringUtil;
import io.smallrye.config.ConfigValidationException;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import org.jboss.logging.Logger;
import org.jboss.logmanager.handlers.AsyncHandler;
import org.wildfly.common.lock.Locks;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class ApplicationLifecycleManager {
    public static volatile ShutdownEvent.ShutdownReason shutdownReason = ShutdownEvent.ShutdownReason.STANDARD;
    private static final BiConsumer<Integer, Throwable> MAIN_EXIT_CODE_HANDLER = new BiConsumer<Integer, Throwable>(){

        @Override
        public void accept(Integer integer, Throwable cause) {
            Logger logger = Logger.getLogger(Application.class);
            logger.debugf("Shutting down with exit code %s", (Object)integer);
            if (logger.isTraceEnabled()) {
                logger.tracef((Throwable)new RuntimeException("Shutdown Stack Trace"), "Shutdown triggered", new Object[0]);
            }
            System.exit(integer);
        }
    };
    private static final Consumer<Boolean> NOOP_ALREADY_STARTED_CALLBACK = new Consumer<Boolean>(){

        @Override
        public void accept(Boolean t) {
        }
    };
    private static volatile BiConsumer<Integer, Throwable> defaultExitCodeHandler = MAIN_EXIT_CODE_HANDLER;
    private static final String DISABLE_SIGNAL_HANDLERS = "DISABLE_SIGNAL_HANDLERS";
    private static final Lock stateLock = Locks.reentrantLock();
    private static final Condition stateCond = stateLock.newCondition();
    private static ShutdownHookThread shutdownHookThread;
    private static int exitCode;
    private static volatile boolean shutdownRequested;
    private static volatile Application currentApplication;
    private static boolean vmShuttingDown;
    private static Consumer<Boolean> alreadyStartedCallback;
    private static final boolean IS_WINDOWS;
    private static final boolean IS_MAC;
    public static final String QUARKUS_APPCDS_GENERATE_PROP = "quarkus.appcds.generate";

    private ApplicationLifecycleManager() {
    }

    public static void run(Application application, String ... args) {
        ApplicationLifecycleManager.run(application, null, null, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(Application application, Class<? extends QuarkusApplication> quarkusApplication, BiConsumer<Integer, Throwable> exitCodeHandler, String ... args) {
        boolean alreadyStarted;
        block52: {
            stateLock.lock();
            try {
                alreadyStarted = application.isStarted();
                alreadyStartedCallback.accept(alreadyStarted);
                if (shutdownHookThread == null) {
                    ApplicationLifecycleManager.registerHooks(exitCodeHandler == null ? defaultExitCodeHandler : exitCodeHandler);
                }
                if (currentApplication != null && !shutdownRequested) {
                    throw new IllegalStateException("Quarkus already running");
                }
                exitCode = -1;
                shutdownRequested = false;
                currentApplication = application;
            }
            finally {
                stateLock.unlock();
            }
            try {
                application.start(args);
                if (quarkusApplication != null && !ApplicationLifecycleManager.isAppCDSGeneration()) {
                    QuarkusApplication instance;
                    BeanManager beanManager = CDI.current().getBeanManager();
                    Set beans = beanManager.getBeans(quarkusApplication, new Annotation[]{Any.Literal.INSTANCE});
                    Bean bean = null;
                    for (Bean i : beans) {
                        if (i.getBeanClass() != quarkusApplication) continue;
                        bean = i;
                        break;
                    }
                    if (bean == null) {
                        instance = quarkusApplication.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    } else {
                        CreationalContext ctx = beanManager.createCreationalContext(bean);
                        instance = (QuarkusApplication)beanManager.getReference(bean, quarkusApplication, ctx);
                    }
                    int result = -1;
                    try {
                        result = instance.run(args);
                        break block52;
                    }
                    finally {
                        stateLock.lock();
                        try {
                            if (exitCode == -1 && result != -1) {
                                exitCode = result;
                            }
                            shutdownRequested = true;
                            stateCond.signalAll();
                        }
                        finally {
                            stateLock.unlock();
                        }
                    }
                }
                ApplicationLifecycleManager.longLivedPostBootCleanup();
                stateLock.lock();
                try {
                    while (!shutdownRequested) {
                        Thread.interrupted();
                        stateCond.awaitUninterruptibly();
                    }
                }
                finally {
                    stateLock.unlock();
                }
            }
            catch (Exception e) {
                Throwable rootCause = ExceptionUtil.getRootCause(e);
                if (exitCodeHandler == null) {
                    Logger applicationLogger = Logger.getLogger(Application.class);
                    if (rootCause instanceof QuarkusBindException) {
                        QuarkusBindException qbe = (QuarkusBindException)rootCause;
                        String host = qbe.getHost();
                        int port = qbe.getPort();
                        if (QuarkusBindException.isKnownHost(host)) {
                            applicationLogger.errorf("Port %d seems to be in use by another process. Quarkus may already be running or the port is used by another application.", (Object)port);
                            if (IS_WINDOWS) {
                                applicationLogger.warn((Object)"Use 'netstat -a -b -n -o' to identify the process occupying the port.");
                                applicationLogger.warn((Object)"You can try to kill it with 'taskkill /PID <pid>' or via the Task Manager.");
                            } else if (IS_MAC) {
                                applicationLogger.warnf("Use 'netstat -anv | grep %d' to identify the process occupying the port.", (Object)port);
                                applicationLogger.warn((Object)"You can try to kill it with 'kill -9 <pid>'.");
                            } else {
                                applicationLogger.warnf("Use 'ss -anop | grep %1$d' or 'netstat -anop | grep %1$d' to identify the process occupying the port.", (Object)port);
                                applicationLogger.warn((Object)"You can try to kill it with 'kill -9 <pid>'.");
                            }
                        } else {
                            applicationLogger.errorf("Unable to bind to host: %s and port: %d.", (Object)host, (Object)port);
                        }
                    } else if (rootCause instanceof ConfigurationException || rootCause instanceof ConfigValidationException) {
                        System.err.println(rootCause.getMessage());
                    } else if (rootCause instanceof PreventFurtherStepsException && !StringUtil.isNullOrEmpty(rootCause.getMessage())) {
                        System.err.println(rootCause.getMessage());
                    } else {
                        applicationLogger.errorv((Throwable)e, "Failed to start application", new Object[0]);
                        ApplicationLifecycleManager.ensureConsoleLogsDrained();
                    }
                }
                stateLock.lock();
                try {
                    shutdownRequested = true;
                    stateCond.signalAll();
                }
                finally {
                    stateLock.unlock();
                }
                application.stop();
                int exceptionExitCode = rootCause instanceof PreventFurtherStepsException ? ((PreventFurtherStepsException)rootCause).getExitCode() : 1;
                currentApplication = null;
                (exitCodeHandler == null ? defaultExitCodeHandler : exitCodeHandler).accept(exceptionExitCode, e);
                return;
            }
            finally {
                try {
                    ShutdownHookThread sh = shutdownHookThread;
                    shutdownHookThread = null;
                    if (sh != null) {
                        Runtime.getRuntime().removeShutdownHook(sh);
                    }
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
        if (!alreadyStarted) {
            application.stop();
        }
        currentApplication = null;
        (exitCodeHandler == null ? defaultExitCodeHandler : exitCodeHandler).accept(ApplicationLifecycleManager.getExitCode(), null);
    }

    private static void ensureConsoleLogsDrained() {
        AsyncHandler asyncHandler = null;
        for (Handler handler : InitialConfigurator.DELAYED_HANDLER.getHandlers()) {
            if (handler instanceof AsyncHandler) {
                asyncHandler = (AsyncHandler)handler;
                Handler[] nestedHandlers = asyncHandler.getHandlers();
                boolean foundNestedConsoleHandler = false;
                for (Handler nestedHandler : nestedHandlers) {
                    if (!(nestedHandler instanceof ConsoleHandler)) continue;
                    foundNestedConsoleHandler = true;
                    break;
                }
                if (!foundNestedConsoleHandler) {
                    asyncHandler = null;
                }
            }
            if (asyncHandler != null) break;
        }
        if (asyncHandler != null) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static void longLivedPostBootCleanup() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl instanceof RunnerClassLoader) {
            RunnerClassLoader rcl = (RunnerClassLoader)cl;
            rcl.resetInternalCaches();
        }
    }

    private static void registerHooks(BiConsumer<Integer, Throwable> exitCodeHandler) {
        if (ImageMode.current() == ImageMode.NATIVE_RUN && System.getenv(DISABLE_SIGNAL_HANDLERS) == null) {
            ApplicationLifecycleManager.registerSignalHandlers(exitCodeHandler);
        }
        shutdownHookThread = new ShutdownHookThread();
        Runtime.getRuntime().addShutdownHook(shutdownHookThread);
    }

    private static void registerSignalHandlers(final BiConsumer<Integer, Throwable> exitCodeHandler) {
        SignalHandler exitHandler = new SignalHandler(){

            @Override
            public void handle(Signal signal) {
                Logger applicationLogger = Logger.getLogger(Application.class);
                applicationLogger.debugf("Received signed %s, shutting down", signal.getNumber());
                exitCodeHandler.accept(signal.getNumber() + 128, null);
            }
        };
        SignalHandler diagnosticsHandler = new SignalHandler(){

            @Override
            public void handle(Signal signal) {
                DiagnosticPrinter.printDiagnostics(System.out);
            }
        };
        ApplicationLifecycleManager.handleSignal("INT", exitHandler);
        ApplicationLifecycleManager.handleSignal("TERM", exitHandler);
        if (IS_WINDOWS) {
            ApplicationLifecycleManager.handleSignal("BREAK", diagnosticsHandler);
        } else {
            ApplicationLifecycleManager.handleSignal("HUP", exitHandler);
            ApplicationLifecycleManager.handleSignal("QUIT", diagnosticsHandler);
        }
    }

    public static Application getCurrentApplication() {
        return currentApplication;
    }

    public static int getExitCode() {
        return exitCode == -1 ? 0 : exitCode;
    }

    public static void exit() {
        ApplicationLifecycleManager.exit(-1);
    }

    public static BiConsumer<Integer, Throwable> getDefaultExitCodeHandler() {
        return defaultExitCodeHandler;
    }

    public static boolean isVmShuttingDown() {
        return vmShuttingDown;
    }

    public static void setDefaultExitCodeHandler(BiConsumer<Integer, Throwable> defaultExitCodeHandler) {
        if (defaultExitCodeHandler == null) {
            defaultExitCodeHandler = MAIN_EXIT_CODE_HANDLER;
        }
        ApplicationLifecycleManager.defaultExitCodeHandler = defaultExitCodeHandler;
    }

    public static void setDefaultExitCodeHandler(Consumer<Integer> defaultExitCodeHandler) {
        BiConsumer<Integer, Throwable> biConsumer = defaultExitCodeHandler == null ? null : (exitCode, cause) -> defaultExitCodeHandler.accept((Integer)exitCode);
        ApplicationLifecycleManager.setDefaultExitCodeHandler(biConsumer);
    }

    public static void setAlreadyStartedCallback(Consumer<Boolean> alreadyStartedCallback) {
        ApplicationLifecycleManager.alreadyStartedCallback = alreadyStartedCallback != null ? alreadyStartedCallback : NOOP_ALREADY_STARTED_CALLBACK;
    }

    public static void exit(int code) {
        stateLock.lock();
        try {
            if (code >= 0 && exitCode == -1) {
                exitCode = code;
            }
            if (shutdownRequested) {
                return;
            }
            shutdownRequested = true;
            stateCond.signalAll();
        }
        finally {
            stateLock.unlock();
        }
    }

    public static void waitForExit() {
        stateLock.lock();
        try {
            while (!shutdownRequested) {
                stateCond.awaitUninterruptibly();
            }
        }
        finally {
            stateLock.unlock();
        }
    }

    private static void handleSignal(String signal, SignalHandler handler) {
        try {
            Signal.handle(new Signal(signal), handler);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static boolean isAppCDSGeneration() {
        return Boolean.parseBoolean(System.getProperty(QUARKUS_APPCDS_GENERATE_PROP, "false"));
    }

    static {
        exitCode = -1;
        alreadyStartedCallback = NOOP_ALREADY_STARTED_CALLBACK;
        IS_WINDOWS = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
        IS_MAC = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("mac");
    }

    static class ShutdownHookThread
    extends Thread {
        ShutdownHookThread() {
            super("Shutdown thread");
            this.setDaemon(false);
        }

        @Override
        public void run() {
            stateLock.lock();
            vmShuttingDown = true;
            shutdownRequested = true;
            shutdownReason = ShutdownEvent.ShutdownReason.NON_STANDARD;
            try {
                stateCond.signalAll();
            }
            finally {
                stateLock.unlock();
            }
            Application app = currentApplication;
            if (app != null) {
                if (app.isStarted()) {
                    app.stop();
                }
                app.awaitShutdown();
            }
            currentApplication = null;
            System.out.flush();
            System.err.flush();
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }
}

